/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Rejar {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejar(File out, File modules) throws IOException {
        HashMap<String, ByteArrayOutputStream> metadata = new HashMap<String, ByteArrayOutputStream>();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(out);
            HashSet<String> names = new HashSet<String>();
            names.add(Attributes.Name.MAIN_CLASS.toString());
            JarOutputStream jos = null;
            try {
                jos = new JarOutputStream((OutputStream)fos, this.getManifest());
                this.processDirectory(jos, modules, names, metadata);
                for (File directory : modules.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                })) {
                    this.processDirectory(jos, directory, names, metadata);
                }
                for (Map.Entry entry : metadata.entrySet()) {
                    this.copy(((ByteArrayOutputStream)entry.getValue()).toByteArray(), (String)entry.getKey(), jos);
                }
                jos.flush();
            }
            finally {
                if (jos != null) {
                    try {
                        jos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Manifest getManifest() throws IOException {
        Manifest m = new Manifest();
        m.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        m.getMainAttributes().put(Attributes.Name.MAIN_CLASS, "com.sun.enterprise.glassfish.bootstrap.ASMain");
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDirectory(JarOutputStream jos, File directory, Set<String> names, Map<String, ByteArrayOutputStream> metadata) throws IOException {
        for (File module : directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith("jar");
            }
        })) {
            JarFile in = new JarFile(module);
            try {
                Enumeration<JarEntry> entries = in.entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    if (je.getName().endsWith("MANIFEST.MF") || names.contains(je.getName()) || je.isDirectory()) continue;
                    if (je.getName().startsWith("META-INF/inhabitants/") || je.getName().startsWith("META-INF/services/")) {
                        ByteArrayOutputStream stream = metadata.get(je.getName());
                        if (stream == null) {
                            stream = new ByteArrayOutputStream();
                            metadata.put(je.getName(), stream);
                        }
                        stream.write(("# from " + module.getName() + "\n").getBytes());
                        this.copy(in, je, stream);
                        continue;
                    }
                    names.add(je.getName());
                    this.copy(in, je, jos);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(JarFile in, JarEntry je, JarOutputStream jos) throws IOException {
        try {
            jos.putNextEntry(new JarEntry(je.getName()));
            this.copy(in, je, (OutputStream)jos);
        }
        finally {
            jos.flush();
            jos.closeEntry();
        }
    }

    protected void copy(JarFile in, JarEntry je, OutputStream os) throws IOException {
        this.copy(in, je, Channels.newChannel(os));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(JarFile in, JarEntry je, WritableByteChannel out) throws IOException {
        try (InputStream is = in.getInputStream(je);){
            ReadableByteChannel inChannel = Channels.newChannel(is);
            ByteBuffer byteBuffer = ByteBuffer.allocate(Long.valueOf(je.getSize()).intValue());
            inChannel.read(byteBuffer);
            byteBuffer.rewind();
            out.write(byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(byte[] bytes, String name, JarOutputStream jos) throws IOException {
        try {
            jos.putNextEntry(new JarEntry(name));
            jos.write(bytes);
        }
        finally {
            jos.closeEntry();
        }
    }
}

