/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.generate;

import com.sun.faces.config.beans.ComponentBean;
import com.sun.faces.config.beans.FacesConfigBean;
import com.sun.faces.config.beans.PropertyBean;
import com.sun.faces.generate.AbstractGenerator;
import com.sun.faces.generate.GeneratorUtil;
import com.sun.faces.generate.PropertyManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AttributeManagerGenerator
extends AbstractGenerator {
    private static final String TARGET_PACKAGE = "com.sun.faces.renderkit";
    private static final String TARGET_CLASSNAME = "AttributeManager";
    private PropertyManager manager;
    private List<String> imports;

    public AttributeManagerGenerator(PropertyManager manager) {
        this.manager = manager;
    }

    @Override
    public void generate(FacesConfigBean configBean) {
        try {
            AbstractGenerator.CodeWriter writer = this.getCodeWriter();
            this.writeCopyright(writer);
            this.writePackage(writer);
            this.writeImports(writer);
            this.writeClassDocumentation(writer);
            this.writeClassDeclaration(writer);
            this.writeClassBody(writer, configBean);
            this.writeClassEnd(writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        PropertyManager propManager = PropertyManager.newInstance(args[0]);
        AttributeManagerGenerator generator = new AttributeManagerGenerator(propManager);
        generator.generate(GeneratorUtil.getConfigBean(args[1]));
    }

    private AbstractGenerator.CodeWriter getCodeWriter() throws IOException {
        FileWriter fWriter = new FileWriter(new File(this.getClassPackageDirectory(), "AttributeManager.java"));
        return new AbstractGenerator.CodeWriter(fWriter);
    }

    private File getClassPackageDirectory() {
        String packagePath = TARGET_PACKAGE.replace('.', File.separatorChar);
        File packageDir = new File(this.getBaseOutputDirectory(), packagePath);
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
        return packageDir;
    }

    private File getBaseOutputDirectory() {
        File outputDir = new File(System.getProperty("user.dir") + File.separatorChar + this.manager.getProperty("base.output.dir"));
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        return outputDir;
    }

    private void addImport(String fullyQualClassName) {
        if (this.imports == null) {
            this.imports = new ArrayList<String>();
        }
        this.imports.add(fullyQualClassName);
    }

    private void writeImports(AbstractGenerator.CodeWriter writer) throws Exception {
        this.addImport("java.util.Map");
        this.addImport("static com.sun.faces.util.CollectionsUtils.*");
        this.addImport("com.sun.faces.util.CollectionsUtils");
        this.addImport("static com.sun.faces.renderkit.Attribute.*");
        this.addImport("com.sun.faces.renderkit.Attribute");
        Collections.sort(this.imports);
        Iterator<String> i = this.imports.iterator();
        while (i.hasNext()) {
            writer.writeImport(i.next());
        }
        writer.write(10);
    }

    private void writeCopyright(AbstractGenerator.CodeWriter writer) throws Exception {
        writer.writeBlockComment(this.manager.getProperty("copyright"));
        writer.write(10);
    }

    private void writePackage(AbstractGenerator.CodeWriter writer) throws Exception {
        writer.writePackage(TARGET_PACKAGE);
        writer.write(10);
    }

    private void writeClassDocumentation(AbstractGenerator.CodeWriter writer) throws Exception {
        writer.writeJavadocComment("This class contains mappings between the standard components\nand the passthrough attributes associated with them.");
    }

    private void writeClassDeclaration(AbstractGenerator.CodeWriter writer) throws Exception {
        writer.writePublicClassDeclaration(TARGET_CLASSNAME, null, null, false, false);
    }

    private void writeClassBody(AbstractGenerator.CodeWriter writer, FacesConfigBean bean) throws Exception {
        writer.indent();
        writer.fwrite("private static Map<String,Attribute[]> ATTRIBUTE_LOOKUP=CollectionsUtils.<String,Attribute[]>map()\n");
        writer.indent();
        ComponentBean[] components = bean.getComponents();
        ArrayList<String> keys = new ArrayList<String>();
        for (ComponentBean comp : components) {
            String type;
            if (!comp.getComponentClass().contains("Html") || (type = comp.getRendererType()) == null) continue;
            String family = comp.getBaseComponentType();
            type = type.substring(type.lastIndexOf(46) + 1);
            family = family.substring(family.lastIndexOf(46) + 1);
            String key = family + type;
            PropertyBean[] props = comp.getProperties();
            boolean attributeWritten = false;
            for (PropertyBean aBean : props) {
                if (aBean.isPassThrough()) {
                    if ((key.contains("Radio") || "SelectManyCheckbox".equals(key)) && ("style".equals(aBean.getPropertyName()) || "border".equals(aBean.getPropertyName()))) continue;
                    if (attributeWritten) {
                        writer.fwrite(",attr(\"");
                    } else {
                        keys.add(key);
                        writer.fwrite(".add(\"");
                        writer.write(key);
                        writer.write("\",ar(\n");
                        writer.indent();
                        writer.fwrite("attr(\"");
                    }
                    writer.write(aBean.getPropertyName());
                    writer.write("\"");
                    if (aBean.getBehaviors() != null && !aBean.getBehaviors().isEmpty()) {
                        for (String behavior : aBean.getBehaviors()) {
                            String behaviorName;
                            writer.write(",\"");
                            if (0 == behavior.length()) {
                                behaviorName = aBean.getPropertyName();
                                if (behaviorName.length() > 2 && behaviorName.startsWith("on")) {
                                    StringBuilder buffer = new StringBuilder(behaviorName.substring(2, 3).toLowerCase());
                                    buffer.append(behaviorName.substring(3));
                                    behaviorName = buffer.toString();
                                }
                            } else {
                                behaviorName = behavior;
                            }
                            writer.write(behaviorName);
                            writer.write("\"");
                        }
                    }
                    writer.write(")\n");
                    attributeWritten = true;
                }
                if (!key.contains("Button") || !"onclick".equals(aBean.getPropertyName())) continue;
                aBean.setPassThrough(false);
            }
            if (!attributeWritten) continue;
            writer.outdent();
            writer.fwrite("))\n");
        }
        writer.fwrite(".fix();\n");
        writer.outdent();
        writer.fwrite("public enum Key {\n");
        writer.indent();
        int len = keys.size();
        for (int i = 0; i < len; ++i) {
            String key = (String)keys.get(i);
            writer.fwrite(key.toUpperCase() + "(\"" + key + "\")");
            if (i == len - 1) {
                writer.write(";\n");
                continue;
            }
            writer.write(",\n");
        }
        writer.fwrite("private String key;\n");
        writer.fwrite("Key(String key) {\n");
        writer.indent();
        writer.fwrite("this.key = key;\n");
        writer.outdent();
        writer.fwrite("}\n");
        writer.fwrite("public String value() {\n");
        writer.indent();
        writer.fwrite("return this.key;\n");
        writer.outdent();
        writer.fwrite("}\n");
        writer.outdent();
        writer.fwrite("}\n");
        writer.write("\n\n");
        writer.fwrite("public static Attribute[] getAttributes(Key key) {\n");
        writer.indent();
        writer.fwrite("return ATTRIBUTE_LOOKUP.get(key.value());\n");
        writer.outdent();
        writer.fwrite("}\n");
    }

    private void writeClassEnd(AbstractGenerator.CodeWriter writer) throws Exception {
        writer.outdent();
        writer.fwrite("}\n");
        writer.flush();
        writer.close();
    }
}

