/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateTask
extends Task {
    private String schemaDir;

    public void setSchemaDir(String schemaDir) {
        this.schemaDir = schemaDir;
    }

    public void execute() throws BuildException {
        File dir = new File(this.schemaDir);
        if (!dir.isDirectory()) {
            throw new BuildException("The schemaDir '" + this.schemaDir + "' is not a directory");
        }
        if (!dir.canRead()) {
            throw new BuildException("The schemaDir '" + this.schemaDir + "' cannot be read");
        }
        SAXParser parser = this.getParser();
        String file = this.schemaDir + File.separatorChar + "standard-html-renderkit.xml";
        try {
            parser.parse(new File(file), (DefaultHandler)new Resolver(this.schemaDir));
            System.out.println("The document, standard-html-renderkit.xml, is valid.");
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private SAXParser getParser() throws BuildException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        File schemaSource = new File(this.schemaDir + File.separatorChar + "web-facesconfig_2_0.xsd");
        try {
            SAXParser parser = factory.newSAXParser();
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSource);
            return parser;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static class Resolver
    extends DefaultHandler {
        private String j2ee14;
        private String webServices;
        private String xml;
        private String facesConfig;
        private MessageFormat message = new MessageFormat("({0}: {1}, {2}): {3}");

        public Resolver(String schemaDir) {
            String basePath = schemaDir + File.separatorChar;
            this.j2ee14 = basePath + "j2ee_1_4.xsd";
            this.webServices = basePath + "j2ee_web_services_client_1_1.xsd";
            this.xml = basePath + "xml.xsd";
            this.facesConfig = basePath + "web-facesconfig_1_2.xsd";
        }

        private String print(SAXParseException x) {
            String msg = this.message.format(new Object[]{x.getSystemId(), new Integer(x.getLineNumber()), new Integer(x.getColumnNumber()), x.getMessage()});
            return msg;
        }

        @Override
        public void warning(SAXParseException x) {
            System.out.println("WARNING: " + this.print(x));
        }

        @Override
        public void error(SAXParseException x) throws SAXParseException {
            System.out.println("ERROR: " + this.print(x));
            throw x;
        }

        @Override
        public void fatalError(SAXParseException x) throws SAXParseException {
            System.out.println("FATAL: " + this.print(x));
            throw x;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            InputSource source = null;
            if (systemId.indexOf("j2ee_1_4") > 0) {
                try {
                    source = new InputSource(new FileInputStream(this.j2ee14));
                    source.setSystemId(new File(this.j2ee14).toURL().toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (systemId.indexOf("webservice") > 0) {
                try {
                    source = new InputSource(new FileInputStream(this.webServices));
                    source.setSystemId(new File(this.webServices).toURL().toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (systemId.indexOf("xml.xsd") > 0) {
                try {
                    source = new InputSource(new FileInputStream(this.xml));
                    source.setSystemId(this.xml);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            } else if (systemId.indexOf("web-facesconfig_2_0.xsd") > 0) {
                try {
                    source = new InputSource(new FileInputStream(this.facesConfig));
                    source.setSystemId(new File(this.facesConfig).toURL().toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                try {
                    source = super.resolveEntity(publicId, systemId);
                    if (source != null && publicId != null) {
                        source.setPublicId(publicId);
                    }
                    if (source != null && systemId != null) {
                        source.setSystemId(systemId);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return source;
        }
    }
}

