/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.SpecializedBeanResolver;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public class SpecializationAndEnablementRegistry
extends AbstractBootstrapService {
    private final ComputingCache<BeanManagerImpl, SpecializedBeanResolver> specializedBeanResolvers;
    private final Map<BeanManagerImpl, BeanDeployerEnvironment> environmentByManager = new ConcurrentHashMap<BeanManagerImpl, BeanDeployerEnvironment>();
    private final ComputingCache<Bean<?>, Set<? extends AbstractBean<?, ?>>> specializedBeans;
    private final ConcurrentHashMap<AbstractBean<?, ?>, LongAdder> specializedBeansMap = new ConcurrentHashMap();

    public SpecializationAndEnablementRegistry() {
        ComputingCacheBuilder cacheBuilder = ComputingCacheBuilder.newBuilder();
        this.specializedBeanResolvers = cacheBuilder.build(new SpecializedBeanResolverForBeanManager());
        this.specializedBeans = ComputingCacheBuilder.newBuilder().build(new BeansSpecializedByBean());
    }

    public Set<? extends AbstractBean<?, ?>> resolveSpecializedBeans(Bean<?> specializingBean) {
        ProducerMethod producerMethod;
        AbstractClassBean abstractClassBean;
        if (specializingBean instanceof AbstractClassBean && (abstractClassBean = (AbstractClassBean)specializingBean).isSpecializing()) {
            return this.specializedBeans.getValue(specializingBean);
        }
        if (specializingBean instanceof ProducerMethod && (producerMethod = (ProducerMethod)specializingBean).isSpecializing()) {
            return this.specializedBeans.getValue(specializingBean);
        }
        return Collections.emptySet();
    }

    public void vetoSpecializingBean(Bean<?> bean) {
        Set<AbstractBean<?, ?>> noLongerSpecializedBeans = this.specializedBeans.getValueIfPresent(bean);
        if (noLongerSpecializedBeans != null) {
            this.specializedBeans.invalidate(bean);
            for (AbstractBean<?, ?> noLongerSpecializedBean : noLongerSpecializedBeans) {
                LongAdder count = this.specializedBeansMap.get(noLongerSpecializedBean);
                if (count == null) continue;
                count.decrement();
            }
        }
    }

    public boolean isSpecializedInAnyBeanDeployment(Bean<?> bean) {
        LongAdder count = this.specializedBeansMap.get(bean);
        return count != null && count.longValue() > 0L;
    }

    public boolean isEnabledInAnyBeanDeployment(Bean<?> bean) {
        for (BeanManagerImpl manager : this.environmentByManager.keySet()) {
            if (!manager.isBeanEnabled(bean)) continue;
            return true;
        }
        return false;
    }

    public boolean isCandidateForLifecycleEvent(Bean<?> bean) {
        AbstractProducerBean producer;
        if (bean instanceof AbstractProducerBean && !this.isCandidateForLifecycleEvent((producer = (AbstractProducerBean)Reflections.cast(bean)).getDeclaringBean())) {
            return false;
        }
        return this.isEnabledInAnyBeanDeployment(bean) && !this.isSpecializedInAnyBeanDeployment(bean);
    }

    public void registerEnvironment(BeanManagerImpl manager, BeanDeployerEnvironment environment, boolean additionalBeanArchive) {
        if (this.specializedBeanResolvers.size() > 0L && !additionalBeanArchive) {
            throw new IllegalStateException(this.getClass().getName() + ".registerEnvironment() must not be called after specialization resolution begins");
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment must not be null");
        }
        this.environmentByManager.put(manager, environment);
    }

    @Override
    public void cleanupAfterBoot() {
        this.specializedBeanResolvers.clear();
        this.environmentByManager.clear();
        this.specializedBeans.clear();
        this.specializedBeansMap.clear();
    }

    public Set<AbstractBean<?, ?>> getBeansSpecializedInAnyDeployment() {
        return ImmutableSet.copyOf(this.specializedBeansMap.keySet());
    }

    public Map<AbstractBean<?, ?>, Long> getBeansSpecializedInAnyDeploymentAsMap() {
        return this.specializedBeansMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((LongAdder)entry.getValue()).longValue()));
    }

    private class BeansSpecializedByBean
    implements Function<Bean<?>, Set<? extends AbstractBean<?, ?>>> {
        private BeansSpecializedByBean() {
        }

        @Override
        public Set<? extends AbstractBean<?, ?>> apply(Bean<?> specializingBean) {
            Set<AbstractBean> result = null;
            if (specializingBean instanceof AbstractClassBean) {
                result = this.apply((AbstractClassBean)specializingBean);
            }
            if (specializingBean instanceof ProducerMethod) {
                result = this.apply((ProducerMethod)specializingBean);
            }
            if (result != null) {
                if (SpecializationAndEnablementRegistry.this.isEnabledInAnyBeanDeployment(specializingBean)) {
                    for (AbstractBean specializedBean : result) {
                        SpecializationAndEnablementRegistry.this.specializedBeansMap.computeIfAbsent(specializedBean, key -> new LongAdder()).increment();
                    }
                }
                return result;
            }
            throw new IllegalArgumentException("Unsupported bean type " + specializingBean);
        }

        @Override
        private Set<AbstractClassBean<?>> apply(AbstractClassBean<?> bean) {
            return this.getSpecializedBeanResolver(bean).resolveSpecializedBeans(bean);
        }

        @Override
        private Set<ProducerMethod<?, ?>> apply(ProducerMethod<?, ?> bean) {
            return this.getSpecializedBeanResolver(bean).resolveSpecializedBeans(bean);
        }

        private SpecializedBeanResolver getSpecializedBeanResolver(RIBean<?> bean) {
            return (SpecializedBeanResolver)SpecializationAndEnablementRegistry.this.specializedBeanResolvers.getValue(bean.getBeanManager());
        }
    }

    private class SpecializedBeanResolverForBeanManager
    implements Function<BeanManagerImpl, SpecializedBeanResolver> {
        private SpecializedBeanResolverForBeanManager() {
        }

        @Override
        public SpecializedBeanResolver apply(BeanManagerImpl manager) {
            return new SpecializedBeanResolver(this.buildAccessibleBeanDeployerEnvironments(manager));
        }

        private Set<BeanDeployerEnvironment> buildAccessibleBeanDeployerEnvironments(BeanManagerImpl manager) {
            HashSet<BeanDeployerEnvironment> result = new HashSet<BeanDeployerEnvironment>();
            result.add((BeanDeployerEnvironment)SpecializationAndEnablementRegistry.this.environmentByManager.get(manager));
            this.buildAccessibleBeanDeployerEnvironments(manager, result);
            return result;
        }

        private void buildAccessibleBeanDeployerEnvironments(BeanManagerImpl manager, Collection<BeanDeployerEnvironment> result) {
            for (BeanManagerImpl accessibleManager : manager.getAccessibleManagers()) {
                BeanDeployerEnvironment environment = (BeanDeployerEnvironment)SpecializationAndEnablementRegistry.this.environmentByManager.get(accessibleManager);
                if (result.contains(environment)) continue;
                result.add(environment);
                this.buildAccessibleBeanDeployerEnvironments(accessibleManager, result);
            }
        }
    }
}

