/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.impl.wrapper.Wrapper;
import org.osgi.service.obr.Resource;

public class ResolverWrapper
implements org.osgi.service.obr.Resolver {
    private final Resolver resolver;

    public ResolverWrapper(Resolver resolver) {
        this.resolver = resolver;
    }

    public void add(Resource resource) {
        this.resolver.add(Wrapper.unwrap(resource));
    }

    public Resource[] getAddedResources() {
        return Wrapper.wrap(this.resolver.getAddedResources());
    }

    public Resource[] getRequiredResources() {
        return Wrapper.wrap(this.resolver.getRequiredResources());
    }

    public Resource[] getOptionalResources() {
        return Wrapper.wrap(this.resolver.getOptionalResources());
    }

    public org.osgi.service.obr.Requirement[] getReason(Resource resource) {
        Reason[] r = this.resolver.getReason(Wrapper.unwrap(resource));
        if (r == null) {
            return new org.osgi.service.obr.Requirement[0];
        }
        Requirement[] r2 = new Requirement[r.length];
        for (int reaIdx = 0; reaIdx < r.length; ++reaIdx) {
            r2[reaIdx] = r[reaIdx].getRequirement();
        }
        return Wrapper.wrap(r2);
    }

    public org.osgi.service.obr.Requirement[] getUnsatisfiedRequirements() {
        Map map = this.getUnsatisfiedRequirementsMap();
        return map.keySet().toArray(new org.osgi.service.obr.Requirement[map.size()]);
    }

    public Resource[] getResources(org.osgi.service.obr.Requirement requirement) {
        Map map = this.getUnsatisfiedRequirementsMap();
        List l = (List)map.get(requirement);
        if (l == null) {
            return new Resource[0];
        }
        return l.toArray(new Resource[l.size()]);
    }

    public boolean resolve() {
        return this.resolver.resolve();
    }

    public void deploy(boolean start) {
        this.resolver.deploy(start ? 16 : 0);
    }

    private Map getUnsatisfiedRequirementsMap() {
        Reason[] reasons = this.resolver.getUnsatisfiedRequirements();
        HashMap<org.osgi.service.obr.Requirement, ArrayList<Resource>> map = new HashMap<org.osgi.service.obr.Requirement, ArrayList<Resource>>();
        for (int i = 0; i < reasons.length; ++i) {
            org.osgi.service.obr.Requirement req = Wrapper.wrap(reasons[i].getRequirement());
            Resource res = Wrapper.wrap(reasons[i].getResource());
            ArrayList<Resource> l = (ArrayList<Resource>)map.get(req);
            if (l == null) {
                l = new ArrayList<Resource>();
                map.put(req, l);
            }
            l.add(res);
        }
        return map;
    }
}

