/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.felix.bundlerepository.impl.CapabilityImpl;
import org.apache.felix.bundlerepository.impl.PropertyImpl;
import org.apache.felix.bundlerepository.impl.Referral;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.RepositoryParser;
import org.apache.felix.bundlerepository.impl.RequirementImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.felix.bundlerepository.impl.SpecXMLPullParser;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PullParser
extends RepositoryParser {
    public RepositoryImpl parseRepository(InputStream is, String repositoryURI) throws Exception {
        KXmlParser reader = new KXmlParser();
        reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        reader.setInput(is, null);
        int event = reader.nextTag();
        if (event != 2 || !"repository".equals(reader.getName())) {
            throw new Exception("Expected element 'repository' at the root of the document");
        }
        if ("http://www.osgi.org/xmlns/repository/v1.0.0".equals(reader.getNamespace())) {
            return SpecXMLPullParser.parse(reader, repositoryURI);
        }
        RepositoryImpl repo = this.parse(reader);
        repo.setURI(repositoryURI);
        return repo;
    }

    public RepositoryImpl parseRepository(Reader r) throws Exception {
        KXmlParser reader = new KXmlParser();
        reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        reader.setInput(r);
        int event = reader.nextTag();
        if (event != 2 || !"repository".equals(reader.getName())) {
            throw new Exception("Expected element 'repository' at the root of the document");
        }
        return this.parse(reader);
    }

    public ResourceImpl parseResource(Reader r) throws Exception {
        KXmlParser reader = new KXmlParser();
        reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        reader.setInput(r);
        int event = reader.nextTag();
        if (event != 2 || !"resource".equals(reader.getName())) {
            throw new Exception("Expected element 'resource'");
        }
        return this.parseResource(reader);
    }

    public CapabilityImpl parseCapability(Reader r) throws Exception {
        KXmlParser reader = new KXmlParser();
        reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        reader.setInput(r);
        int event = reader.nextTag();
        if (event != 2 || !"capability".equals(reader.getName())) {
            throw new Exception("Expected element 'capability'");
        }
        return this.parseCapability(reader);
    }

    public PropertyImpl parseProperty(Reader r) throws Exception {
        KXmlParser reader = new KXmlParser();
        reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        reader.setInput(r);
        int event = reader.nextTag();
        if (event != 2 || !"p".equals(reader.getName())) {
            throw new Exception("Expected element 'p'");
        }
        return this.parseProperty(reader);
    }

    public RequirementImpl parseRequirement(Reader r) throws Exception {
        KXmlParser reader = new KXmlParser();
        reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        reader.setInput(r);
        int event = reader.nextTag();
        if (event != 2 || !"require".equals(reader.getName())) {
            throw new Exception("Expected element 'require'");
        }
        return this.parseRequire(reader);
    }

    public RepositoryImpl parse(XmlPullParser reader) throws Exception {
        int event;
        RepositoryImpl repository = new RepositoryImpl();
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeName(i);
            String value = reader.getAttributeValue(i);
            if ("name".equals(name)) {
                repository.setName(value);
                continue;
            }
            if (!"lastmodified".equals(name)) continue;
            repository.setLastModified(value);
        }
        while ((event = reader.nextTag()) == 2) {
            String element = reader.getName();
            if ("referral".equals(element)) {
                Referral referral = this.parseReferral(reader);
                repository.addReferral(referral);
                continue;
            }
            if ("resource".equals(element)) {
                ResourceImpl resource = this.parseResource(reader);
                repository.addResource(resource);
                continue;
            }
            PullParser.ignoreTag(reader);
        }
        PullParser.sanityCheckEndElement(reader, event, "repository");
        return repository;
    }

    static void sanityCheckEndElement(XmlPullParser reader, int event, String element) {
        if (event != 3 || !element.equals(reader.getName())) {
            throw new IllegalStateException("Unexpected state while finishing element " + element);
        }
    }

    public Referral parseReferral(XmlPullParser reader) throws Exception {
        Referral referral = new Referral();
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeName(i);
            String value = reader.getAttributeValue(i);
            if ("depth".equals(name)) {
                referral.setDepth(value);
                continue;
            }
            if (!"url".equals(name)) continue;
            referral.setUrl(value);
        }
        PullParser.sanityCheckEndElement(reader, reader.nextTag(), "referral");
        return referral;
    }

    public ResourceImpl parseResource(XmlPullParser reader) throws Exception {
        ResourceImpl resource = new ResourceImpl();
        try {
            int event;
            int nb = reader.getAttributeCount();
            for (int i = 0; i < nb; ++i) {
                resource.put(reader.getAttributeName(i), reader.getAttributeValue(i));
            }
            while ((event = reader.nextTag()) == 2) {
                String element = reader.getName();
                if ("category".equals(element)) {
                    String category = this.parseCategory(reader);
                    resource.addCategory(category);
                    continue;
                }
                if ("capability".equals(element)) {
                    CapabilityImpl capability = this.parseCapability(reader);
                    resource.addCapability(capability);
                    continue;
                }
                if ("require".equals(element)) {
                    RequirementImpl requirement = this.parseRequire(reader);
                    resource.addRequire(requirement);
                    continue;
                }
                StringBuffer sb = null;
                String type = reader.getAttributeValue(null, "type");
                while ((event = reader.next()) != 3) {
                    switch (event) {
                        case 2: {
                            throw new Exception("Unexpected element inside <require/> element");
                        }
                        case 4: {
                            if (sb == null) {
                                sb = new StringBuffer();
                            }
                            sb.append(reader.getText());
                        }
                    }
                }
                if (sb == null) continue;
                resource.put(element, sb.toString().trim(), type);
            }
            if (event != 3 || !"resource".equals(reader.getName())) {
                throw new Exception("Unexpected state");
            }
            return resource;
        }
        catch (Exception e) {
            throw new Exception("Error while parsing resource " + resource.getId() + " at line " + reader.getLineNumber() + " and column " + reader.getColumnNumber(), e);
        }
    }

    public String parseCategory(XmlPullParser reader) throws IOException, XmlPullParserException {
        String id = null;
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            if (!"id".equals(reader.getAttributeName(i))) continue;
            id = reader.getAttributeValue(i);
        }
        PullParser.sanityCheckEndElement(reader, reader.nextTag(), "category");
        return id;
    }

    public CapabilityImpl parseCapability(XmlPullParser reader) throws Exception {
        int event;
        CapabilityImpl capability = new CapabilityImpl();
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeName(i);
            String value = reader.getAttributeValue(i);
            if (!"name".equals(name)) continue;
            capability.setName(value);
        }
        while ((event = reader.nextTag()) == 2) {
            String element = reader.getName();
            if ("p".equals(element)) {
                PropertyImpl prop = this.parseProperty(reader);
                capability.addProperty(prop);
                continue;
            }
            PullParser.ignoreTag(reader);
        }
        PullParser.sanityCheckEndElement(reader, event, "capability");
        return capability;
    }

    public PropertyImpl parseProperty(XmlPullParser reader) throws Exception {
        String n = null;
        String t = null;
        String v = null;
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeName(i);
            String value = reader.getAttributeValue(i);
            if ("n".equals(name)) {
                n = value;
                continue;
            }
            if ("t".equals(name)) {
                t = value;
                continue;
            }
            if (!"v".equals(name)) continue;
            v = value;
        }
        PropertyImpl prop = new PropertyImpl(n, t, v);
        PullParser.sanityCheckEndElement(reader, reader.nextTag(), "p");
        return prop;
    }

    public RequirementImpl parseRequire(XmlPullParser reader) throws Exception {
        int event;
        RequirementImpl requirement = new RequirementImpl();
        int nb = reader.getAttributeCount();
        for (int i = 0; i < nb; ++i) {
            String name = reader.getAttributeName(i);
            String value = reader.getAttributeValue(i);
            if ("name".equals(name)) {
                requirement.setName(value);
                continue;
            }
            if ("filter".equals(name)) {
                requirement.setFilter(value);
                continue;
            }
            if ("extend".equals(name)) {
                requirement.setExtend(Boolean.valueOf(value));
                continue;
            }
            if ("multiple".equals(name)) {
                requirement.setMultiple(Boolean.valueOf(value));
                continue;
            }
            if (!"optional".equals(name)) continue;
            requirement.setOptional(Boolean.valueOf(value));
        }
        StringBuffer sb = null;
        while ((event = reader.next()) != 3) {
            switch (event) {
                case 2: {
                    throw new Exception("Unexpected element inside <require/> element");
                }
                case 4: {
                    if (sb == null) {
                        sb = new StringBuffer();
                    }
                    sb.append(reader.getText());
                }
            }
        }
        if (sb != null) {
            requirement.addText(sb.toString());
        }
        PullParser.sanityCheckEndElement(reader, event, "require");
        return requirement;
    }

    static void ignoreTag(XmlPullParser reader) throws IOException, XmlPullParserException {
        int level = 1;
        while (level > 0) {
            int eventType = reader.next();
            if (eventType == 2) {
                ++level;
                continue;
            }
            if (eventType != 3) continue;
            --level;
        }
    }
}

