/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class ClassPathBuilder {
    private final List<URL> urls = new ArrayList<URL>();
    private final ClassLoader parent;

    public ClassPathBuilder(ClassLoader parent) {
        this.parent = parent;
    }

    public void addJar(File jar) throws IOException {
        if (!jar.exists()) {
            throw new IOException("No such file: " + jar);
        }
        this.urls.add(jar.toURI().toURL());
    }

    public void addClassFolder(File classFolder) throws IOException {
        this.addJar(classFolder);
    }

    public void addJarFolder(File folder, final String ... excludes) throws IOException {
        if (!folder.isDirectory()) {
            throw new IOException("Not a directory " + folder);
        }
        File[] children = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                for (String name : excludes) {
                    if (!pathname.getName().equals(name)) continue;
                    return false;
                }
                return pathname.getPath().endsWith(".jar");
            }
        });
        if (children == null) {
            return;
        }
        for (File child : children) {
            this.addJar(child);
        }
    }

    public void addGlob(File folder, String ... masks) throws IOException {
        StringBuilder regexp = new StringBuilder();
        for (String mask : masks) {
            if (regexp.length() > 0) {
                regexp.append('|');
            }
            regexp.append("(\\Q");
            regexp.append(mask.replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q"));
            regexp.append("\\E)");
        }
        Pattern p = Pattern.compile(regexp.toString());
        File[] children = folder.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!p.matcher(child.getName()).matches()) continue;
            this.addJar(child);
        }
    }

    public ClassLoader create() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(ClassPathBuilder.this.urls.toArray(new URL[ClassPathBuilder.this.urls.size()]), ClassPathBuilder.this.parent);
            }
        });
    }
}

