/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.deliverable.cts.deploy;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.deliverable.cts.deploy.StandardDeployment14;
import com.sun.ts.lib.deliverable.cts.deploy.StandardDeployment14ServerInterface;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.ts.lib.porting.TSDeployment;
import com.sun.ts.lib.porting.TSDeploymentException;
import com.sun.ts.lib.util.TestUtil;
import java.io.PrintWriter;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.Properties;

public class StandardDeployment14Server
extends UnicastRemoteObject
implements StandardDeployment14ServerInterface {
    private static StandardDeployment14Server deploymentServer = null;
    private PropertyManagerInterface propMgr = null;
    private static String sPort = "2002";
    private static int iPort = 2002;
    private StandardDeployment14 standardDeploy = null;

    public static void main(String[] args) {
        if (args.length == 2 && args[0].equalsIgnoreCase("-port")) {
            sPort = args[1];
        }
        System.setSecurityManager(new RMISecurityManager());
        try {
            deploymentServer = new StandardDeployment14Server();
            iPort = Integer.parseInt(sPort);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Registry registry = LocateRegistry.createRegistry(iPort);
            TestUtil.logHarness((String)("StandardDeployment14Server:  Registry has been created on port:  " + iPort));
            registry.rebind("StandardDeployment14Server", deploymentServer);
            TestUtil.logHarness((String)"StandardDeployment14Server:  deploymentServer has been bound to the Registry");
        }
        catch (Exception e) {
            TestUtil.logHarness((String)"Failed to bind deploymentServer");
            e.printStackTrace();
        }
    }

    @Override
    public void init(Properties jteProps, Map extraParameters) throws RemoteException {
        try {
            TestUtil.logHarnessDebug((String)"StandardDeployment14Server:  in init");
            jteProps.setProperty("s1as.targets", "server");
            this.propMgr = DeliverableFactory.getDeliverableInstance().createPropertyManager(jteProps);
            if (this.standardDeploy == null) {
                this.standardDeploy = new StandardDeployment14();
            }
            Integer portingSetInteger = (Integer)extraParameters.get("porting_set");
            TSDeployment.iPortingSet = portingSetInteger;
            this.standardDeploy.init(new PrintWriter(System.out));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestUtil.logHarnessDebug((String)"StandardDeployment14Server:  leaving init");
    }

    @Override
    public String deploy(DeploymentInfo info) throws RemoteException {
        try {
            return this.standardDeploy.deploy(info);
        }
        catch (TSDeploymentException e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isDeployed(Properties p) throws RemoteException {
        try {
            return this.standardDeploy.isDeployed(p);
        }
        catch (TSDeploymentException e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage(), e);
        }
    }

    @Override
    public void undeploy(Properties p) throws RemoteException {
        try {
            this.standardDeploy.undeploy(p);
            return;
        }
        catch (TSDeploymentException e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage(), e);
        }
    }
}

