/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.process.Jps;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessUtils;
import java.util.Map;
import java.util.Set;

public class Jstack {
    private static final Set<Map.Entry<Integer, String>> set = Jps.getProcessTable().entrySet();

    public static void main(String[] args) {
        System.out.println("** Got " + set.size() + " process entries");
        if (args.length > 0) {
            int pid = Integer.parseInt(args[0]);
            boolean legal = Jps.isPid(Integer.parseInt(args[0]));
            System.out.printf("Jps.isPid(%s) ==> %b%n", args[0], legal);
            Jstack.getDump(pid);
        } else {
            for (Map.Entry<Integer, String> e : set) {
                System.out.printf("%d %s%n", e.getKey(), e.getValue());
            }
            System.out.println(Jstack.getDump());
            System.out.println("XXXXX");
        }
    }

    public static String getDump() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, String> e : set) {
            int pid = e.getKey();
            sb.append(Jstack.prepend(pid, e.getValue()));
            sb.append(Jstack.getDump(pid));
        }
        return sb.toString();
    }

    public static String getDump(int pid) {
        try {
            if (ProcessUtils.jstackExe == null) {
                return "";
            }
            ProcessManager pm = new ProcessManager(ProcessUtils.jstackExe.getPath(), "-l", "" + pid);
            pm.setEcho(false);
            pm.execute();
            return pm.getStdout();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String prepend(int pid, String name) {
        return "-------    DUMPING JSTACK FOR PID= " + pid + ", name = " + name + " -------\n";
    }
}

