/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.handler;

import org.apache.felix.eventadmin.impl.handler.EventHandlerTracker;
import org.apache.felix.eventadmin.impl.tasks.AsyncDeliverTasks;
import org.apache.felix.eventadmin.impl.tasks.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.tasks.SyncDeliverTasks;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventAdminImpl
implements EventAdmin {
    private volatile EventHandlerTracker tracker;
    private final AsyncDeliverTasks m_postManager;
    private final SyncDeliverTasks m_sendManager;
    private EventHandlerTracker.Matcher[] m_ignoreTopics;

    public EventAdminImpl(BundleContext bundleContext, DefaultThreadPool syncPool, DefaultThreadPool asyncPool, int timeout, String[] ignoreTimeout, boolean requireTopic, String[] ignoreTopics) {
        this.checkNull(syncPool, "syncPool");
        this.checkNull(asyncPool, "asyncPool");
        this.tracker = new EventHandlerTracker(bundleContext);
        this.tracker.update(ignoreTimeout, requireTopic);
        this.tracker.open();
        this.m_sendManager = new SyncDeliverTasks(syncPool, timeout);
        this.m_postManager = new AsyncDeliverTasks(asyncPool, this.m_sendManager);
        this.m_ignoreTopics = EventHandlerTracker.createMatchers(ignoreTopics);
    }

    private EventHandlerTracker getTracker() {
        EventHandlerTracker localTracker = this.tracker;
        if (localTracker == null) {
            throw new IllegalStateException("The EventAdmin is stopped");
        }
        return localTracker;
    }

    private boolean checkTopic(Event event) {
        boolean result = true;
        if (this.m_ignoreTopics != null) {
            for (EventHandlerTracker.Matcher m : this.m_ignoreTopics) {
                if (!m.match(event.getTopic())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public void postEvent(Event event) {
        if (this.checkTopic(event)) {
            this.m_postManager.execute(this.getTracker().getHandlers(event), event);
        }
    }

    @Override
    public void sendEvent(Event event) {
        if (this.checkTopic(event)) {
            this.m_sendManager.execute(this.getTracker().getHandlers(event), event, false);
        }
    }

    public void stop() {
        this.tracker.close();
        this.tracker = null;
    }

    public void update(int timeout, String[] ignoreTimeout, boolean requireTopic, String[] ignoreTopics) {
        this.tracker.close();
        this.tracker.update(ignoreTimeout, requireTopic);
        this.m_sendManager.update(timeout);
        this.tracker.open();
        this.m_ignoreTopics = EventHandlerTracker.createMatchers(ignoreTopics);
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }
}

