/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.sp.NamespaceSupport;
import com.sun.xml.rpc.streaming.PrefixFactory;
import com.sun.xml.rpc.streaming.XMLWriterBase;
import com.sun.xml.rpc.streaming.XMLWriterException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.CDATA;
import com.sun.xml.rpc.util.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;

public class XMLWriterImpl
extends XMLWriterBase {
    private XmlWriter _writer;
    private NamespaceSupport _nsSupport = new NamespaceSupport();
    private Stack _elemStack = new Stack();
    private PrefixFactory _prefixFactory;

    public XMLWriterImpl(OutputStream out, String enc, boolean declare) {
        try {
            this._writer = new XmlWriter(out, enc, declare);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void startElement(String localName, String uri) {
        try {
            this._nsSupport.pushContext();
            if (!uri.equals("")) {
                String aPrefix = null;
                boolean mustDeclarePrefix = false;
                String defaultNamespaceURI = this._nsSupport.getPrefix("");
                if (defaultNamespaceURI != null && uri.equals(defaultNamespaceURI)) {
                    aPrefix = "";
                }
                if ((aPrefix = this._nsSupport.getPrefix(uri)) == null) {
                    mustDeclarePrefix = true;
                    if (this._prefixFactory != null) {
                        aPrefix = this._prefixFactory.getPrefix(uri);
                    }
                    if (aPrefix == null) {
                        throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
                    }
                }
                String rawName = aPrefix.equals("") ? localName : aPrefix + ":" + localName;
                this._writer.start(rawName);
                this._elemStack.push(rawName);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            } else {
                this._writer.start(localName);
                this._elemStack.push(localName);
            }
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void startElement(String localName, String uri, String prefix) {
        try {
            this._nsSupport.pushContext();
            if (!uri.equals("")) {
                String aPrefix = null;
                boolean mustDeclarePrefix = false;
                String defaultNamespaceURI = this._nsSupport.getPrefix("");
                if (defaultNamespaceURI != null && uri.equals(defaultNamespaceURI)) {
                    aPrefix = "";
                }
                if ((aPrefix = this._nsSupport.getPrefix(uri)) == null) {
                    mustDeclarePrefix = true;
                    aPrefix = prefix;
                    if (aPrefix == null) {
                        throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
                    }
                }
                String rawName = aPrefix.equals("") ? localName : aPrefix + ":" + localName;
                this._writer.start(rawName);
                this._elemStack.push(rawName);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            } else {
                this._writer.start(localName);
                this._elemStack.push(localName);
            }
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeNamespaceDeclaration(String prefix, String uri) {
        try {
            this._nsSupport.declarePrefix(prefix, uri);
            if (prefix != null && !prefix.equals("")) {
                this._writer.attribute("xmlns", prefix, uri);
            } else {
                this._writer.attribute("xmlns", uri);
            }
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeNamespaceDeclaration(String uri) {
        if (this._prefixFactory == null) {
            throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
        }
        String aPrefix = this._prefixFactory.getPrefix(uri);
        this.writeNamespaceDeclaration(aPrefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String uri, String value) {
        try {
            if (!uri.equals("")) {
                String aPrefix = null;
                boolean mustDeclarePrefix = false;
                String defaultNamespaceURI = this._nsSupport.getPrefix("");
                if (defaultNamespaceURI != null && uri.equals(defaultNamespaceURI)) {
                    aPrefix = "";
                }
                if ((aPrefix = this._nsSupport.getPrefix(uri)) == null) {
                    mustDeclarePrefix = true;
                    if (this._prefixFactory != null) {
                        aPrefix = this._prefixFactory.getPrefix(uri);
                    }
                    if (aPrefix == null) {
                        throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
                    }
                }
                this._writer.attribute(aPrefix, localName, value);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            } else {
                this._writer.attribute(localName, value);
            }
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeAttributeUnquoted(String localName, String uri, String value) {
        try {
            if (!uri.equals("")) {
                String aPrefix = null;
                boolean mustDeclarePrefix = false;
                String defaultNamespaceURI = this._nsSupport.getPrefix("");
                if (defaultNamespaceURI != null && uri.equals(defaultNamespaceURI)) {
                    aPrefix = "";
                }
                if ((aPrefix = this._nsSupport.getPrefix(uri)) == null) {
                    mustDeclarePrefix = true;
                    if (this._prefixFactory != null) {
                        aPrefix = this._prefixFactory.getPrefix(uri);
                    }
                    if (aPrefix == null) {
                        throw new XMLWriterException("xmlwriter.noPrefixForURI", uri);
                    }
                }
                this._writer.attributeUnquoted(aPrefix, localName, value);
                if (mustDeclarePrefix) {
                    this.writeNamespaceDeclaration(aPrefix, uri);
                }
            } else {
                this._writer.attributeUnquoted(localName, value);
            }
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeChars(CDATA chars) {
        try {
            this._writer.chars(chars);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeChars(String chars) {
        try {
            this._writer.chars(chars);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeCharsUnquoted(String chars) {
        try {
            this._writer.charsUnquoted(chars);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void writeCharsUnquoted(char[] buf, int offset, int len) {
        try {
            this._writer.charsUnquoted(buf, offset, len);
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void endElement() {
        try {
            String rawName = (String)this._elemStack.pop();
            this._writer.end(rawName);
            this._nsSupport.popContext();
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public PrefixFactory getPrefixFactory() {
        return this._prefixFactory;
    }

    @Override
    public void setPrefixFactory(PrefixFactory factory) {
        this._prefixFactory = factory;
    }

    @Override
    public String getURI(String prefix) {
        return this._nsSupport.getURI(prefix);
    }

    @Override
    public String getPrefix(String uri) {
        return this._nsSupport.getPrefix(uri);
    }

    @Override
    public void flush() {
        try {
            this._writer.flush();
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    @Override
    public void close() {
        try {
            this._writer.close();
        }
        catch (IOException e) {
            throw this.wrapException(e);
        }
    }

    private XMLWriterException wrapException(IOException e) {
        return new XMLWriterException("xmlwriter.ioException", new LocalizableExceptionAdapter(e));
    }
}

