/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.standardnotnull;

import ee.jakarta.tck.ws.rs.common.impl.StringStreamingOutput;
import jakarta.activation.DataSource;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.xml.bind.JAXBElement;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.Source;

@Path(value="resource")
public class Resource {
    public static final String NULL = "NULL";
    public static final String NOTNULL = "EXPECTED";

    @Path(value="bytearray")
    @POST
    public String bytearray(byte[] bytes) {
        return Resource.isNull(bytes);
    }

    @Path(value="string")
    @POST
    public String string(String string) {
        return Resource.isNull(string);
    }

    @Path(value="inputstream")
    @POST
    public String inputstream(InputStream inputstream) {
        return Resource.isNull(inputstream);
    }

    @Path(value="reader")
    @POST
    public String reader(Reader reader) {
        return Resource.isNull(reader);
    }

    @Path(value="file")
    @POST
    public String file(File file) {
        return Resource.isNull(file);
    }

    @Path(value="datasource")
    @POST
    public String datasource(DataSource datasource) {
        return Resource.isNull(datasource);
    }

    @Path(value="jaxb")
    @POST
    public String jaxb(JAXBElement<String> jaxb) {
        return Resource.isNull(jaxb);
    }

    @Path(value="source")
    @POST
    public String source(Source source) {
        return Resource.isNull(source);
    }

    @Path(value="map")
    @POST
    public String map(MultivaluedMap<String, String> map) {
        return Resource.isNull(map);
    }

    @Path(value="streamingoutput")
    @POST
    public StreamingOutput streamingoutput(String streamingoutput) {
        return new StringStreamingOutput(streamingoutput);
    }

    @Path(value="character")
    @POST
    public Character character(Character character) {
        return character;
    }

    @Path(value="boolean")
    @POST
    public String bigbool(Boolean bool) {
        return Resource.isNull(bool);
    }

    @Path(value="bigdecimal")
    @POST
    public String number(BigDecimal number) {
        return Resource.isNull(number);
    }

    @Path(value="integer")
    @POST
    public String number(Integer number) {
        return Resource.isNull(number);
    }

    @Path(value="biglong")
    @POST
    public String number(Long number) {
        return Resource.isNull(number);
    }

    @Path(value="bigdouble")
    @POST
    public String number(Double number) {
        return Resource.isNull(number);
    }

    @Path(value="atomic")
    @POST
    public String atomic(AtomicInteger ai) {
        return Resource.isNull(ai);
    }

    @Path(value="entity")
    @GET
    public Response entity() {
        return Response.ok().build();
    }

    @Path(value="null")
    @GET
    public String echo() {
        return null;
    }

    private static String isNull(Object o) {
        return o == null ? NULL : NOTNULL;
    }
}

