/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext;

import ee.jakarta.tck.ws.rs.common.provider.StringBeanWithAnnotation;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext.TemplateFilter;
import jakarta.annotation.Priority;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Provider
@Priority(value=500)
public class ResponseFilter
extends TemplateFilter {
    public static final String COOKIENAME = "CookieName";
    public static final String ENTITY = "ResponseFilterEntity";
    public static final String NULL = "NULL";
    public static final String RELATION = "relation";

    public void getAllowedMethods() {
        Set set = this.responseContext.getAllowedMethods();
        this.setEntity(ResponseFilter.collectionToString(set));
        for (String s : set) {
            if (s.toUpperCase().equals(s)) continue;
            this.setEntity(s + " is not uppercase");
            break;
        }
    }

    public void getCookies() {
        Map cookies = this.responseContext.getCookies();
        this.setEntity(ResponseFilter.collectionToString(cookies.keySet()));
    }

    public void getCookiesIsReadOnly() {
        NewCookie cookie = new NewCookie(COOKIENAME, COOKIENAME);
        Map cookies = this.responseContext.getCookies();
        if (this.assertTrue(!cookies.containsKey(COOKIENAME), COOKIENAME, "is already present")) {
            return;
        }
        try {
            cookies.put(COOKIENAME, cookie);
        }
        catch (Exception exception) {
            // empty catch block
        }
        cookies = this.responseContext.getCookies();
        if (this.assertTrue(!cookies.containsKey(COOKIENAME), "#getCookies is Not readOnly")) {
            return;
        }
        this.setEntity("getCookies is read-only as expected");
    }

    public void getDate() {
        Date date = this.responseContext.getDate();
        long milis = date == null ? 0L : date.getTime();
        this.setEntity(String.valueOf(milis));
    }

    public void getEntity() {
        byte[] entity = (byte[])this.responseContext.getEntity();
        if (entity != null) {
            this.setEntity(new String(entity) + new String(entity));
        } else {
            this.setEntity(NULL);
        }
    }

    public void getEntityAnnotations() {
        Annotation[] annotations = this.responseContext.getEntityAnnotations();
        if (annotations != null && annotations.length != 0) {
            String[] names = new String[annotations.length];
            for (int i = 0; i != annotations.length; ++i) {
                names[i] = annotations[i].annotationType().getName();
            }
            this.setEntity(ResponseFilter.collectionToString(Arrays.asList(names)));
        } else {
            this.setEntity(NULL);
        }
    }

    public void getEntityAnnotationsOnEntity() {
        Annotation[] annotations = this.responseContext.getEntityAnnotations();
        String entity = this.responseContext.hasEntity() ? ((StringBeanWithAnnotation)this.responseContext.getEntity()).get() : NULL;
        String annotationCount = annotations == null ? NULL : String.valueOf(annotations.length);
        this.setEntity(entity + " " + annotationCount);
    }

    public void getEntityClass() {
        Class clazz = this.responseContext.getEntityClass();
        this.setEntity(clazz.getName());
    }

    public void getEntityStream() throws IOException {
        OutputStream stream = this.responseContext.getEntityStream();
        if (stream == null) {
            this.setEntity(NULL);
        } else {
            this.setEntity(ENTITY);
        }
    }

    public void getEntityTag() {
        EntityTag tag = this.responseContext.getEntityTag();
        this.setEntity(tag == null ? NULL : tag.getValue());
    }

    public void getEntityType() {
        Type type = this.responseContext.getEntityType();
        String name = NULL;
        if (type instanceof Class) {
            name = ((Class)type).getName();
        } else if (type != null) {
            name = type.getClass().getName();
        }
        this.setEntity(name);
    }

    public void getHeaders() {
        MultivaluedMap headers = this.responseContext.getHeaders();
        this.setEntity(ResponseFilter.collectionToString(headers.keySet()));
    }

    public void getHeadersIsMutable() {
        MultivaluedMap headers = this.responseContext.getHeaders();
        if (this.assertTrue(!headers.containsKey((Object)"HEADER"), "HEADER", "header is alredy in header map")) {
            return;
        }
        headers.add((Object)"HEADER", (Object)"HEADER");
        headers = this.responseContext.getHeaders();
        if (this.assertTrue(headers.containsKey((Object)"HEADER"), "HEADER", "header is not in header map")) {
            return;
        }
    }

    public void getHeaderStringOperation() {
        String header = this.responseContext.getHeaderString("OPERATION");
        this.setEntity(header);
    }

    public void getHeaderStringHeader() {
        String header = this.responseContext.getHeaderString("HEADER");
        this.setEntity(header == null ? NULL : header);
    }

    public void getLanguage() {
        Locale locale = this.responseContext.getLanguage();
        this.setEntity(locale == null ? NULL : locale.toString());
    }

    public void getLastModified() {
        Date date = this.responseContext.getLastModified();
        this.setEntity(date == null ? NULL : String.valueOf(date.getTime()));
    }

    public void getLength() {
        int contentLen = this.responseContext.getLength();
        String entity = (String)this.responseContext.getEntity();
        this.setEntity(ResponseFilter.replaceStart(entity, contentLen));
    }

    public static String replaceStart(String where, int by) {
        StringBuilder sb = new StringBuilder().append(by);
        if (where != null) {
            sb.append(where.substring(String.valueOf(by).length()));
        }
        return sb.toString();
    }

    public void getLink() {
        Link link = this.responseContext.getLink(RELATION);
        this.setLinkForGetLink(link);
    }

    public void getLinkBuilder() {
        Link.Builder builder = this.responseContext.getLinkBuilder(RELATION);
        if (builder != null) {
            Link link = builder.build(new Object[0]);
            this.setLinkForGetLink(link);
        } else {
            this.setEntity(NULL);
        }
    }

    private void setLinkForGetLink(Link link) {
        String entity = NULL;
        if (link != null && link.getUri() != null) {
            entity = link.getUri().toASCIIString();
        }
        this.setEntity(entity);
    }

    public void getLinks() {
        Set set = this.responseContext.getLinks();
        if (this.assertTrue(set != null, "#getLinks shall never be null")) {
            return;
        }
        if (set.size() == 0) {
            this.setEntity(NULL);
            return;
        }
        HashSet<String> strings = new HashSet<String>();
        for (Link link : set) {
            strings.add(link.toString());
        }
        this.setEntity(JaxrsUtil.iterableToString(";", strings));
    }

    public void getLocation() {
        URI uri = this.responseContext.getLocation();
        this.setEntity(uri == null ? NULL : uri.toASCIIString());
    }

    public void getMediaType() {
        MediaType type = this.responseContext.getMediaType();
        this.setEntity(type == null ? NULL : type.toString());
    }

    public void getStatus() {
        int status = this.responseContext.getStatus();
        this.responseContext.setStatus(Response.Status.OK.getStatusCode());
        this.setEntity(String.valueOf(status));
    }

    public void getStatusNotSet() {
        this.getStatus();
    }

    public void getStatusInfo() {
        Response.StatusType type = this.responseContext.getStatusInfo();
        if (type == null) {
            this.setEntity(NULL);
            this.responseContext.setStatus(Response.Status.OK.getStatusCode());
            return;
        }
        int status = type.getStatusCode();
        this.responseContext.setStatus(Response.Status.OK.getStatusCode());
        this.setEntity(String.valueOf(status));
    }

    public void getStatusInfoNotSet() {
        this.getStatusInfo();
    }

    public void getStringHeaders() {
        MultivaluedMap map = this.responseContext.getStringHeaders();
        List list = (List)map.get((Object)"HEADER");
        this.setEntity(list == null ? NULL : (list.size() == 1 ? (String)list.iterator().next() : ResponseFilter.collectionToString(list)));
    }

    public void hasEntity() {
        boolean has = this.responseContext.hasEntity();
        this.setEntity(String.valueOf(has));
    }

    public void hasLink() {
        boolean has = this.responseContext.hasLink(RELATION);
        this.setEntity(String.valueOf(has));
    }

    public void setEntity() {
        Annotation[] annotations = this.getClass().getAnnotations();
        MediaType type = MediaType.APPLICATION_SVG_XML_TYPE;
        this.responseContext.setEntity((Object)ENTITY, annotations, type);
    }

    public void setEntityStream() {
        final OutputStream stream = this.responseContext.getEntityStream();
        OutputStream byteStream = new OutputStream(){

            @Override
            public void write(byte[] b) throws IOException {
                stream.write(ResponseFilter.ENTITY.getBytes());
                stream.write(b);
            }

            @Override
            public void write(int b) throws IOException {
                this.write(this.intToByteArray(b));
            }

            @Override
            public synchronized void write(byte[] b, int off, int len) throws IOException {
                this.write(b);
            }

            public final byte[] intToByteArray(int value) {
                return new byte[]{(byte)(value & 0xFF)};
            }
        };
        this.responseContext.setEntityStream(byteStream);
        StringBuilder sb = new StringBuilder(ENTITY.length() + 4);
        for (int i = 0; i < ENTITY.length() + 3; i += 2) {
            sb.append("OK");
        }
        this.setEntity(sb.toString());
    }

    public void setStatus() {
        String entity = (String)this.responseContext.getEntity();
        int status = Integer.parseInt(entity);
        this.responseContext.setStatus(status);
        this.resetStatusEntity(status);
    }

    public void setStatusInfo() {
        String entity = (String)this.responseContext.getEntity();
        final int status = Integer.parseInt(entity);
        Response.StatusType type = new Response.StatusType(){

            public int getStatusCode() {
                return status;
            }

            public String getReasonPhrase() {
                return null;
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)status);
            }
        };
        this.responseContext.setStatusInfo(type);
        this.resetStatusEntity(status);
    }

    private void resetStatusEntity(int status) {
        switch (status) {
            case 204: 
            case 205: {
                this.responseContext.setEntity(null);
            }
        }
    }

    public void setStringBeanRuntime() {
    }

    public void setOriginalRuntime() {
    }
}

