/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.cachecontrol;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.CacheControl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1L;
    static Object[] expected = new Object[]{true, false, false, false, true, false, false, new ArrayList(), new ArrayList()};
    static String _root = "/jaxrs_rs_core_cacheControlTest_web";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void emptyConstructorTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        CacheControl ccl = new CacheControl();
        pass = JAXRSClientIT.verifyList(expected, ccl, sb);
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void maxAgeTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        int maxAge = -1;
        CacheControl ccl1 = new CacheControl();
        ccl1.setMaxAge(maxAge);
        pass = JAXRSClientIT.verifyList(expected, ccl1, sb);
        pass &= JAXRSClientIT.verifyMaxAge(ccl1, maxAge, sb);
        maxAge = 2000;
        ccl1.setMaxAge(maxAge);
        pass &= JAXRSClientIT.verifyList(expected, ccl1, sb);
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.verifyMaxAge(ccl1, maxAge, sb)), (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void sMaxAgeTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        int sMaxAge = -1;
        CacheControl ccl1 = new CacheControl();
        ccl1.setSMaxAge(sMaxAge);
        pass = JAXRSClientIT.verifyList(expected, ccl1, sb);
        pass &= JAXRSClientIT.verifySMaxAge(ccl1, sMaxAge, sb);
        sMaxAge = 2000;
        ccl1.setSMaxAge(sMaxAge);
        pass &= JAXRSClientIT.verifyList(expected, ccl1, sb);
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.verifySMaxAge(ccl1, sMaxAge, sb)), (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void revalidateTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        boolean revalidate = false;
        JAXRSClientIT.expected[5] = revalidate;
        CacheControl ccl2 = new CacheControl();
        ccl2.setMustRevalidate(revalidate);
        pass = JAXRSClientIT.verifyList(expected, ccl2, sb);
        sb.append("Finished the first round");
        revalidate = true;
        JAXRSClientIT.expected[5] = revalidate;
        ccl2.setMustRevalidate(revalidate);
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.verifyList(expected, ccl2, sb)), (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void noCacheTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        boolean nocache = false;
        JAXRSClientIT.expected[2] = nocache;
        CacheControl ccl3 = new CacheControl();
        ccl3.setNoCache(nocache);
        pass = JAXRSClientIT.verifyList(expected, ccl3, sb);
        nocache = true;
        JAXRSClientIT.expected[2] = nocache;
        ccl3.setNoCache(nocache);
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.verifyList(expected, ccl3, sb)), (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void noStoreTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        boolean nostore = false;
        JAXRSClientIT.expected[3] = nostore;
        CacheControl ccl4 = new CacheControl();
        ccl4.setNoStore(nostore);
        pass = JAXRSClientIT.verifyList(expected, ccl4, sb);
        nostore = true;
        JAXRSClientIT.expected[3] = nostore;
        ccl4.setNoStore(nostore);
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.verifyList(expected, ccl4, sb)), (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void noTransformTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        boolean notransform = false;
        JAXRSClientIT.expected[4] = notransform;
        CacheControl ccl4 = new CacheControl();
        ccl4.setNoTransform(notransform);
        pass = JAXRSClientIT.verifyList(expected, ccl4, sb);
        notransform = true;
        JAXRSClientIT.expected[4] = notransform;
        ccl4.setNoTransform(notransform);
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.verifyList(expected, ccl4, sb)), (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void privateTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        boolean _private = false;
        JAXRSClientIT.expected[1] = _private;
        CacheControl ccl5 = new CacheControl();
        ccl5.setPrivate(_private);
        pass = JAXRSClientIT.verifyList(expected, ccl5, sb);
        _private = true;
        JAXRSClientIT.expected[1] = _private;
        ccl5.setPrivate(_private);
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.verifyList(expected, ccl5, sb)), (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void proxyRevalidateTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        boolean proxyRevalidate = false;
        JAXRSClientIT.expected[6] = proxyRevalidate;
        CacheControl ccl5 = new CacheControl();
        ccl5.setProxyRevalidate(proxyRevalidate);
        pass = JAXRSClientIT.verifyList(expected, ccl5, sb);
        proxyRevalidate = true;
        JAXRSClientIT.expected[6] = proxyRevalidate;
        ccl5.setProxyRevalidate(proxyRevalidate);
        Assertions.assertTrue((boolean)(pass &= JAXRSClientIT.verifyList(expected, ccl5, sb)), (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void equalsTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        CacheControl ccl6 = new CacheControl();
        CacheControl ccl7 = new CacheControl();
        ccl6.setProxyRevalidate(false);
        ccl7.setProxyRevalidate(true);
        if (ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("UnEqual Test setProxyRevalidate failed." + newline);
        }
        if (ccl6.hashCode() == ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setProxyRevalidate failed." + newline);
        }
        ccl7.setProxyRevalidate(false);
        if (!ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("Equal Test setProxyRevalidate failed." + newline);
        }
        if (ccl6.hashCode() != ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode Equal Test setProxyRevalidate failed." + newline);
        }
        ccl6.setPrivate(true);
        ccl7.setPrivate(false);
        if (ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("UnEqual Test setPrivate failed." + newline);
        }
        if (ccl6.hashCode() == ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setPrivate failed." + newline);
        }
        ccl7.setPrivate(true);
        if (!ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("Equal Test setPrivate failed." + newline);
        }
        if (ccl6.hashCode() != ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode Equal Test setPrivate failed." + newline);
        }
        ccl6.setNoTransform(true);
        ccl7.setNoTransform(false);
        if (ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("UnEqual Test setNoTransform failed." + newline);
        }
        if (ccl6.hashCode() == ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setNoTransform failed." + newline);
        }
        ccl7.setNoTransform(true);
        if (!ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("Equal Test setNoTransform failed." + newline);
        }
        if (ccl6.hashCode() != ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode Equal Test setNoTransform failed." + newline);
        }
        ccl6.setNoStore(true);
        ccl7.setNoStore(false);
        if (ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("UnEqual Test setNoStore failed." + newline);
        }
        if (ccl6.hashCode() == ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setNoStore failed." + newline);
        }
        ccl7.setNoStore(true);
        if (!ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("Equal Test setNoStore failed." + newline);
        }
        if (ccl6.hashCode() != ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode Equal Test setNoStore failed." + newline);
        }
        ccl6.setNoCache(true);
        ccl7.setNoCache(false);
        if (ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("UnEqual Test setNoCache failed." + newline);
        }
        if (ccl6.hashCode() == ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setNoCache failed." + newline);
        }
        ccl7.setNoCache(true);
        if (!ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("Equal Test setNoCache failed." + newline);
        }
        if (ccl6.hashCode() != ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode Equal Test setNoCache failed." + newline);
        }
        ccl6.setMustRevalidate(true);
        ccl7.setMustRevalidate(false);
        if (ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("UnEqual Test setMustRevalidate failed." + newline);
        }
        if (ccl6.hashCode() == ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setMustRevalidate failed." + newline);
        }
        ccl7.setMustRevalidate(true);
        if (!ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("Equal Test setMustRevalidate failed." + newline);
        }
        if (ccl6.hashCode() != ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode Equal Test setMustRevalidate failed." + newline);
        }
        ccl6.setSMaxAge(-1);
        ccl7.setSMaxAge(200);
        if (ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("UnEqual Test setSMaxAge failed." + newline);
        }
        if (ccl6.hashCode() == ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setSMaxAge failed." + newline);
        }
        ccl7.setSMaxAge(-1);
        if (!ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("Equal Test setSMaxAge failed." + newline);
        }
        if (ccl6.hashCode() != ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setSMaxAge failed." + newline);
        }
        ccl6.setMaxAge(-1);
        ccl7.setMaxAge(200);
        if (ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("UnEqual Test setMaxAge failed." + newline);
        }
        if (ccl6.hashCode() == ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setMaxAge failed." + newline);
        }
        ccl7.setMaxAge(-1);
        if (!ccl6.equals((Object)ccl7)) {
            pass = false;
            sb.append("Equal Test setMaxAge failed." + newline);
        }
        if (ccl6.hashCode() != ccl7.hashCode()) {
            pass = false;
            sb.append("HashCode UnEqual Test setMaxAge failed." + newline);
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void toStringTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        CacheControl ccl8 = new CacheControl();
        ccl8.setProxyRevalidate(true);
        ccl8.setPrivate(true);
        ccl8.setNoTransform(true);
        ccl8.setNoStore(true);
        ccl8.setNoCache(true);
        ccl8.setMustRevalidate(false);
        ccl8.setSMaxAge(-1);
        ccl8.setMaxAge(200);
        String value = ccl8.toString().toLowerCase();
        sb.append(value + newline);
        if (!value.contains("private")) {
            pass = false;
            sb.append("ToString test failed in Private" + newline);
        }
        if (!value.contains("no-cache")) {
            pass = false;
            sb.append("ToString test failed in no-cache" + newline);
        }
        if (!value.contains("no-store")) {
            pass = false;
            sb.append("ToString test failed in no-store" + newline);
        }
        if (!value.contains("no-transform")) {
            pass = false;
            sb.append("ToString test failed in no-transform" + newline);
        }
        if (!value.contains("proxy-revalidate")) {
            pass = false;
            sb.append("ToString test failed in proxy-revalidate" + newline);
        }
        if (!value.contains("max-age=200")) {
            pass = false;
            sb.append("ToString test failed in max-age=200" + newline);
        }
        if (value.contains("s-maxage")) {
            pass = false;
            sb.append("ToString test failed in s-maxage" + newline);
        }
        if (value.contains("must-revalidate")) {
            pass = false;
            sb.append("ToString test failed in must-revalidate" + newline);
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb));
    }

    @Test
    public void getExtensionTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map_exp = new HashMap<String, String>();
        map_exp.put("community", "\"UCI\"");
        CacheControl ccl8 = new CacheControl();
        ccl8.setProxyRevalidate(true);
        ccl8.setPrivate(true);
        ccl8.setNoTransform(true);
        ccl8.setNoStore(true);
        ccl8.setNoCache(true);
        ccl8.setMustRevalidate(false);
        ccl8.setSMaxAge(-1);
        ccl8.setMaxAge(200);
        Map map_actual = ccl8.getCacheExtension();
        if (map_actual.size() != 0) {
            pass = false;
            sb.append("Expected map size 0, got" + map_actual.size() + newline);
        }
        map_actual.put("community", "\"UCI\"");
        map_actual = ccl8.getCacheExtension();
        if (!map_exp.equals(map_actual)) {
            pass = false;
            sb.append("Map comparison failed" + newline);
        }
        sb.append("Expected Map: ");
        for (Map.Entry entry : map_exp.entrySet()) {
            sb.append("key=" + (String)entry.getKey() + "; value=" + (String)entry.getValue() + ";" + newline);
        }
        if (!pass) {
            for (Map.Entry entry : map_actual.entrySet()) {
                sb.append("key= " + (String)entry.getKey() + "; value=" + (String)entry.getValue() + ";");
                sb.append(newline);
            }
            throw new JAXRSCommonClient.Fault("At least one assertion failed: " + sb.toString());
        }
        TestUtil.logTrace(sb.toString());
    }

    @Test
    public void valueOfTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        String value_to_parse = "private, no-cache, no-store, no-transform, proxy-revalidate, max-age=200";
        CacheControl ccl8 = CacheControl.valueOf((String)value_to_parse);
        String value = ccl8.toString().toLowerCase();
        sb.append(value + newline);
        if (!value.contains("private")) {
            pass = false;
            sb.append("ToString test failed in Private" + newline);
        }
        if (!value.contains("no-cache")) {
            pass = false;
            sb.append("ToString test failed in no-cache" + newline);
        }
        if (!value.contains("no-store")) {
            pass = false;
            sb.append("ToString test failed in no-store" + newline);
        }
        if (!value.contains("no-transform")) {
            pass = false;
            sb.append("ToString test failed in no-transform" + newline);
        }
        if (!value.contains("proxy-revalidate")) {
            pass = false;
            sb.append("ToString test failed in proxy-revalidate" + newline);
        }
        if (!value.contains("max-age=200")) {
            pass = false;
            sb.append("ToString test failed in max-age=200" + newline);
        }
        if (value.contains("s-maxage")) {
            pass = false;
            sb.append("ToString test failed in s-maxage" + newline);
        }
        if (value.contains("must-revalidate")) {
            pass = false;
            sb.append("ToString test failed in must-revalidate" + newline);
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb));
        TestUtil.logTrace("Test passed. " + sb.toString());
    }

    @Test
    public void valueOfTest1() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        try {
            CacheControl.valueOf(null);
            pass = false;
            sb.append("Expected IllegalArgumentException not thrown" + newline);
        }
        catch (IllegalArgumentException iex) {
            sb.append("Expected IllegalArgumentException thrown" + newline);
        }
        catch (Throwable any) {
            sb.append("Wrong type of Exception thrown" + any.fillInStackTrace());
            pass = false;
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb));
        TestUtil.logTrace("Test passed. " + sb.toString());
    }

    @Override
    @BeforeEach
    public void cleanup() {
        JAXRSClientIT.expected[0] = true;
        JAXRSClientIT.expected[1] = false;
        JAXRSClientIT.expected[2] = false;
        JAXRSClientIT.expected[3] = false;
        JAXRSClientIT.expected[4] = true;
        JAXRSClientIT.expected[5] = false;
        JAXRSClientIT.expected[6] = false;
    }

    private static boolean verifyMaxAge(CacheControl ccl, int maxAge, StringBuffer sb) {
        boolean pass = true;
        if (ccl.getMaxAge() != maxAge) {
            pass = false;
            sb.append("set/getMaxAge test failed.  Expecting " + maxAge + ", got " + ccl.getMaxAge() + ".");
        }
        return pass;
    }

    private static boolean verifySMaxAge(CacheControl ccl, int maxAge, StringBuffer sb) {
        boolean pass = true;
        if (ccl.getSMaxAge() != maxAge) {
            pass = false;
            sb.append("set/getMaxAge test failed.  Expecting " + maxAge + ", got " + ccl.getMaxAge() + ".");
        }
        return pass;
    }

    private static boolean verifyList(Object[] expected, CacheControl ccl, StringBuffer sb) {
        boolean pass = true;
        if (ccl.isPrivate() != ((Boolean)expected[1]).booleanValue()) {
            pass = false;
            sb.append("isPrivate test failed.  Expecting =" + expected[1] + "; Got =" + ccl.isPrivate());
        }
        if (ccl.isNoCache() != ((Boolean)expected[2]).booleanValue()) {
            pass = false;
            sb.append("isNoCache test failed.  Expecting =" + expected[2] + "; Got =" + ccl.isNoCache());
        }
        if (ccl.isNoStore() != ((Boolean)expected[3]).booleanValue()) {
            pass = false;
            sb.append("isNoStore test failed.  Expecting =" + expected[3] + "; Got =" + ccl.isNoStore());
        }
        if (ccl.isNoTransform() != ((Boolean)expected[4]).booleanValue()) {
            pass = false;
            sb.append("isNoTransform test failed.  Expecting =" + expected[4] + "; Got =" + ccl.isNoTransform());
        }
        if (ccl.isMustRevalidate() != ((Boolean)expected[5]).booleanValue()) {
            pass = false;
            sb.append("isMustRevalidate test failed.  Expecting =" + expected[5] + "; Got =" + ccl.isMustRevalidate());
        }
        if (ccl.isProxyRevalidate() != ((Boolean)expected[6]).booleanValue()) {
            pass = false;
            sb.append("isProxyRevalidate test failed.  Expecting =" + expected[6] + "; Got =" + ccl.isProxyRevalidate());
        }
        if (!ccl.getPrivateFields().equals(expected[7])) {
            pass = false;
            sb.append("getPrivateFields test failed.  Expecting =" + expected[7] + "; Got =" + ccl.getPrivateFields());
        }
        if (!ccl.getNoCacheFields().equals(expected[8])) {
            pass = false;
            sb.append("getNoCacheFields test failed.  Expecting =" + expected[8] + "; Got =" + ccl.getNoCacheFields());
        }
        return pass;
    }
}

