/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigValue;
import io.helidon.common.mapper.DefaultsResolver;
import io.helidon.config.Configuration;
import io.helidon.service.registry.Dependency;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Service.Singleton
class ConfigurationValueFactory
implements Service.QualifiedFactory<Object, Configuration.Value> {
    private final Supplier<DefaultsResolver> defaultsResolver;
    private final Supplier<Config> config;

    ConfigurationValueFactory(Supplier<DefaultsResolver> defaultsResolver, Supplier<Config> config) {
        this.defaultsResolver = defaultsResolver;
        this.config = config;
    }

    public Optional<Service.QualifiedInstance<Object>> first(Qualifier qualifier, Lookup lookup, GenericType<Object> type) {
        List<Service.QualifiedInstance<Object>> list = this.list(qualifier, lookup, type);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list.getFirst());
    }

    public List<Service.QualifiedInstance<Object>> list(Qualifier qualifier, Lookup lookup, GenericType<Object> type) {
        Optional maybeDependency = lookup.dependency();
        String key = qualifier.value().filter(Predicate.not(String::isBlank)).orElseGet(() -> this.obtainKey(lookup, maybeDependency));
        Config configInstance = this.config.get();
        Config configAtKey = configInstance.get(key);
        List<Object> values = List.of();
        if (configAtKey.isList()) {
            values = this.listValues(qualifier, configAtKey, type);
        } else if (configAtKey.exists()) {
            ConfigValue configValue = configInstance.get(key).as(type.rawType());
            values = configValue.isEmpty() ? List.of() : List.of(Service.QualifiedInstance.create((Object)configValue.get(), (Qualifier[])new Qualifier[]{qualifier}));
        }
        if (values.isEmpty()) {
            values = this.defaultValues(qualifier, type, maybeDependency);
        }
        return values;
    }

    private String obtainKey(Lookup lookup, Optional<Dependency> maybeDependency) {
        Dependency ip = maybeDependency.orElseThrow(() -> new IllegalStateException("Configuration.Value does not specify a value (configuration key), yet dependency is not provided in lookup. Cannot infer key. Lookup: " + String.valueOf(lookup)));
        return ip.service().fqName() + "." + ip.name();
    }

    private List<Service.QualifiedInstance<Object>> listValues(Qualifier qualifier, Config configAtKey, GenericType<Object> type) {
        ConfigValue list = configAtKey.asList(type.rawType());
        if (list.isEmpty()) {
            return List.of();
        }
        return ((List)list.get()).stream().map(it -> Service.QualifiedInstance.create((Object)it, (Qualifier[])new Qualifier[]{qualifier})).collect(Collectors.toUnmodifiableList());
    }

    private List<Service.QualifiedInstance<Object>> defaultValues(Qualifier qualifier, GenericType<Object> type, Optional<Dependency> maybeDependency) {
        if (maybeDependency.isEmpty()) {
            return List.of();
        }
        Dependency dependency = maybeDependency.get();
        if (dependency.annotations().isEmpty()) {
            return List.of();
        }
        return this.defaultsResolver.get().resolve(dependency.annotations(), type, dependency.name()).stream().map(it -> it).map(it -> Service.QualifiedInstance.create((Object)it, (Qualifier[])new Qualifier[]{qualifier})).collect(Collectors.toUnmodifiableList());
    }
}

