/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors;

import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutDefine;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.event.EncodeEvent;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class LayoutInsert
extends LayoutElementBase {
    private static final long serialVersionUID = 1L;
    private String name;

    public LayoutInsert(LayoutElement parent, String id) {
        super(parent, id);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected boolean encodeThis(FacesContext context, UIComponent component) throws IOException {
        Stack<LayoutElement> stack = LayoutComposition.getCompositionStack(context);
        if (stack.empty()) {
            return true;
        }
        Object name = this.getName();
        if (name == null) {
            this.encodeChildren(context, component, (LayoutElement)stack.get(0));
        } else {
            LayoutDefine def = LayoutInsert.findLayoutDefine(context, component, stack, (String)(name = "" + this.resolveValue(context, component, name)));
            if (def == null) {
                return true;
            }
            this.encodeChildren(context, component, def);
        }
        return false;
    }

    private void encodeChildren(FacesContext context, UIComponent component, LayoutElement parentElt) throws IOException {
        this.dispatchHandlers(context, "encode", new EncodeEvent(component));
        LayoutElement childElt2 = null;
        for (LayoutElement childElt2 : parentElt.getChildLayoutElements()) {
            childElt2.encode(context, component);
        }
    }

    public static LayoutDefine findLayoutDefine(FacesContext context, UIComponent parent, List<LayoutElement> eltList, String name) {
        Iterator<LayoutElement> stackIt = eltList.iterator();
        LayoutDefine define = null;
        while (stackIt.hasNext()) {
            define = LayoutInsert.findLayoutDefine(context, parent, stackIt.next(), name);
            if (define == null) continue;
            return define;
        }
        return null;
    }

    private static LayoutDefine findLayoutDefine(FacesContext context, UIComponent parent, LayoutElement elt, String name) {
        Iterator<LayoutElement> it = elt.getChildLayoutElements().iterator();
        LayoutElement def = null;
        while (it.hasNext()) {
            def = it.next();
            if (!(def instanceof LayoutDefine) || !def.getId(context, parent).equals(name)) continue;
            return (LayoutDefine)def;
        }
        it = elt.getChildLayoutElements().iterator();
        while (it.hasNext()) {
            def = LayoutInsert.findLayoutDefine(context, parent, it.next(), name);
            if (def == null) continue;
            return (LayoutDefine)def;
        }
        return null;
    }
}

