/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.drda;

import java.io.PrintWriter;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

public class NetworkServerControl {
    public static final int DEFAULT_PORTNUMBER = 1527;
    private static final String DERBYNET_JAR = "derbynet.jar";
    private static final String DERBY_HOSTNAME_WILDCARD = "0.0.0.0";
    private static final String IPV6_HOSTNAME_WILDCARD = "::";
    private static final String SOCKET_PERMISSION_HOSTNAME_WILDCARD = "*";
    private NetworkServerControlImpl serverImpl;

    public NetworkServerControl(InetAddress inetAddress, int n, String string, String string2) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(inetAddress, n, string, string2);
    }

    public NetworkServerControl(String string, String string2) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(string, string2);
    }

    public NetworkServerControl(InetAddress inetAddress, int n) throws Exception {
        this.serverImpl = new NetworkServerControlImpl(inetAddress, n);
    }

    public NetworkServerControl() throws Exception {
        this.serverImpl = new NetworkServerControlImpl();
    }

    public static void main(String[] stringArray) {
        NetworkServerControlImpl networkServerControlImpl = null;
        boolean bl = true;
        try {
            networkServerControlImpl = new NetworkServerControlImpl();
            int n = networkServerControlImpl.parseArgs(stringArray);
            if (n == 0) {
                try {
                    System.setProperty("derby.__serverStartedFromCmdLine", "true");
                }
                catch (Exception exception) {
                    networkServerControlImpl.consoleExceptionPrintTrace(exception);
                    System.exit(1);
                }
            }
            bl = false;
            networkServerControlImpl.executeWork(n);
        }
        catch (Exception exception) {
            if (exception.getMessage() == null || !exception.getMessage().equals("Unexpected exception") || bl) {
                if (networkServerControlImpl != null) {
                    networkServerControlImpl.consoleExceptionPrint(exception);
                } else {
                    exception.printStackTrace();
                }
            }
            System.exit(1);
        }
        System.exit(0);
    }

    public void start(PrintWriter printWriter) throws Exception {
        this.serverImpl.start(printWriter);
    }

    public void shutdown() throws Exception {
        this.serverImpl.shutdown();
    }

    public void ping() throws Exception {
        this.serverImpl.ping();
    }

    public void trace(boolean bl) throws Exception {
        this.serverImpl.trace(bl);
    }

    public void trace(int n, boolean bl) throws Exception {
        this.serverImpl.trace(n, bl);
    }

    public void logConnections(boolean bl) throws Exception {
        this.serverImpl.logConnections(bl);
    }

    public void setTraceDirectory(String string) throws Exception {
        this.serverImpl.sendSetTraceDirectory(string);
    }

    public String getSysinfo() throws Exception {
        return this.serverImpl.sysinfo();
    }

    public String getRuntimeInfo() throws Exception {
        return this.serverImpl.runtimeInfo();
    }

    public void setMaxThreads(int n) throws Exception {
        this.serverImpl.netSetMaxThreads(n);
    }

    public int getMaxThreads() throws Exception {
        String string = this.serverImpl.getCurrentProperties().getProperty("derby.drda.maxThreads");
        return Integer.parseInt(string);
    }

    public void setTimeSlice(int n) throws Exception {
        this.serverImpl.netSetTimeSlice(n);
    }

    public int getTimeSlice() throws Exception {
        String string = this.serverImpl.getCurrentProperties().getProperty("derby.drda.timeSlice");
        return Integer.parseInt(string);
    }

    public Properties getCurrentProperties() throws Exception {
        return this.serverImpl.getCurrentProperties();
    }

    protected void setClientLocale(String string) {
        this.serverImpl.setClientLocale(string);
    }

    private static boolean hostnamesEqual(String string, String string2) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getByName(string2);
            return inetAddress.equals(inetAddress2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isIPV6Address(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ':' || Character.digit(c, 16) >= 0) continue;
            return false;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress instanceof Inet6Address;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

