/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public final class JavaScriptUtilities {
    private JavaScriptUtilities() {
    }

    public static void renderHeaderScriptTags(boolean debug, boolean parseWidgets, ResponseWriter writer) throws IOException {
        JsonObject path = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("webui/suntheme", "../../com/sun/webui/jsf/suntheme/javascript").build();
        JsonObject json = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("isDebug", debug).add("debugAtAllCosts", debug).add("parseWidgets", parseWidgets).add("async", true).add("paths", (JsonValue)path).build();
        StringWriter buff = new StringWriter();
        buff.append("var dojoConfig=");
        JsonWriter jsonWriter = JsonUtilities.JSON_WRITER_FACTORY.createWriter((Writer)buff);
        jsonWriter.writeObject(json);
        buff.append(";\n");
        JavaScriptUtilities.renderScripTag(writer, buff.toString());
        JavaScriptUtilities.renderInclude(writer, "dojo");
        JavaScriptUtilities.renderInclude(writer, "helper");
        JavaScriptUtilities.renderInclude(writer, "prototype");
        JavaScriptUtilities.renderInclude(writer, "jsfx");
        String[] jsFiles = JavaScriptUtilities.getTheme().getGlobalJSFiles();
        if (jsFiles == null) {
            return;
        }
        for (String jsFile : jsFiles) {
            String file = jsFile;
            if (file == null) continue;
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeURIAttribute("src", (Object)file.toString(), null);
            writer.endElement("script");
            writer.write("\n");
        }
    }

    public static String getDomNode(FacesContext context, UIComponent component) {
        return "document.getElementById('" + component.getClientId(context) + "')";
    }

    public static String getModuleName(String name) {
        return "webui/suntheme" + "/" + name;
    }

    public static void renderInitScriptTag(ResponseWriter writer, String moduleName, JsonObject properties, String ... extraCalls) throws IOException {
        if (properties == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(JavaScriptUtilities.renderInitCall(moduleName, properties));
        if (extraCalls != null) {
            for (String extraCall : extraCalls) {
                sb.append(extraCall);
                sb.append("\n");
            }
        }
        JavaScriptUtilities.renderScripTag(writer, sb.toString());
    }

    public static void renderInitScriptTag(ResponseWriter writer, String moduleName, JsonObject properties) throws IOException {
        JavaScriptUtilities.renderInitScriptTag(writer, moduleName, properties, null);
    }

    public static String renderInitCall(String moduleName, JsonObject properties) throws IllegalArgumentException {
        if (properties == null) {
            throw new IllegalArgumentException("event type is null");
        }
        return JavaScriptUtilities.renderCall("init_elt", moduleName, properties);
    }

    public static String renderEventCall(String moduleName, String extraCall, String eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException("event type is null");
        }
        return JavaScriptUtilities.renderCalls(JavaScriptUtilities.renderCall(eventType, moduleName, "this"), extraCall);
    }

    public static String renderCalls(String firstCall, String secondCall) {
        StringBuilder sb = new StringBuilder();
        if (firstCall != null) {
            sb.append(firstCall);
            if (!firstCall.endsWith(";")) {
                sb.append(";");
            }
        }
        if (secondCall != null) {
            sb.append(secondCall);
        }
        return sb.toString();
    }

    public static String renderCall(String methodName, Object ... arguments) {
        if (methodName == null) {
            throw new IllegalArgumentException("method name is null");
        }
        StringBuilder buff = new StringBuilder();
        buff.append("ws_").append(methodName).append("(");
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                if (i > 0) {
                    buff.append(",");
                }
                if (arguments[i] == null) {
                    buff.append("null");
                    continue;
                }
                if (arguments[i] instanceof JsonObject) {
                    StringWriter jsonWriter = new StringWriter();
                    JsonUtilities.writeJsonObject((JsonObject)arguments[i], jsonWriter);
                    buff.append(jsonWriter.toString());
                    continue;
                }
                if (arguments[i] instanceof List) {
                    if (((List)arguments[i]).isEmpty()) {
                        buff.append("null");
                        continue;
                    }
                    buff.append("[");
                    Iterator it = ((List)arguments[i]).iterator();
                    while (it.hasNext()) {
                        buff.append("'").append(String.valueOf(it.next())).append("'");
                        if (!it.hasNext()) continue;
                        buff.append(",");
                    }
                    buff.append("]");
                    continue;
                }
                if (arguments[i] instanceof String && "this".equals((String)arguments[i])) {
                    buff.append("this");
                    continue;
                }
                buff.append("'").append(String.valueOf(arguments[i])).append("'");
            }
        }
        return buff.append(");").toString();
    }

    public static void renderScripTag(ResponseWriter writer, String jsCode) throws IOException {
        if (jsCode == null) {
            return;
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n");
        writer.write(jsCode);
        writer.endElement("script");
        writer.write("\n");
    }

    private static void renderInclude(ResponseWriter writer, String file) throws IOException {
        if (file == null) {
            return;
        }
        String jsFile = JavaScriptUtilities.getTheme().getPathToJSFile(file);
        if (jsFile == null) {
            return;
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeURIAttribute("src", (Object)jsFile, null);
        writer.endElement("script");
        writer.write("\n");
    }

    private static Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }
}

