/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.naming.NamingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.contexts.ContextNotActiveException;
import org.jboss.weld.exceptions.AmbiguousResolutionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.UnsatisfiedResolutionException;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.logging.WeldLogger;

public class BeanManagerLogger_$logger
extends DelegatingBasicLogger
implements BeanManagerLogger,
WeldLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BeanManagerLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public BeanManagerLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String cannotLocateBeanManager$str() {
        return "WELD-001300: Unable to locate BeanManager";
    }

    @Override
    public final NamingException cannotLocateBeanManager() {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.cannotLocateBeanManager$str(), new Object[0]));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String invalidQualifier$str() {
        return "WELD-001301: Annotation {0} is not a qualifier";
    }

    @Override
    public final IllegalArgumentException invalidQualifier(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.invalidQualifier$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String duplicateQualifiers$str() {
        return "WELD-001302: Duplicate qualifiers:  {0}";
    }

    @Override
    public final IllegalArgumentException duplicateQualifiers(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.duplicateQualifiers$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String contextNotActive$str() {
        return "WELD-001303: No active contexts for scope type {0}";
    }

    @Override
    public final ContextNotActiveException contextNotActive(Object param1) {
        ContextNotActiveException result = new ContextNotActiveException(this._formatMessage(this.contextNotActive$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String duplicateActiveContexts$str() {
        return "WELD-001304: More than one context active for scope type {0}";
    }

    @Override
    public final IllegalStateException duplicateActiveContexts(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.duplicateActiveContexts$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String specifiedTypeNotBeanType$str() {
        return "WELD-001305: The given type {0} is not a type of the bean {1}";
    }

    @Override
    public final IllegalArgumentException specifiedTypeNotBeanType(Object param1, Object param2) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.specifiedTypeNotBeanType$str(), param1, param2));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unresolvableType$str() {
        return "WELD-001307: Unable to resolve any beans of type {0} with qualifiers {1}";
    }

    @Override
    public final UnsatisfiedResolutionException unresolvableType(Object param1, Object param2) {
        UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(this._formatMessage(this.unresolvableType$str(), param1, param2));
        BeanManagerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String unresolvableElement$str() {
        return "WELD-001308: Unable to resolve any beans for {0}";
    }

    @Override
    public final UnsatisfiedResolutionException unresolvableElement(Object param1) {
        UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(this._formatMessage(this.unresolvableElement$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String noDecoratorTypes$str() {
        return "WELD-001310: No decorator types were specified in the set";
    }

    @Override
    public final IllegalArgumentException noDecoratorTypes() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.noDecoratorTypes$str(), new Object[0]));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interceptorBindingsEmpty$str() {
        return "WELD-001311: Interceptor bindings list cannot be empty";
    }

    @Override
    public final IllegalArgumentException interceptorBindingsEmpty() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.interceptorBindingsEmpty$str(), new Object[0]));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateInterceptorBinding$str() {
        return "WELD-001312: Duplicate interceptor binding type {0} found";
    }

    @Override
    public final IllegalArgumentException duplicateInterceptorBinding(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.duplicateInterceptorBinding$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String interceptorResolutionWithNonbindingType$str() {
        return "WELD-001313: Trying to resolve interceptors with non-binding type {0}";
    }

    @Override
    public final IllegalArgumentException interceptorResolutionWithNonbindingType(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.interceptorResolutionWithNonbindingType$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonNormalScope$str() {
        return "WELD-001314: {0} is expected to be a normal scope type";
    }

    @Override
    public final String nonNormalScope(Object param1) {
        return this._formatMessage(this.nonNormalScope$str(), param1);
    }

    protected String notInterceptorBindingType$str() {
        return "WELD-001316: {0} is not an interceptor binding type";
    }

    @Override
    public final IllegalArgumentException notInterceptorBindingType(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.notInterceptorBindingType$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notStereotype$str() {
        return "WELD-001317: {0} is not a stereotype";
    }

    @Override
    public final IllegalArgumentException notStereotype(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.notStereotype$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ambiguousBeansForDependency$str() {
        return "WELD-001318: Cannot resolve an ambiguous dependency between: {0}";
    }

    @Override
    public final AmbiguousResolutionException ambiguousBeansForDependency(Object param1) {
        AmbiguousResolutionException result = new AmbiguousResolutionException(this._formatMessage(this.ambiguousBeansForDependency$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String nullBeanManagerId$str() {
        return "WELD-001319: Bean manager ID must not be null";
    }

    @Override
    public final IllegalArgumentException nullBeanManagerId() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullBeanManagerId$str(), new Object[0]));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noInstanceOfExtension$str() {
        return "WELD-001325: No instance of an extension {0} registered with the deployment";
    }

    @Override
    public final IllegalArgumentException noInstanceOfExtension(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.noInstanceOfExtension$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateBeanAttributesForIncorrectAnnotatedMember$str() {
        return "WELD-001326: Cannot create bean attributes - the argument must be either an AnnotatedField or AnnotatedMethod but {0} is not";
    }

    @Override
    public final IllegalArgumentException cannotCreateBeanAttributesForIncorrectAnnotatedMember(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.cannotCreateBeanAttributesForIncorrectAnnotatedMember$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String ambiguousBeanManager$str() {
        return "WELD-001327: Unable to identify the correct BeanManager. The calling class {0} is placed in multiple bean archives";
    }

    @Override
    public final IllegalStateException ambiguousBeanManager(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.ambiguousBeanManager$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsatisfiedBeanManager$str() {
        return "WELD-001328: Unable to identify the correct BeanManager. The calling class {0} is not placed in bean archive";
    }

    @Override
    public final IllegalStateException unsatisfiedBeanManager(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unsatisfiedBeanManager$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToIdentifyBeanManager$str() {
        return "WELD-001329: Unable to identify the correct BeanManager";
    }

    @Override
    public final IllegalStateException unableToIdentifyBeanManager() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unableToIdentifyBeanManager$str(), new Object[0]));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beanManagerNotAvailable$str() {
        return "WELD-001330: BeanManager is not available.";
    }

    @Override
    public final IllegalStateException beanManagerNotAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.beanManagerNotAvailable$str(), new Object[0]));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullDeclaringBean$str() {
        return "WELD-001331: Declaring bean cannot be null for the non-static member {0}";
    }

    @Override
    public final IllegalArgumentException nullDeclaringBean(Object param1) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.nullDeclaringBean$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String methodNotAvailableDuringInitialization$str() {
        return "WELD-001332: BeanManager method {0} is not available during application initialization. Container state: {1}";
    }

    @Override
    public final IllegalStateException methodNotAvailableDuringInitialization(Object param1, Object state) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.methodNotAvailableDuringInitialization$str(), param1, state));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String methodNotAvailableAfterShutdown$str() {
        return "WELD-001333: BeanManager method {0} is not available after shutdown";
    }

    @Override
    public final IllegalStateException methodNotAvailableAfterShutdown(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.methodNotAvailableAfterShutdown$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String injectionPointHasUnsatisfiedDependencies$str() {
        return "WELD-001334: Unsatisfied dependencies for type {1} with qualifiers {0} {2}";
    }

    @Override
    public final UnsatisfiedResolutionException injectionPointHasUnsatisfiedDependencies(Object param1, Object param2, Object param3) {
        UnsatisfiedResolutionException result = new UnsatisfiedResolutionException(this._formatMessage(this.injectionPointHasUnsatisfiedDependencies$str(), param1, param2, param3));
        BeanManagerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String injectionPointHasAmbiguousDependencies$str() {
        return "WELD-001335: Ambiguous dependencies for type {1} with qualifiers {0}\n Possible dependencies: {2}";
    }

    @Override
    public final AmbiguousResolutionException injectionPointHasAmbiguousDependencies(Object param1, Object param2, Object param3) {
        AmbiguousResolutionException result = new AmbiguousResolutionException(this._formatMessage(this.injectionPointHasAmbiguousDependencies$str(), param1, param2, param3));
        BeanManagerLogger_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String unableToConfigureInjectionTargetFactory$str() {
        return "WELD-001336: InjectionTargetFactory.configure() may not be called after createInjectionTarget() invocation. AnnotatedType used: {0}";
    }

    @Override
    public final IllegalStateException unableToConfigureInjectionTargetFactory(Object param1) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.unableToConfigureInjectionTargetFactory$str(), param1));
        BeanManagerLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void catchingDebug(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.DEBUG, throwable, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }
}

