/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.LegacyConfigurationUpgrade;
import org.glassfish.config.support.IntrospectionUtils;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

public abstract class BaseLegacyConfigurationUpgrade
implements LegacyConfigurationUpgrade {
    protected void report(AdminCommandContext context, String message) {
        context.getActionReport().setMessage("DEPRECATION WARNING: " + message);
    }

    protected void updatePropertyToAttribute(final AdminCommandContext context, final ConfigBeanProxy target, final String property, final String attribute) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ConfigBeanProxy>(){

            public Object run(ConfigBeanProxy param) {
                PropertyBag bag = (PropertyBag)param;
                ArrayList<Property> propertyList = new ArrayList<Property>(bag.getProperty());
                IntrospectionUtils.setProperty(target, attribute, BaseLegacyConfigurationUpgrade.this.getValue(propertyList, property));
                String message = MessageFormat.format("Moved {0}.property.{1} to {0}.{2}", Dom.convertName((String)Dom.unwrap((ConfigBeanProxy)target).getProxyType().getSimpleName()), property, Dom.convertName((String)attribute));
                BaseLegacyConfigurationUpgrade.this.report(context, message);
                bag.getProperty().clear();
                bag.getProperty().addAll(propertyList);
                return param;
            }
        }, (ConfigBeanProxy)target);
    }

    protected void removeProperty(ConfigBeanProxy target, final String property) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ConfigBeanProxy>(){

            public Object run(ConfigBeanProxy param) {
                PropertyBag bag = (PropertyBag)param;
                ArrayList propertyList = new ArrayList(bag.getProperty());
                Iterator it = propertyList.iterator();
                boolean done = false;
                while (!done && it.hasNext()) {
                    Property prop = (Property)it.next();
                    if (!property.equals(prop.getName())) continue;
                    done = true;
                    it.remove();
                }
                bag.getProperty().clear();
                bag.getProperty().addAll(propertyList);
                return param;
            }
        }, (ConfigBeanProxy)target);
    }

    private String getValue(List<Property> list, String property) {
        Iterator<Property> iterator = list.iterator();
        while (iterator.hasNext()) {
            Property prop = iterator.next();
            if (!property.equals(prop.getName())) continue;
            iterator.remove();
            return prop.getValue();
        }
        return null;
    }
}

