/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.api;

public class BrokerStatus {
    public static final int BROKER_LINK_UP = 1;
    public static final int BROKER_INDOUBT = 16;
    public static final int BROKER_UP = 256;
    public static final int BROKER_UNKNOWN = 0;
    public static final int ACTIVATE_BROKER = 257;

    public static int setBrokerIsUp(int status) {
        int retval = status | 0x100;
        return retval;
    }

    public static boolean getBrokerIsUp(int status) {
        return (status & 0x100) == 256;
    }

    public static int setBrokerIsDown(int status) {
        int retval = status & 0xFFFFFEFF;
        return retval;
    }

    public static boolean getBrokerIsDown(int status) {
        return (status & 0x100) == 0;
    }

    public static int setBrokerLinkIsUp(int status) {
        int retval = status | 1;
        return retval;
    }

    public static boolean getBrokerLinkIsUp(int status) {
        return (status & 1) == 1;
    }

    public static int setBrokerLinkIsDown(int status) {
        int retval = status & 0xFFFFFFFE;
        return retval;
    }

    public static boolean getBrokerLinkIsDown(int status) {
        return (status & 1) == 0;
    }

    public static int setBrokerInDoubt(int status) {
        int retval = status | 0x10;
        return retval;
    }

    public static boolean getBrokerInDoubt(int status) {
        return (status & 0x10) == 16;
    }

    public static int setBrokerNotInDoubt(int status) {
        int retval = status & 0xFFFFFFEF;
        return retval;
    }

    public static boolean getBrokerNotInDoubt(int status) {
        return (status & 0x10) == 0;
    }

    public static String toString(int status) {
        return "BrokerStatus[" + BrokerStatus.getStatusString(status) + "]";
    }

    private static String getStatusString(int status) {
        Object str = "";
        str = BrokerStatus.getBrokerLinkIsUp(status) ? (String)str + "LINK_UP" : (String)str + "LINK_DOWN";
        str = BrokerStatus.getBrokerInDoubt(status) ? (String)str + ":IN_DOUBT" : (String)str + ":NOT_INDOUBT";
        str = BrokerStatus.getBrokerIsUp(status) ? (String)str + ":UP" : (String)str + ":DOWN";
        return str;
    }
}

