/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.xml;

import com.sun.messaging.bridge.service.jms.JMSBridge;
import java.util.Properties;

public class ConnectionFactoryElement {
    private Properties _attrs = null;
    private Properties _props = null;

    public void setAttributes(Properties a) {
        String refname = null;
        if (a != null) {
            refname = a.getProperty("ref-name");
            if (refname.equals("built-in-dmq") || refname.equals("imq.bridge.jms.dmq")) {
                throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4029", "ref-name=" + refname));
            }
            String username = a.getProperty("username");
            if (username != null) {
                if (username.trim().equals("")) {
                    Object[] eparam = new String[]{"username=" + username, "connection-factory=" + refname};
                    throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4035", eparam));
                }
                a.setProperty("username", username.trim());
                String password = a.getProperty("password");
                if (password == null) {
                    Object[] eparam = new String[]{"password", "connection-factory " + refname};
                    throw new IllegalArgumentException(JMSBridge.getJMSBridgeResources().getKString("BSJ4036", eparam));
                }
            }
        }
        this._attrs = a;
    }

    public void setProperties(Properties a) {
        this._props = a;
    }

    public Properties getAttributes() {
        return this._attrs;
    }

    public Properties getProperties() {
        return this._props;
    }

    public String getLookupName() {
        return this._attrs.getProperty("lookup-name");
    }

    public String getRefName() {
        return this._attrs.getProperty("ref-name");
    }

    public String getUsername() {
        String u = this._attrs.getProperty("username");
        if (u == null) {
            return null;
        }
        return u.trim();
    }

    public String getPassword() {
        return this._attrs.getProperty("password");
    }

    public boolean isMultiRM() {
        return Boolean.valueOf(this._attrs.getProperty("multi-rm", "false"));
    }

    public String toString() {
        return "connection-factory[" + this.getRefName() + "]";
    }
}

