/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.cfg;

import com.sun.enterprise.glassfish.bootstrap.cfg.FelixUtil;
import com.sun.enterprise.glassfish.bootstrap.cfg.OsgiPlatform;
import com.sun.enterprise.glassfish.bootstrap.cfg.ServerFiles;
import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextCfg;
import com.sun.enterprise.glassfish.bootstrap.log.LogFacade;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.embeddable.GlassFishVariable;

public final class StartupContextCfgFactory {
    private static final Path CONFIG_PROPERTIES = Path.of("config", "osgi.properties");

    private StartupContextCfgFactory() {
    }

    public static StartupContextCfg createStartupContextCfg(OsgiPlatform platform, ServerFiles files, Properties args) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)args);
        properties.setProperty("__time_zero", Long.toString(System.currentTimeMillis()));
        File installRoot = files.getInstallRoot().toFile();
        properties.setProperty(GlassFishVariable.INSTALL_ROOT.getPropertyName(), installRoot.getAbsolutePath());
        properties.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        File instanceRoot = files.getInstanceRoot().toFile();
        properties.setProperty(GlassFishVariable.INSTANCE_ROOT.getPropertyName(), instanceRoot.getAbsolutePath());
        properties.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        properties.setProperty("hk2.startup.context.mainModule", "org.glassfish.core.kernel");
        String upgrade = properties.getProperty("-upgrade");
        if (upgrade != null && !upgrade.equals("false")) {
            properties.setProperty("hk2.startup.context.moduleStartup", "upgrade");
        }
        return StartupContextCfgFactory.mergePlatformConfiguration(platform, files, properties);
    }

    private static StartupContextCfg mergePlatformConfiguration(OsgiPlatform platform, ServerFiles files, Properties properties) {
        Properties platformCfg;
        try {
            platformCfg = StartupContextCfgFactory.readPlatformConfiguration(StartupContextCfgFactory.getFrameworkConfigFile(files));
        }
        catch (IOException e) {
            throw new IllegalStateException("The OSGI configuration could not be loaded!", e);
        }
        String storageDirectoryName = platform.getFrameworkStorageDirectoryName();
        if (storageDirectoryName != null) {
            File frameworkStorage = files.getFileUnderInstanceRoot(Path.of("osgi-cache", storageDirectoryName));
            platformCfg.setProperty("org.osgi.framework.storage", frameworkStorage.getAbsolutePath());
        }
        platformCfg.putAll((Map<?, ?>)properties);
        for (String name : platformCfg.stringPropertyNames()) {
            platformCfg.setProperty(name, FelixUtil.substVars(platformCfg.getProperty(name), name, null, platformCfg));
        }
        StartupContextCfgFactory.overrideBySystemProps(platformCfg, Arrays.asList("felix.fileinstall.dir", "felix.fileinstall.log.level"));
        return new StartupContextCfg(platform, files, platformCfg);
    }

    private static Properties readPlatformConfiguration(File configFile) throws IOException {
        Properties platformConfig = new Properties();
        if (configFile == null) {
            return platformConfig;
        }
        try (FileInputStream in = new FileInputStream(configFile);){
            platformConfig.load(in);
        }
        return platformConfig;
    }

    private static File getFrameworkConfigFile(ServerFiles files) {
        File osgiPropertiesFile = files.getFileUnderInstanceRoot(CONFIG_PROPERTIES);
        if (osgiPropertiesFile.exists()) {
            LogFacade.BOOTSTRAP_LOGGER.log(Level.INFO, "NCLS-BOOTSTRAP-00002", osgiPropertiesFile);
            return osgiPropertiesFile;
        }
        return files.getFileUnderInstallRoot(CONFIG_PROPERTIES);
    }

    private static void overrideBySystemProps(Properties osgiCfg, Collection<String> excluding) {
        Properties sysProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : osgiCfg.entrySet()) {
            Object systemPropValue;
            if (excluding.contains(entry.getKey()) || (systemPropValue = sysProps.get(entry.getKey())) == null || systemPropValue.equals(entry.getValue())) continue;
            osgiCfg.put(entry.getKey(), systemPropValue);
        }
    }
}

