/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import java.util.List;
import org.glassfish.appclient.client.acc.AgentArguments;

public class CommandLaunchInfo {
    private static final String CLIENT_AGENT_ARG_NAME = "client";
    private static final String APPCPATH = "appcpath";
    private ClientLaunchType clientLaunchType;
    private String clientName;
    private String appcPath;

    public static CommandLaunchInfo newInstance(AgentArguments agentArgs) {
        CommandLaunchInfo result = new CommandLaunchInfo(agentArgs);
        return result;
    }

    private CommandLaunchInfo(AgentArguments agentArgs) {
        this.clientLaunchType = this.saveArgInfo(agentArgs);
    }

    public String getClientName() {
        return this.clientName;
    }

    public ClientLaunchType getClientLaunchType() {
        return this.clientLaunchType;
    }

    public String getAppcPath() {
        return this.appcPath;
    }

    private ClientLaunchType saveArgInfo(AgentArguments agentArgs) {
        if (agentArgs == null) {
            return ClientLaunchType.UNKNOWN;
        }
        ClientLaunchType result = ClientLaunchType.UNKNOWN;
        String s = this.lastFromList(agentArgs.namedValues(CLIENT_AGENT_ARG_NAME));
        if (s != null) {
            result = this.processClientArg(s);
        }
        if ((s = this.lastFromList(agentArgs.namedValues(APPCPATH))) != null) {
            this.processAppcPath(s);
        }
        return result;
    }

    private String lastFromList(List<String> list) {
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private ClientLaunchType processClientArg(String clientSpec) {
        int equalsSign = clientSpec.indexOf(61);
        String clientType = clientSpec.substring(0, equalsSign);
        this.clientName = clientSpec.substring(equalsSign + 1);
        if (this.clientName.startsWith("\"") && this.clientName.endsWith("\"")) {
            this.clientName = this.clientName.substring(1, this.clientName.length() - 1);
        }
        return ClientLaunchType.byType(clientType);
    }

    private void processAppcPath(String appcPath) {
        this.appcPath = appcPath;
    }

    public static enum ClientLaunchType {
        JAR,
        DIR(true),
        CLASSFILE(true),
        CLASS,
        URL,
        UNKNOWN;

        private final boolean usesAppClientCommandForMainProgram;

        private ClientLaunchType() {
            this(false);
        }

        private ClientLaunchType(boolean usesAppClientCommandForMainProgram) {
            this.usesAppClientCommandForMainProgram = usesAppClientCommandForMainProgram;
        }

        boolean usesAppClientCommandForMainProgram() {
            return this.usesAppClientCommandForMainProgram;
        }

        static ClientLaunchType byType(String lowerCaseType) {
            for (ClientLaunchType t : ClientLaunchType.values()) {
                if (!t.name().equalsIgnoreCase(lowerCaseType)) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

