/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.ReflectionDiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.jandex.Jandex;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.ServiceLoader;

public final class DiscoveryStrategyFactory {
    private DiscoveryStrategyFactory() {
    }

    public static DiscoveryStrategy create(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations, boolean jandexStrategyDisabled, BeanDiscoveryMode emptyBeansXmlDiscoveryMode) {
        DiscoveryStrategy returnValue = null;
        Iterator<Metadata<DiscoveryStrategy>> iterator = ServiceLoader.load(DiscoveryStrategy.class, resourceLoader).iterator();
        if (iterator != null && iterator.hasNext()) {
            DiscoveryStrategy candidate = iterator.next().getValue();
            if (candidate != null) {
                candidate.setResourceLoader(resourceLoader);
                candidate.setBootstrap(bootstrap);
                candidate.setInitialBeanDefiningAnnotations(initialBeanDefiningAnnotations);
                CommonLogger.LOG.usingServiceLoaderSourcedDiscoveryStrategy(candidate);
                returnValue = candidate;
            }
        } else if (Jandex.isJandexAvailable(resourceLoader)) {
            if (jandexStrategyDisabled) {
                CommonLogger.LOG.jandexDiscoveryStrategyDisabled();
            } else {
                CommonLogger.LOG.usingJandex();
                try {
                    returnValue = Jandex.createJandexDiscoveryStrategy(resourceLoader, bootstrap, initialBeanDefiningAnnotations, emptyBeansXmlDiscoveryMode);
                }
                catch (Exception e) {
                    throw CommonLogger.LOG.unableToInstantiate("org.jboss.weld.environment.deployment.discovery.jandex.JandexDiscoveryStrategy", Arrays.toString(new Object[]{resourceLoader, bootstrap, initialBeanDefiningAnnotations, emptyBeansXmlDiscoveryMode}), e);
                }
            }
        }
        if (returnValue == null) {
            returnValue = new ReflectionDiscoveryStrategy(resourceLoader, bootstrap, initialBeanDefiningAnnotations, emptyBeansXmlDiscoveryMode);
        }
        return returnValue;
    }
}

