/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.remote.Metrix;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.util.StringUtils;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.config.InjectionManager;
import org.jvnet.hk2.config.InjectionResolver;

final class CLIContainer {
    private static final InjectionManager injectionMgr = new InjectionManager();
    private final Set<File> extensions;
    private final ClassLoader classLoader;
    private final Logger logger;
    private ServiceLocator serviceLocator;
    private ProgramOptions programOptions;
    private Environment environment;
    private Map<String, String> cliCommandsNames;

    CLIContainer(ClassLoader classLoader, Set<File> extensions, Logger logger) {
        this.classLoader = classLoader;
        this.extensions = extensions;
        this.logger = logger;
        try {
            this.cliCommandsNames = this.parseHk2Locators();
        }
        catch (IOException ex) {
            logger.log(Level.FINER, "Can't fast parse hk2 locators! HK2 ServiceLocator must be used");
        }
    }

    private Object createInstance(String name) throws ReflectiveOperationException {
        if (name == null) {
            return null;
        }
        Class<?> clazz = this.classLoader.loadClass(name);
        if (clazz.getAnnotation(PerLookup.class) == null) {
            return null;
        }
        Object result = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        SimpleInjectionResolver injector = new SimpleInjectionResolver(Inject.class);
        injectionMgr.inject(result, new InjectionResolver[]{injector});
        return result;
    }

    private void parseInHk2LocatorOrig(BufferedReader reader, Map<String, String> cliCommandNames) throws IOException {
        DescriptorImpl desc = new DescriptorImpl();
        while (desc.readObject(reader)) {
            if (!StringUtils.ok((String)desc.getName()) || !desc.getAdvertisedContracts().contains(CLICommand.class.getName())) continue;
            cliCommandNames.put(desc.getName(), desc.getImplementation());
        }
    }

    private Set<File> expandExtensions() throws IOException {
        HashSet<File> result = new HashSet<File>();
        for (File file : this.extensions) {
            if (file.isDirectory()) {
                File[] lf = file.listFiles((dir, name) -> name.toLowerCase(Locale.ENGLISH).endsWith(".jar"));
                result.addAll(Arrays.asList(lf));
                continue;
            }
            result.add(file);
        }
        File inst = new File(System.getProperty(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName()));
        File adminCliJar = new File(inst, "admin-cli.jar");
        if (!adminCliJar.exists()) {
            throw new IOException(adminCliJar.getAbsolutePath());
        }
        result.add(adminCliJar);
        return result;
    }

    private Map<String, String> parseHk2Locators() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Set<File> extFiles = this.expandExtensions();
        for (File file : extFiles) {
            try (JarFile jar = new JarFile(file);){
                ZipEntry entry = jar.getEntry("META-INF/hk2-locator/default");
                if (entry == null) continue;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(jar.getInputStream(entry), StandardCharsets.UTF_8));){
                    this.parseInHk2LocatorOrig(reader, result);
                }
            }
        }
        return result;
    }

    private String getCommandClassName(String name) throws IllegalStateException {
        if (this.cliCommandsNames == null) {
            throw new IllegalStateException();
        }
        return this.cliCommandsNames.get(name);
    }

    public ServiceLocator getServiceLocator() {
        if (this.serviceLocator == null) {
            Metrix.event((String)"Init hk2 - start");
            StaticModulesRegistry registry = new StaticModulesRegistry(this.classLoader);
            this.serviceLocator = registry.createServiceLocator("default");
            if (this.programOptions != null) {
                ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.serviceLocator, (Object)this.programOptions);
            }
            if (this.environment != null) {
                ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.serviceLocator, (Object)this.environment);
            }
            ServiceLocatorUtilities.addOneConstant((ServiceLocator)this.serviceLocator, (Object)this);
            Metrix.event((String)"Init hk2 - done");
        }
        return this.serviceLocator;
    }

    public CLICommand getLocalCommand(String name) {
        if (this.serviceLocator == null) {
            try {
                String className = this.getCommandClassName(name);
                if (className == null) {
                    this.logger.log(Level.FINER, "CLICommand not found for name {0}", name);
                    return null;
                }
                CLICommand result = (CLICommand)this.createInstance(className);
                if (result != null) {
                    this.logger.log(Level.FINER, "CLIContainer creates instance for command {0}", name);
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logger.log(Level.FINER, "HK2 Service locator will be used for command {0}", name);
        return (CLICommand)this.getServiceLocator().getService(CLICommand.class, name, new Annotation[0]);
    }

    public Set<String> getLocalCommandsNames() {
        return this.cliCommandsNames.keySet();
    }

    public void setProgramOptions(ProgramOptions programOptions) {
        this.programOptions = programOptions;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public ProgramOptions getProgramOptions() {
        return this.programOptions;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    class SimpleInjectionResolver
    extends InjectionResolver<Inject> {
        SimpleInjectionResolver(Class<Inject> type) {
            super(type);
        }

        public <V> V getValue(Object o, AnnotatedElement ae, Type genricType, Class<V> type) throws MultiException {
            if (type.isAssignableFrom(ProgramOptions.class)) {
                return (V)CLIContainer.this.getProgramOptions();
            }
            if (type.isAssignableFrom(Environment.class)) {
                return (V)CLIContainer.this.getEnvironment();
            }
            if (type.isAssignableFrom(CLIContainer.class)) {
                return (V)CLIContainer.this;
            }
            throw new IllegalStateException();
        }
    }
}

