/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.support;

import com.sun.jdo.api.persistence.support.JDOHelper;
import java.io.PrintStream;
import java.io.PrintWriter;

public class JDOException
extends RuntimeException {
    Exception nested;
    transient Object[] failed;

    public JDOException() {
    }

    public JDOException(String msg) {
        super(msg);
    }

    public JDOException(String msg, Exception nested) {
        super(msg, nested);
        this.nested = nested;
    }

    public JDOException(String msg, Object[] failed) {
        super(msg);
        this.failed = failed;
    }

    public JDOException(String msg, Exception nested, Object[] failed) {
        super(msg, nested);
        this.nested = nested;
        this.failed = failed;
    }

    public void addFailedObject(Object o) {
        if (this.failed == null) {
            this.failed = new Object[]{o};
        } else {
            int len = this.failed.length;
            Object[] ofailed = this.failed;
            this.failed = new Object[len + 1];
            for (int i = 0; i < len; ++i) {
                this.failed[i] = ofailed[i];
            }
            this.failed[len] = o;
        }
    }

    public Object[] getFailedObjectArray() {
        return this.failed;
    }

    public Exception getNestedException() {
        return this.nested;
    }

    @Override
    public String toString() {
        int len = 0;
        if (this.failed != null) {
            len = this.failed.length;
        }
        StringBuffer sb = new StringBuffer(100 + 10 * len);
        sb.append(super.toString());
        if (this.nested != null) {
            sb.append("\nNestedException: ");
            sb.append(this.nested.toString());
        }
        if (len > 0) {
            sb.append("\nFailedObjectArray: [");
            Object ofail = this.failed[0];
            sb.append(JDOHelper.printObject(ofail));
            for (int i = 1; i < len; ++i) {
                sb.append(", ");
                ofail = this.failed[i];
                sb.append(JDOHelper.printObject(ofail));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            if (this.nested != null) {
                s.println("\nNestedStackTrace: ");
                this.nested.printStackTrace(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            if (this.nested != null) {
                s.println("\nNestedStackTrace: ");
                this.nested.printStackTrace(s);
            }
        }
    }
}

