/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.widget;

import com.sun.webui.jsf.component.Widget;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

public abstract class RendererBase
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public final void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String widgetType = ((Widget)component).getWidgetType();
        boolean isSubComponent = component.getParent() instanceof Widget;
        if (!isSubComponent && widgetType != null) {
            StringBuilder widget = new StringBuilder();
            widget.append("<div data-dojo-type=\"webui/suntheme/widget/").append(widgetType).append("\" ").append((CharSequence)RendererBase.renderWidgetProp("id", component.getClientId(context)));
            JsonObject json = this.getProperties(context, component).build();
            for (Map.Entry entry : json.entrySet()) {
                widget.append((CharSequence)RendererBase.renderWidgetProp((String)entry.getKey(), ((JsonValue)entry.getValue()).toString()));
            }
            widget.append("\n");
            this.renderNestedContent(context, component);
            writer.append((CharSequence)"</div>\n").append(widget.toString());
        }
        if (!isSubComponent && widgetType != null) {
            writer.write(");\n");
            writer.endElement("script");
            writer.write("\n");
        }
        JavaScriptUtilities.renderScripTag(writer, JavaScriptUtilities.renderCall("widget_parse", Arrays.asList(this.getModuleNames(component))));
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected abstract String[] getModuleNames(UIComponent var1);

    protected abstract JsonObjectBuilder getProperties(FacesContext var1, UIComponent var2) throws IOException;

    protected abstract void renderNestedContent(FacesContext var1, UIComponent var2) throws IOException;

    protected static void addAttributeProperties(String[] names, UIComponent component, JsonObjectBuilder properties) {
        if (names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (String name : names) {
            Object value = attributes.get(name);
            if (value == null || value instanceof Integer && (Integer)value == Integer.MIN_VALUE) continue;
            properties.add(name, JsonUtilities.jsonValueOf(value));
        }
    }

    private static StringBuilder renderWidgetProp(String name, String value) {
        return new StringBuilder().append("data-dojo-props=\"").append(name).append(":'").append(value).append("'\" ");
    }
}

