/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.CommonTask;
import com.sun.webui.jsf.component.CommonTasksGroup;
import com.sun.webui.jsf.component.HelpInline;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import java.beans.Beans;
import java.util.List;

public final class CommonTasksSection
extends UIComponentBase
implements NamingContainer {
    public static final String HELP_INLINE_FACET = "help";
    public static final String SECTION_HELP = "commonTasks.sectionHelp";
    private UIComponent component;
    private String helpText = null;
    private String style = null;
    private String styleClass = null;
    private String title = null;
    private boolean visible = false;
    private boolean visibleSet = false;
    private int columns = Integer.MIN_VALUE;
    private boolean columnsSet = false;

    public CommonTasksSection() {
        this.setRendererType("com.sun.webui.jsf.CommonTasksSection");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.CommonTasksSection";
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public String getHelpText() {
        if (this.helpText != null) {
            return this.helpText;
        }
        ValueExpression vb = this.getValueExpression("helpText");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setHelpText(String newHelpText) {
        this.helpText = newHelpText;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        ValueExpression vb = this.getValueExpression("title");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public int getColumns() {
        if (this.columnsSet) {
            return this.columns;
        }
        ValueExpression vb = this.getValueExpression("columns");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)result;
        }
        return Integer.MIN_VALUE;
    }

    public void setColumns(int newColumns) {
        this.columns = newColumns;
        this.columnsSet = true;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.helpText = (String)values[1];
        this.style = (String)values[2];
        this.styleClass = (String)values[3];
        this.title = (String)values[4];
        this.visible = (Boolean)values[5];
        this.visibleSet = (Boolean)values[6];
        this.columns = (Integer)values[7];
        this.columnsSet = (Boolean)values[8];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[9];
        values[0] = super.saveState(context);
        values[1] = this.helpText;
        values[2] = this.style;
        values[3] = this.styleClass;
        values[4] = this.title;
        values[5] = this.visible ? Boolean.TRUE : Boolean.FALSE;
        values[6] = this.visibleSet ? Boolean.TRUE : Boolean.FALSE;
        values[8] = this.columnsSet ? Boolean.TRUE : Boolean.FALSE;
        values[7] = this.columns;
        return values;
    }

    public int getCommonTaskCount() {
        int totalCount = 0;
        List children = this.getChildren();
        if (children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                if (children.get(i) instanceof CommonTasksGroup) {
                    CommonTasksGroup ctg = (CommonTasksGroup)((Object)children.get(i));
                    int tmp = this.getSingleGroupTaskCount(ctg);
                    if (!ctg.isRendered() || !ctg.isVisible()) continue;
                    totalCount += tmp;
                    continue;
                }
                ++totalCount;
            }
        }
        return totalCount;
    }

    public UIComponent getHelp(FacesContext context) {
        HelpInline hil;
        this.component = this.getFacet(HELP_INLINE_FACET);
        if (this.component != null) {
            return this.component;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        Object comp = ComponentUtilities.getPrivateFacet((UIComponent)this, HELP_INLINE_FACET, true);
        if (comp == null) {
            hil = new HelpInline();
            hil.setType("page");
            hil.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, HELP_INLINE_FACET));
            ComponentUtilities.putPrivateFacet((UIComponent)this, HELP_INLINE_FACET, (UIComponent)hil);
            comp = hil;
        }
        try {
            hil = (HelpInline)((Object)comp);
            if (this.getHelpText() == null) {
                hil.setText(theme.getMessage(SECTION_HELP));
            } else {
                hil.setText(this.getHelpText());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return comp;
    }

    private int getSingleGroupTaskCount(CommonTasksGroup group) {
        int count = 0;
        boolean flag = false;
        for (UIComponent this.component : group.getChildren()) {
            if (this.component.isRendered()) {
                ++count;
                flag = true;
            }
            if (!(this.component instanceof CommonTask) || !((CommonTask)this.component).isVisible()) continue;
            flag = true;
        }
        if (!Beans.isDesignTime() && !flag) {
            group.setRendered(false);
        }
        return count;
    }
}

