/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.Base64PemCharArray;
import com.sun.messaging.jmq.util.CEStreamExhausted;
import com.sun.messaging.jmq.util.CharacterDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BASE64Decoder
extends CharacterDecoder {
    private static final byte[] pem_convert_array;
    byte[] decode_buffer = new byte[4];

    @Override
    protected int bytesPerAtom() {
        return 4;
    }

    @Override
    protected int bytesPerLine() {
        return 72;
    }

    @Override
    protected void decodeAtom(InputStream inStream, OutputStream outStream, int rem) throws IOException {
        int i;
        int a = -1;
        int b = -1;
        int c = -1;
        int d = -1;
        if (rem < 2) {
            throw new IOException();
        }
        do {
            if ((i = inStream.read()) != -1) continue;
            throw new CEStreamExhausted();
        } while (i == 10 || i == 13);
        this.decode_buffer[0] = (byte)i;
        i = this.readFully(inStream, this.decode_buffer, 1, rem - 1);
        if (i == -1) {
            throw new CEStreamExhausted();
        }
        if (rem > 3 && this.decode_buffer[3] == 61) {
            rem = 3;
        }
        if (rem > 2 && this.decode_buffer[2] == 61) {
            rem = 2;
        }
        switch (rem) {
            case 4: {
                d = pem_convert_array[this.decode_buffer[3] & 0xFF];
            }
            case 3: {
                c = pem_convert_array[this.decode_buffer[2] & 0xFF];
            }
            case 2: {
                b = pem_convert_array[this.decode_buffer[1] & 0xFF];
                a = pem_convert_array[this.decode_buffer[0] & 0xFF];
            }
        }
        switch (rem) {
            case 2: {
                outStream.write((byte)(a << 2 & 0xFC | b >>> 4 & 3));
                break;
            }
            case 3: {
                outStream.write((byte)(a << 2 & 0xFC | b >>> 4 & 3));
                outStream.write((byte)(b << 4 & 0xF0 | c >>> 2 & 0xF));
                break;
            }
            case 4: {
                outStream.write((byte)(a << 2 & 0xFC | b >>> 4 & 3));
                outStream.write((byte)(b << 4 & 0xF0 | c >>> 2 & 0xF));
                outStream.write((byte)(c << 6 & 0xC0 | d & 0x3F));
            }
        }
    }

    static {
        int i;
        pem_convert_array = new byte[256];
        char[] pem_array = Base64PemCharArray.getPemArray();
        for (i = 0; i < 255; ++i) {
            BASE64Decoder.pem_convert_array[i] = -1;
        }
        for (i = 0; i < pem_array.length; ++i) {
            BASE64Decoder.pem_convert_array[pem_array[i]] = (byte)i;
        }
    }
}

