/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import jakarta.faces.model.SelectItem;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class CollectionsUtils {
    private CollectionsUtils() {
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... a) {
        return new HashSet<T>(Arrays.asList(a));
    }

    @SafeVarargs
    public static <T> T[] ar(T ... ts) {
        return ts;
    }

    public static <T> T[] ar() {
        return null;
    }

    public static <T, V> ConstMap<T, V> map() {
        return new ConstMap();
    }

    public static <T> Iterator<T> asIterator(T[] items) {
        return CollectionsUtils.unmodifiableIterator(Stream.of(items).iterator());
    }

    public static <T extends SelectItem> Iterator<T> asIterator(T[] items) {
        return CollectionsUtils.unmodifiableIterator(Stream.of(items).iterator());
    }

    public static <T> Iterator<T> unmodifiableIterator(Enumeration<T> enumeration) {
        return CollectionsUtils.unmodifiableIterator(enumeration.asIterator());
    }

    public static <T> Iterator<T> unmodifiableIterator(Iterator<T> iterator) {
        return new UnmodifiableIterator<T>(iterator);
    }

    public static class ConstMap<T, V>
    extends HashMap<T, V> {
        private static final long serialVersionUID = 7233295794116070299L;

        public ConstMap() {
            super(50, 1.0f);
        }

        public ConstMap<T, V> add(T key, V value) {
            this.put(key, value);
            return this;
        }

        public Map<T, V> fix() {
            return Collections.unmodifiableMap(this);
        }
    }

    public static class UnmodifiableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> iterator;

        public UnmodifiableIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

