/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.eclipse.persistence.descriptors.AbstractTsLockingPolicy;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class LocalDateTimeLockingPolicy
extends AbstractTsLockingPolicy<LocalDateTime> {
    public LocalDateTimeLockingPolicy() {
    }

    public LocalDateTimeLockingPolicy(String fieldName) {
        super(fieldName);
    }

    LocalDateTimeLockingPolicy(DatabaseField field) {
        super(field);
    }

    @Override
    int compareTsLockValues(LocalDateTime value1, LocalDateTime value2) {
        return value1.compareTo(value2);
    }

    @Override
    Class<LocalDateTime> getDefaultTsLockFieldType() {
        return ClassConstants.LOCAL_DATETIME;
    }

    @Override
    LocalDateTime getBaseTsValue() {
        return LocalDateTime.MIN;
    }

    @Override
    LocalDateTime getInitialTsWriteValue(AbstractSession session) {
        if (this.usesLocalTime()) {
            return LocalDateTime.now();
        }
        if (this.usesServerTime()) {
            AbstractSession readSession = session.getSessionForClass(this.getDescriptor().getJavaClass());
            while (readSession.isUnitOfWork()) {
                readSession = readSession.getParent().getSessionForClass(this.getDescriptor().getJavaClass());
            }
            Timestamp ts = readSession.getDatasourceLogin().getDatasourcePlatform().getTimestampFromServer(session, readSession.getName());
            return ts.toLocalDateTime();
        }
        return null;
    }

    @Override
    LocalDateTime getNewTsLockValue(ModifyQuery query) {
        return this.getInitialTsWriteValue(query.getSession());
    }

    @Override
    LocalDateTime getTsValueToPutInCache(AbstractRecord row, AbstractSession session) {
        if (this.isStoredInCache()) {
            return (LocalDateTime)session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), ClassConstants.LOCAL_DATETIME);
        }
        return null;
    }

    @Override
    LocalDateTime getWriteTsLockValue(Object domainObject, Object primaryKey, AbstractSession session) {
        LocalDateTime writeLockFieldValue = null;
        if (this.isStoredInCache()) {
            writeLockFieldValue = (LocalDateTime)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor());
        } else {
            Object lockValue = this.lockValueFromObject(domainObject);
            if (lockValue != null) {
                if (lockValue instanceof LocalDateTime) {
                    writeLockFieldValue = (LocalDateTime)this.lockValueFromObject(domainObject);
                } else {
                    throw OptimisticLockException.needToMapJavaSqlTimestampWhenStoredInObject();
                }
            }
        }
        return writeLockFieldValue;
    }

    @Override
    boolean isNewerTsVersion(LocalDateTime current, Object domainObject, Object primaryKey, AbstractSession session) {
        LocalDateTime writeLockFieldValue = this.isStoredInCache() ? (LocalDateTime)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (LocalDateTime)this.lockValueFromObject(domainObject);
        return this.isNewerTsVersion(current, writeLockFieldValue);
    }

    @Override
    boolean isNewerTsVersion(AbstractRecord row, Object domainObject, Object primaryKey, AbstractSession session) {
        LocalDateTime newWriteLockFieldValue = (LocalDateTime)session.getDatasourcePlatform().convertObject(row.get(this.getWriteLockField()), ClassConstants.LOCAL_DATETIME);
        LocalDateTime writeLockFieldValue = this.isStoredInCache() ? (LocalDateTime)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKey, domainObject.getClass(), this.getDescriptor()) : (LocalDateTime)this.lockValueFromObject(domainObject);
        return this.isNewerTsVersion(newWriteLockFieldValue, writeLockFieldValue);
    }

    @Override
    boolean isNewerTsVersion(LocalDateTime first, LocalDateTime second) {
        if (first == null) {
            return false;
        }
        if (second == null) {
            return true;
        }
        return first.isAfter(second);
    }

    @Override
    public int getVersionDifference(Object currentValue, Object domainObject, Object primaryKeys, AbstractSession session) {
        LocalDateTime newWriteLockFieldValue = (LocalDateTime)currentValue;
        if (newWriteLockFieldValue == null) {
            return 0;
        }
        LocalDateTime writeLockFieldValue = this.isStoredInCache() ? (LocalDateTime)session.getIdentityMapAccessorInstance().getWriteLockValue(primaryKeys, domainObject.getClass(), this.getDescriptor()) : (LocalDateTime)this.lockValueFromObject(domainObject);
        if (newWriteLockFieldValue.equals(writeLockFieldValue)) {
            return 0;
        }
        if (writeLockFieldValue != null && !newWriteLockFieldValue.isAfter(writeLockFieldValue)) {
            return -1;
        }
        return 1;
    }
}

