/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.web.admin.LogFacade;

@AMXMetadata(type="servlet-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container Servlet Statistics")
public class ServletStatsProvider {
    private static final Logger logger = LogFacade.getLogger();
    private static final String ACTIVE_SERVLETS_LOADED_DESCRIPTION = "Number of Servlets loaded";
    private static final String TOTAL_SERVLETS_LOADED_DESCRIPTION = "Total number of Servlets ever loaded";
    private static final String SERVLET_PROCESSING_TIMES_DESCRIPTION = "Cumulative Servlet processing times";
    private String moduleName;
    private String vsName;
    private RangeStatisticImpl activeServletsLoadedCount;
    private CountStatisticImpl totalServletsLoadedCount;
    private CountStatisticImpl servletProcessingTimes;

    public ServletStatsProvider(String moduleName, String vsName) {
        this.moduleName = moduleName;
        this.vsName = vsName;
        long curTime = System.currentTimeMillis();
        this.activeServletsLoadedCount = new RangeStatisticImpl(0L, 0L, 0L, "ActiveServletsLoaded", "count", ACTIVE_SERVLETS_LOADED_DESCRIPTION, curTime, curTime);
        this.totalServletsLoadedCount = new CountStatisticImpl("TotalServletsLoaded", "count", TOTAL_SERVLETS_LOADED_DESCRIPTION);
        this.servletProcessingTimes = new CountStatisticImpl("ServletProcessingTimes", "millisecond", SERVLET_PROCESSING_TIMES_DESCRIPTION);
    }

    @ManagedAttribute(id="activeservletsloadedcount")
    @Description(value="Number of Servlets loaded")
    public RangeStatistic getActiveServletsLoaded() {
        return this.activeServletsLoadedCount;
    }

    @ManagedAttribute(id="totalservletsloadedcount")
    @Description(value="Total number of Servlets ever loaded")
    public CountStatistic getTotalServletsLoaded() {
        return this.totalServletsLoadedCount;
    }

    @ManagedAttribute(id="servletprocessingtimes")
    @Description(value="Cumulative Servlet processing times")
    public CountStatistic getServletProcessingTimes() {
        return this.servletProcessingTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:web:servlet:servletInitializedEvent")
    public void servletInitializedEvent(@ProbeParam(value="servletName") String servletName, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Servlet Loaded event received - servletName = " + servletName + ": appName = " + appName + ": hostName = " + hostName);
        }
        if (this.isValidEvent(appName, hostName)) {
            RangeStatisticImpl rangeStatisticImpl = this.activeServletsLoadedCount;
            synchronized (rangeStatisticImpl) {
                this.activeServletsLoadedCount.setCurrent(this.activeServletsLoadedCount.getCurrent() + 1L);
            }
            this.totalServletsLoadedCount.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:web:servlet:servletDestroyedEvent")
    public void servletDestroyedEvent(@ProbeParam(value="servletName") String servletName, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Servlet Destroyed event received - servletName = " + servletName + ": appName = " + appName + ": hostName = " + hostName);
        }
        if (this.isValidEvent(appName, hostName)) {
            RangeStatisticImpl rangeStatisticImpl = this.activeServletsLoadedCount;
            synchronized (rangeStatisticImpl) {
                this.activeServletsLoadedCount.setCurrent(this.activeServletsLoadedCount.getCurrent() - 1L);
            }
        }
    }

    private boolean isValidEvent(String mName, String hostName) {
        if (this.moduleName == null || this.vsName == null) {
            return true;
        }
        return this.moduleName.equals(mName) && this.vsName.equals(hostName);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    void addServletProcessingTime(long servletProcessingTime) {
        this.servletProcessingTimes.increment(servletProcessingTime);
    }
}

