/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;

public abstract class AbstractLiteralExpressionFactory
extends ExpressionFactory {
    protected AbstractLiteralExpressionFactory(String id) {
        super(id, new String[0]);
    }

    protected abstract AbstractExpression buildExpression(AbstractExpression var1, WordParser var2, String var3, AbstractExpression var4, boolean var5);

    @Override
    protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        AbstractExpression identifierExpression;
        switch (wordParser.getWordType()) {
            case NUMERIC_LITERAL: {
                NumericLiteral numericLiteral = new NumericLiteral(parent, word);
                numericLiteral.parse(wordParser, tolerant);
                return numericLiteral;
            }
            case STRING_LITERAL: {
                StringLiteral stringLiteral = new StringLiteral(parent, word);
                stringLiteral.parse(wordParser, tolerant);
                return stringLiteral;
            }
            case INPUT_PARAMETER: {
                InputParameter inputParameter = new InputParameter(parent, word);
                inputParameter.parse(wordParser, tolerant);
                return inputParameter;
            }
        }
        if (word.indexOf(46) > -1) {
            char character = word.charAt(0);
            AbstractPathExpression pathExpression = expression != null && character == '.' ? (this.isCollection() ? new CollectionValuedPathExpression(parent, expression, word) : new StateFieldPathExpression(parent, expression, word)) : (this.isCollection() ? new CollectionValuedPathExpression(parent, word) : new StateFieldPathExpression(parent, word));
            pathExpression.parse(wordParser, tolerant);
            return pathExpression;
        }
        if (tolerant && this.getExpressionRegistry().isIdentifier(word) && (identifierExpression = this.getIdentifierExpression(parent, wordParser, word, queryBNF, expression, tolerant)) != null) {
            return new BadExpression(parent, identifierExpression);
        }
        return this.buildExpression(parent, wordParser, word, expression, tolerant);
    }

    protected boolean isCollection() {
        return false;
    }

    private AbstractExpression getIdentifierExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        ExpressionFactory factory = this.getExpressionRegistry().expressionFactoryForIdentifier(word);
        if (factory != null) {
            AbstractExpression identifierExpression = factory.buildExpression(parent, wordParser, word, queryBNF, expression, tolerant);
            return AbstractExpression.revertExpressionIfInvalid(identifierExpression, wordParser, word);
        }
        return null;
    }
}

