/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminHelper;
import com.sun.enterprise.config.serverbeans.SecureAdminPrincipal;
import com.sun.enterprise.security.admin.cli.SecureAdminCommand;
import com.sun.enterprise.security.admin.cli.Strings;
import com.sun.enterprise.security.ssl.SSLUtils;
import jakarta.inject.Inject;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="enable-secure-admin")
@PerLookup
@I18n(value="enable.secure.admin.command")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="enable-secure-admin", description="enable-secure-admin")})
@AccessRequired(resource={"domain/secure-admin"}, action={"enable"})
public class EnableSecureAdminCommand
extends SecureAdminCommand {
    @Param(optional=true, defaultValue="s1as")
    public String adminalias;
    @Param(optional=true, defaultValue="glassfish-instance")
    public String instancealias;
    @Inject
    private SSLUtils sslUtils;
    @Inject
    private SecureAdminHelper secureAdminHelper;
    private KeyStore keystore = null;

    @Override
    public void run() throws TransactionFailure, SecureAdminHelper.SecureAdminCommandException {
        try {
            this.ensureNoAdminUsersWithEmptyPassword();
        }
        catch (SecureAdminHelper.SecureAdminCommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransactionFailure(ex.getMessage() != null ? ex.getMessage() : "");
        }
        super.run();
    }

    private void ensureNoAdminUsersWithEmptyPassword() throws SecureAdminHelper.SecureAdminCommandException {
        boolean isAdminUserWithoutPassword;
        try {
            isAdminUserWithoutPassword = this.secureAdminHelper.isAnyAdminUserWithoutPassword();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (isAdminUserWithoutPassword) {
            throw new SecureAdminHelper.SecureAdminCommandException(Strings.get("adminsWithEmptyPW"));
        }
    }

    @Override
    Iterator<SecureAdminCommand.Work<SecureAdminCommand.TopLevelContext>> secureAdminSteps() {
        return this.stepsIterator(this.secureAdminSteps);
    }

    @Override
    Iterator<SecureAdminCommand.Work<SecureAdminCommand.ConfigLevelContext>> perConfigSteps() {
        return this.stepsIterator(this.perConfigSteps);
    }

    private <T extends SecureAdminCommand.Context> Iterator<SecureAdminCommand.Work<T>> stepsIterator(SecureAdminCommand.Step<T>[] steps) {
        return new Iterator<SecureAdminCommand.Work<T>>(this){
            private SecureAdminCommand.Step<T>[] steps;
            private int nextSlot;

            @Override
            public boolean hasNext() {
                return this.nextSlot < this.steps.length;
            }

            @Override
            public SecureAdminCommand.Work<T> next() {
                return this.steps[this.nextSlot++].enableWork();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            Iterator<SecureAdminCommand.Work<T>> init(SecureAdminCommand.Step<T>[] values) {
                this.steps = values;
                this.nextSlot = 0;
                return this;
            }
        }.init(steps);
    }

    @Override
    protected boolean updateSecureAdminSettings(SecureAdmin secureAdmin_w) {
        try {
            ArrayList<String> badAliases = new ArrayList<String>();
            secureAdmin_w.setDasAlias(this.processAlias(this.adminalias, "s1as", secureAdmin_w, badAliases));
            secureAdmin_w.setInstanceAlias(this.processAlias(this.instancealias, "glassfish-instance", secureAdmin_w, badAliases));
            this.ensureSpecialAdminIndicatorIsUnique(secureAdmin_w);
            if (badAliases.size() > 0) {
                throw new SecureAdminHelper.SecureAdminCommandException(Strings.get("enable.secure.admin.badAlias", badAliases.size(), ((Object)badAliases).toString()));
            }
            this.ensureSpecialAdminIndicatorIsUnique(secureAdmin_w);
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String processAlias(String alias, String defaultAlias, SecureAdmin secureAdmin_w, Collection<String> badAliases) throws IOException, KeyStoreException {
        boolean isAliasOK;
        if (alias.equals(defaultAlias)) {
            isAliasOK = true;
        } else {
            isAliasOK = this.validateAlias(alias);
            if (!isAliasOK) {
                badAliases.add(alias);
            }
        }
        if (isAliasOK) {
            this.ensureSecureAdminPrincipalForAlias(alias, secureAdmin_w);
        }
        return alias;
    }

    @Override
    protected String transactionErrorMessageKey() {
        return "NCLS-SECURITY-05200";
    }

    private void ensureSpecialAdminIndicatorIsUnique(SecureAdmin secureAdmin_w) {
        if (secureAdmin_w.getSpecialAdminIndicator().equals("true")) {
            UUID uuid = UUID.randomUUID();
            secureAdmin_w.setSpecialAdminIndicator(uuid.toString());
        }
    }

    private void ensureSecureAdminPrincipalForAlias(String alias, SecureAdmin secureAdmin_w) {
        SecureAdminPrincipal p = this.getSecureAdminPrincipalForAlias(alias, secureAdmin_w);
        if (p != null) {
            return;
        }
        try {
            String dn = this.secureAdminHelper.getDN(alias, true);
            p = (SecureAdminPrincipal)secureAdmin_w.createChild(SecureAdminPrincipal.class);
            p.setDn(dn);
            secureAdmin_w.getSecureAdminPrincipal().add(p);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private SecureAdminPrincipal getSecureAdminPrincipalForAlias(String alias, SecureAdmin secureAdmin_w) {
        try {
            String dnForAlias = this.secureAdminHelper.getDN(alias, true);
            for (SecureAdminPrincipal p : secureAdmin_w.getSecureAdminPrincipal()) {
                if (!p.getDn().equals(dnForAlias)) continue;
                return p;
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private synchronized KeyStore keyStore() throws IOException {
        if (this.keystore == null) {
            this.keystore = this.sslUtils.getKeyStore();
        }
        return this.keystore;
    }

    private boolean validateAlias(String alias) throws IOException, KeyStoreException {
        return this.keyStore().containsAlias(alias);
    }
}

