/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria;

import jakarta.el.ELProcessor;
import jakarta.interceptor.InvocationContext;
import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.xml.bind.DatatypeConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.glassfish.soteria.WrappingCallerPrincipal;

public final class Utils {
    public static final Method validateRequestMethod = Utils.getMethod(HttpAuthenticationMechanism.class, "validateRequest", HttpServletRequest.class, HttpServletResponse.class, HttpMessageContext.class);
    public static final Method cleanSubjectMethod = Utils.getMethod(HttpAuthenticationMechanism.class, "cleanSubject", HttpServletRequest.class, HttpServletResponse.class, HttpMessageContext.class);
    private static final String ERROR_UNSUPPORTED_ENCODING = "UTF-8 is apparently not supported on this platform.";
    private static final Set<String> FACES_AJAX_HEADERS = Utils.unmodifiableSet("partial/ajax", "partial/process");
    private static final String FACES_AJAX_REDIRECT_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><partial-response><redirect url=\"%s\"></redirect></partial-response>";

    private Utils() {
    }

    public static boolean notNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    @SafeVarargs
    public static <T> boolean isOneOf(T object, T ... objects) {
        for (T other : objects) {
            if (!(object == null ? other == null : object.equals(other))) continue;
            return true;
        }
        return false;
    }

    public static <T> T getParam(InvocationContext invocationContext, int param) {
        return (T)invocationContext.getParameters()[param];
    }

    public static String getBaseURL(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        return url.substring(0, url.length() - request.getRequestURI().length()) + request.getContextPath();
    }

    public static void redirect(HttpServletResponse response, String location) {
        try {
            response.sendRedirect(location);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ELProcessor getELProcessor(String name, Object bean) {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.defineBean(name, bean);
        return elProcessor;
    }

    public static ELProcessor getELProcessor(String name1, Object bean1, String name2, Object bean2) {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.defineBean(name1, bean1);
        elProcessor.defineBean(name2, bean2);
        return elProcessor;
    }

    public static ELProcessor getELProcessor(String name1, Object bean1, String name2, Object bean2, String name3, Object bean3) {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.defineBean(name1, bean1);
        elProcessor.defineBean(name2, bean2);
        elProcessor.defineBean(name3, bean3);
        return elProcessor;
    }

    public static CallerPrincipal toCallerPrincipal(Principal principal) {
        if (principal instanceof CallerPrincipal) {
            return (CallerPrincipal)principal;
        }
        return new WrappingCallerPrincipal(principal);
    }

    public static void redirect(HttpServletRequest request, HttpServletResponse response, String location) {
        try {
            if (Utils.isFacesAjaxRequest(request)) {
                response.setHeader("Cache-Control", "no-cache,no-store,must-revalidate");
                response.setDateHeader("Expires", 0L);
                response.setHeader("Pragma", "no-cache");
                response.setContentType("text/xml");
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                response.getWriter().printf(FACES_AJAX_REDIRECT_XML, location);
            } else {
                response.sendRedirect(location);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isFacesAjaxRequest(HttpServletRequest request) {
        return FACES_AJAX_HEADERS.contains(request.getHeader("Faces-Request"));
    }

    public static <E> Set<E> unmodifiableSet(Object ... values) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object value : values) {
            if (value instanceof Object[]) {
                for (Object item : (Object[])value) {
                    set.add(item);
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object item : (Collection)value) {
                    set.add(item);
                }
                continue;
            }
            set.add(value);
        }
        return Collections.unmodifiableSet(set);
    }

    public static String encodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ENCODING, e);
        }
    }

    public static String decodeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(ERROR_UNSUPPORTED_ENCODING, e);
        }
    }

    public static String getSingleParameterFromState(String state, String paramName) {
        Map<String, List<String>> requestStateParameters = Utils.getParameterMapFromState(state);
        List<String> parameterValues = requestStateParameters.get(paramName);
        if (!Utils.isEmpty(parameterValues)) {
            return parameterValues.get(0);
        }
        return null;
    }

    public static Map<String, List<String>> getParameterMapFromState(String state) {
        return Utils.toParameterMap(Utils.unserializeURLSafe(state));
    }

    public static Map<String, List<String>> toParameterMap(String queryString) {
        String[] parameters = queryString.split(Pattern.quote("&"));
        LinkedHashMap<String, List<String>> parameterMap = new LinkedHashMap<String, List<String>>(parameters.length);
        for (String parameter : parameters) {
            if (!parameter.contains("=")) continue;
            String[] pair = parameter.split(Pattern.quote("="));
            String key = Utils.decodeURL(pair[0]);
            String value = pair.length > 1 && !Utils.isEmpty(pair[1]) ? Utils.decodeURL(pair[1]) : "";
            List values = parameterMap.computeIfAbsent(key, k -> new ArrayList(1));
            values.add(value);
        }
        return parameterMap;
    }

    public static String toQueryString(Map<String, List<String>> parameterMap) {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : parameterMap.entrySet()) {
            String name = Utils.encodeURL(entry.getKey());
            for (String value : entry.getValue()) {
                if (queryString.length() > 0) {
                    queryString.append("&");
                }
                queryString.append(name).append("=").append(Utils.encodeURL(value));
            }
        }
        return queryString.toString();
    }

    public static String getSingleParameterFromQueryString(String queryString, String paramName) {
        Map<String, List<String>> requestParameters;
        if (!Utils.isEmpty(queryString) && !Utils.isEmpty((Collection)(requestParameters = Utils.toParameterMap(queryString)).get(paramName))) {
            return requestParameters.get(paramName).get(0);
        }
        return null;
    }

    public static String serializeURLSafe(String string) {
        if (string == null) {
            return null;
        }
        try {
            ByteArrayInputStream raw = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
            ByteArrayOutputStream deflated = new ByteArrayOutputStream();
            Utils.stream(raw, new DeflaterOutputStream((OutputStream)deflated, new Deflater(9)));
            String base64 = DatatypeConverter.printBase64Binary((byte[])deflated.toByteArray());
            return base64.replace('+', '-').replace('/', '_').replace("=", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String unserializeURLSafe(String string) {
        if (string == null) {
            return null;
        }
        try {
            String base64 = string.replace('-', '+').replace('_', '/') + "===".substring(0, string.length() % 4);
            ByteArrayInputStream deflated = new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)base64));
            return new String(Utils.toByteArray(new InflaterInputStream(deflated)), StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static long stream(InputStream input, OutputStream output) throws IOException {
        try (ReadableByteChannel inputChannel = Channels.newChannel(input);){
            long l;
            block13: {
                WritableByteChannel outputChannel = Channels.newChannel(output);
                try {
                    ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
                    long size = 0L;
                    while (inputChannel.read(buffer) != -1) {
                        buffer.flip();
                        size += (long)outputChannel.write(buffer);
                        buffer.clear();
                    }
                    l = size;
                    if (outputChannel == null) break block13;
                }
                catch (Throwable throwable) {
                    if (outputChannel != null) {
                        try {
                            outputChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                outputChannel.close();
            }
            return l;
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Utils.stream(input, output);
        return output.toByteArray();
    }

    public static boolean isImplementationOf(Method implementationMethod, Method interfaceMethod) {
        return interfaceMethod.getDeclaringClass().isAssignableFrom(implementationMethod.getDeclaringClass()) && interfaceMethod.getName().equals(implementationMethod.getName()) && Arrays.equals(interfaceMethod.getParameterTypes(), implementationMethod.getParameterTypes());
    }

    public static Method getMethod(Class<?> base, String name, Class<?> ... parameterTypes) {
        try {
            return base.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    @SafeVarargs
    public static Annotation[] createAnnotationInstances(Class<?> ... types) {
        Annotation[] instances = (Annotation[])Array.newInstance(Annotation.class, types.length);
        for (int i = 0; i < types.length; ++i) {
            instances[i] = Utils.createAnnotationInstance(types[i]);
        }
        return instances;
    }

    public static Annotation createAnnotationInstance(Class<?> type) {
        return (Annotation)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new AnnotationInvocationHandler(type));
    }

    static class AnnotationInvocationHandler
    implements InvocationHandler,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<?> type;

        AnnotationInvocationHandler(Class<?> type) {
            this.type = type;
        }

        public boolean equals(Object other) {
            return this.type.isInstance(other);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return "@" + this.type.getName();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "annotationType": {
                    return this.type;
                }
                case "equals": {
                    return args.length > 0 && this.equals(args[0]);
                }
                case "hashCode": {
                    return this.hashCode();
                }
                case "toString": {
                    return this.toString();
                }
            }
            return null;
        }
    }
}

