/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.convert.impl;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.krazo.binding.convert.ConverterResult;
import org.eclipse.krazo.binding.convert.impl.NumberConverter;

public class FloatConverter
extends NumberConverter<Float> {
    @Override
    public boolean supports(Class<Float> rawType, Annotation[] annotations) {
        return Float.class.equals(rawType) || Float.TYPE.equals(rawType);
    }

    @Override
    public ConverterResult<Float> convert(String value, Class<Float> rawType, Annotation[] annotations, Locale locale) {
        Float defaultValue = Float.TYPE.equals(rawType) ? Float.valueOf(0.0f) : null;
        try {
            return ConverterResult.success(this.parseNumber(value, locale).map(Number::floatValue).orElse(defaultValue));
        }
        catch (ParseException e) {
            return ConverterResult.failed(defaultValue, e.getMessage());
        }
    }
}

