/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.bean;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.component.Markup;
import com.sun.webui.jsf.component.PanelGroup;
import com.sun.webui.jsf.component.StaticText;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.component.Tree;
import com.sun.webui.jsf.component.TreeNode;
import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.HelpUtils;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.help.SearchTOCItem;
import javax.help.TreeItem;
import javax.swing.tree.DefaultMutableTreeNode;

public final class HelpBackingBean {
    public static final String HELP_CONTENTS_TREE_ID = "helpContentsTree";
    public static final String HELP_INDEX_TREE_ID = "helpIndexTree";
    public static final String CONTENT_FRAME_NAME = "contentFrame";
    private Theme theme = null;
    private Tree contentsTree = null;
    private Tree indexTree = null;
    private PanelGroup searchPanel = null;
    private PanelGroup searchResultsPanel = null;
    private TextField searchField = null;
    private Button searchButton = null;
    private HelpUtils helpUtils = null;
    private Hyperlink tipsLink = null;
    private String helpSetPath = "";
    private String jspPath = null;
    private String localizedHelpPath = null;
    private int httpPort = -1;
    private String requestScheme = null;
    private String navigatorUrl = null;
    private String bottomFrameUrl = null;
    private String buttonFrameUrl = null;
    private String buttonClassName = null;
    private String inlineHelpClassName = null;
    private String searchClassName = null;
    private String stepTabClassName = null;
    private String titleClassName = null;
    private String bodyClassName = null;
    private String tipsHeadTitle = null;
    private String tipsTitle = null;
    private String tipsImprove = null;
    private String tipsImprove1 = null;
    private String tipsImprove2 = null;
    private String tipsImprove3 = null;
    private String tipsImprove4 = null;
    private String tipsNote = null;
    private String tipsNoteDetails = null;
    private String tipsSearch = null;
    private String tipsSearch1 = null;
    private String tipsSearch2 = null;
    private String tipsSearch3 = null;
    private String tipsSearch4 = null;
    private String backButtonText = null;
    private String forwardButtonText = null;
    private String printButtonText = null;
    private String contentsText = null;
    private String indexText = null;
    private String searchText = null;
    private String closeLabel = null;
    private String searchLabel = null;
    private String navFrameTitle = null;
    private String buttonFrameTitle = null;
    private String contentFrameTitle = null;
    private String noFrames = null;
    private String buttonNavHeadTitle = null;
    private String navigatorHeadTitle = null;
    private String buttonBodyClassName = null;

    public String getNavigatorUrl() {
        if (this.navigatorUrl != null) {
            return this.navigatorUrl;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        StringBuilder urlBuffer = new StringBuilder();
        String zeJspPath = this.getJspPath();
        if (zeJspPath != null) {
            urlBuffer.append("/").append(zeJspPath);
        }
        urlBuffer.append("/com_sun_webui_jsf/help/").append("navigator.jsp");
        this.navigatorUrl = context.getApplication().getViewHandler().getActionURL(context, urlBuffer.toString());
        return this.navigatorUrl;
    }

    public void setNavigatorUrl(String url) {
        this.navigatorUrl = url;
    }

    public String getBottomFrameUrl() {
        if (this.bottomFrameUrl != null) {
            return this.bottomFrameUrl;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        StringBuilder urlBuffer = new StringBuilder();
        String zeJspPath = this.getJspPath();
        if (zeJspPath != null) {
            urlBuffer.append("/").append(zeJspPath);
        }
        urlBuffer.append("/com_sun_webui_jsf/help/").append("buttonFrame.jsp");
        this.bottomFrameUrl = context.getApplication().getViewHandler().getActionURL(context, urlBuffer.toString());
        return this.bottomFrameUrl;
    }

    public void setBottomFrameUrl(String url) {
        this.bottomFrameUrl = url;
    }

    public String getButtonFrameUrl() {
        if (this.buttonFrameUrl != null) {
            return this.buttonFrameUrl;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        StringBuilder urlBuffer = new StringBuilder();
        String zeJspPath = this.getJspPath();
        if (zeJspPath != null) {
            urlBuffer.append("/").append(zeJspPath);
        }
        urlBuffer.append("/com_sun_webui_jsf/help/").append("buttonnav.jsp");
        this.buttonFrameUrl = context.getApplication().getViewHandler().getActionURL(context, urlBuffer.toString());
        return this.buttonFrameUrl;
    }

    public void setButtonFrameUrl(String url) {
        this.buttonFrameUrl = url;
    }

    public String getRequestScheme() {
        return this.requestScheme;
    }

    public void setRequestScheme(String scheme) {
        this.requestScheme = scheme;
    }

    public String getHelpSetPath() {
        FacesContext fc = FacesContext.getCurrentInstance();
        ExternalContext ec = fc.getExternalContext();
        String realPath = ec.getRequestContextPath();
        if (this.helpSetPath != null && this.helpSetPath.length() > 0) {
            realPath = realPath.concat("/").concat(this.helpSetPath).concat("/");
        }
        return realPath;
    }

    public void setHelpSetPath(String path) {
        this.helpSetPath = path;
    }

    public String getJspPath() {
        return this.jspPath;
    }

    public void setJspPath(String path) {
        this.jspPath = path;
    }

    private HelpUtils getHelpUtils() {
        if (this.helpUtils == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
            String requestHelpSetPath = request.getParameter("helpSetPath");
            if (requestHelpSetPath != null) {
                this.setHelpSetPath(requestHelpSetPath);
            }
            this.helpUtils = new HelpUtils(request, this.getHelpSetPath(), this.httpPort, this.getRequestScheme());
        }
        return this.helpUtils;
    }

    protected void initTree(Tree tree, ArrayList treeList) {
        HashMap<String, TreeNode> uiNodeMap = new HashMap<String, TreeNode>();
        int numUiNodes = -1;
        HashMap<String, String> nodeIDMap = new HashMap<String, String>();
        boolean tocTree = tree.getId().equals(HELP_CONTENTS_TREE_ID);
        int nTreeNodes = treeList.size();
        for (int i = 0; i < nTreeNodes; ++i) {
            TreeItem item;
            DefaultMutableTreeNode javaNode = (DefaultMutableTreeNode)treeList.get(i);
            if (javaNode == null || (item = (TreeItem)javaNode.getUserObject()) == null) continue;
            String jsfId = "node" + Integer.toString(++numUiNodes);
            String javaNodeId = this.getHelpUtils().getID(javaNode);
            nodeIDMap.put(javaNodeId, jsfId);
            javax.swing.tree.TreeNode parentJavaNode = javaNode.getParent();
            String parentJavaNodeId = this.getHelpUtils().getID(parentJavaNode);
            String label = item.getName();
            TreeNode uiNode = new TreeNode();
            uiNode.setTarget(CONTENT_FRAME_NAME);
            uiNode.setId(jsfId);
            uiNode.setText(label);
            String url = this.getHelpUtils().getContentURL(item);
            if (this.getHttpPort() != -1) {
                int portStartIndex = url.indexOf(58, url.indexOf(58) + 1) + 1;
                int portEndIndex = url.indexOf(47, portStartIndex);
                String port = url.substring(portStartIndex, portEndIndex);
                url = url.replaceFirst(port, String.valueOf(this.getHttpPort()));
            }
            uiNode.setUrl(url);
            TreeNode uiParent = (TreeNode)uiNodeMap.get(nodeIDMap.get(parentJavaNodeId));
            if (uiParent != null) {
                uiParent.getChildren().add(uiNode);
                uiParent.setExpanded(true);
            } else {
                tree.getChildren().add(uiNode);
            }
            uiNodeMap.put(uiNode.getId(), uiNode);
        }
    }

    private void initSearchResultsPanel() {
        this.searchResultsPanel = new PanelGroup();
        this.searchResultsPanel.setId("searchResultsPanel");
    }

    private Theme getTheme() {
        if (this.theme == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.theme = ThemeUtilities.getTheme(context);
        }
        return this.theme;
    }

    private void initSearchPanel() {
        this.searchPanel = new PanelGroup();
        this.searchPanel.setId("searchPanel");
        this.searchPanel.setRendered(false);
    }

    public void contentsTabClicked() {
        this.getContentsTree().setRendered(true);
        this.getIndexTree().setRendered(false);
        this.getSearchPanel().setRendered(false);
    }

    public void indexTabClicked() {
        this.getContentsTree().setRendered(false);
        this.getIndexTree().setRendered(true);
        this.getSearchPanel().setRendered(false);
    }

    public void searchTabClicked() {
        this.getContentsTree().setRendered(false);
        this.getIndexTree().setRendered(false);
        this.getSearchPanel().setRendered(true);
    }

    public void doSearch() {
        Markup mu = (Markup)((Object)this.searchPanel.getChildren().get(0));
        TextField f = (TextField)mu.getChildren().get(0);
        String zeSearchText = ConversionUtilities.convertValueToString((UIComponent)f, f.getValue());
        List resultsKids = this.getSearchResultsPanel().getChildren();
        resultsKids.clear();
        Theme zeTheme = this.getTheme();
        Enumeration searchResults = this.getHelpUtils().doSearch(zeSearchText);
        if (searchResults == null || !searchResults.hasMoreElements()) {
            StaticText text = new StaticText();
            text.setId("noResults");
            text.setStyleClass(zeTheme.getStyleClass("HELP_RESULT_DIV"));
            text.setText(zeTheme.getMessage("help.noResultsFound"));
            resultsKids.add(text);
            return;
        }
        int linkId = 0;
        while (searchResults.hasMoreElements()) {
            SearchTOCItem item = (SearchTOCItem)searchResults.nextElement();
            Markup div = new Markup();
            div.setId("div" + linkId);
            div.setTag("div");
            div.setStyle("padding-top:6px; white-space: nowrap");
            Hyperlink resultLink = new Hyperlink();
            resultLink.setId("searchLink" + linkId++);
            resultLink.setUrl(item.getURL().toString());
            resultLink.setText(item.getName());
            resultLink.setTarget(CONTENT_FRAME_NAME);
            resultLink.setStyleClass(this.theme.getStyleClass("HELP_RESULT_DIV"));
            div.getChildren().add(resultLink);
            resultsKids.add(div);
        }
    }

    public Tree getIndexTree() {
        if (this.indexTree == null) {
            this.indexTree = new Tree();
            this.indexTree.setId(HELP_INDEX_TREE_ID);
            ClientSniffer cs = ClientSniffer.getInstance(FacesContext.getCurrentInstance());
            if (cs.isIe6up()) {
                this.contentsTree.setStyle("width:40em;");
            }
            this.initTree(this.indexTree, this.getHelpUtils().getIndexTreeList());
            this.indexTree.setRendered(false);
        }
        return this.indexTree;
    }

    public void setIndexTree(Tree tree) {
        this.indexTree = tree;
    }

    public Tree getContentsTree() {
        if (this.contentsTree == null) {
            this.contentsTree = new Tree();
            this.contentsTree.setId(HELP_CONTENTS_TREE_ID);
            ClientSniffer cs = ClientSniffer.getInstance(FacesContext.getCurrentInstance());
            if (cs.isIe6up()) {
                this.contentsTree.setStyle("width:40em;");
            }
            this.initTree(this.contentsTree, this.getHelpUtils().getTOCTreeList());
        }
        return this.contentsTree;
    }

    public void setContentsTree(Tree tree) {
        this.contentsTree = tree;
    }

    public PanelGroup getSearchPanel() {
        if (this.searchPanel == null) {
            this.initSearchPanel();
        }
        return this.searchPanel;
    }

    public void setSearchPanel(PanelGroup panel) {
        this.searchPanel = panel;
    }

    public PanelGroup getSearchResultsPanel() {
        if (this.searchResultsPanel == null) {
            this.initSearchResultsPanel();
        }
        return this.searchResultsPanel;
    }

    public void setSearchResultsPanel(PanelGroup panel) {
        this.searchResultsPanel = panel;
    }

    public Hyperlink getTipsLink() {
        if (this.tipsLink == null) {
            this.tipsLink = new Hyperlink();
            this.tipsLink.setId("searchTipsLink");
            this.tipsLink.setText(this.getTheme().getMessage("help.tips"));
            StringBuilder tipsUrlBuffer = new StringBuilder();
            String zJspPath = this.getJspPath();
            if (zJspPath != null) {
                tipsUrlBuffer.append(zJspPath);
            }
            tipsUrlBuffer.append("/com_sun_webui_jsf/help/").append("tips.jsp");
            FacesContext context = FacesContext.getCurrentInstance();
            this.tipsLink.setUrl(context.getApplication().getViewHandler().getActionURL(context, tipsUrlBuffer.toString()));
            this.tipsLink.setTarget(CONTENT_FRAME_NAME);
        }
        return this.tipsLink;
    }

    public void setTipsLink(Hyperlink link) {
        this.tipsLink = link;
    }

    public String getTipsTitle() {
        this.tipsTitle = this.getTheme().getMessage("help.tips");
        return this.tipsTitle;
    }

    public String getTipsImprove() {
        this.tipsImprove = this.getTheme().getMessage("help.tipsImprove");
        return this.tipsImprove;
    }

    public String getTipsImprove1() {
        this.tipsImprove1 = this.getTheme().getMessage("help.tipsImprove1");
        return this.tipsImprove1;
    }

    public String getTipsImprove2() {
        this.tipsImprove2 = this.getTheme().getMessage("help.tipsImprove2");
        return this.tipsImprove2;
    }

    public String getTipsImprove3() {
        this.tipsImprove3 = this.getTheme().getMessage("help.tipsImprove3");
        return this.tipsImprove3;
    }

    public String getTipsImprove4() {
        this.tipsImprove4 = this.getTheme().getMessage("help.tipsImprove4");
        return this.tipsImprove4;
    }

    public String getTipsNote() {
        this.tipsNote = this.getTheme().getMessage("help.tipsNote");
        return this.tipsNote;
    }

    public String getTipsNoteDetails() {
        this.tipsNoteDetails = this.getTheme().getMessage("help.tipsNoteDetails");
        return this.tipsNoteDetails;
    }

    public String getTipsSearch() {
        this.tipsSearch = this.getTheme().getMessage("help.tipsSearch");
        return this.tipsSearch;
    }

    public String getTipsSearch1() {
        this.tipsSearch1 = this.getTheme().getMessage("help.tipsSearch1");
        return this.tipsSearch1;
    }

    public String getTipsSearch2() {
        this.tipsSearch2 = this.getTheme().getMessage("help.tipsSearch2");
        return this.tipsSearch2;
    }

    public String getTipsSearch3() {
        this.tipsSearch3 = this.getTheme().getMessage("help.tipsSearch3");
        return this.tipsSearch3;
    }

    public String getTipsSearch4() {
        this.tipsSearch4 = this.getTheme().getMessage("help.tipsSearch4");
        return this.tipsSearch4;
    }

    public String getBackButtonText() {
        this.backButtonText = this.getTheme().getMessage("help.backButtonTitle");
        return this.backButtonText;
    }

    public String getForwardButtonText() {
        this.forwardButtonText = this.getTheme().getMessage("help.forwardButtonTitle");
        return this.forwardButtonText;
    }

    public String getPrintButtonText() {
        this.printButtonText = this.getTheme().getMessage("help.printButtonTitle");
        return this.printButtonText;
    }

    public String getContentsText() {
        this.contentsText = this.getTheme().getMessage("help.contentsTab");
        return this.contentsText;
    }

    public String getIndexText() {
        this.indexText = this.getTheme().getMessage("help.indexTab");
        return this.indexText;
    }

    public String getSearchText() {
        this.searchText = this.getTheme().getMessage("help.searchTab");
        return this.searchText;
    }

    public String getLocalizedHelpPath() {
        return this.getHelpUtils().getLocalizedHelpPath();
    }

    public void setLocalizedHelpPath(String path) {
        this.localizedHelpPath = path;
    }

    public String getBackButtonIcon() {
        return "HELP_BACK";
    }

    public String getForwardButtonIcon() {
        return "HELP_FORWARD";
    }

    public String getPrintButtonIcon() {
        return "HELP_PRINT";
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public String getSearchLabel() {
        if (this.searchLabel == null) {
            this.searchLabel = this.getTheme().getMessage("help.searchButton");
        }
        return this.searchLabel;
    }

    public void setSearchLabel(String label) {
        this.searchLabel = label;
    }

    public String getNavFrameTitle() {
        if (this.navFrameTitle == null) {
            this.navFrameTitle = this.getTheme().getMessage("help.navFrameTitle");
        }
        return this.navFrameTitle;
    }

    public void setNavFrameTitle(String title) {
        this.navFrameTitle = title;
    }

    public String getButtonFrameTitle() {
        if (this.buttonFrameTitle == null) {
            this.buttonFrameTitle = this.getTheme().getMessage("help.buttonFrameTitle");
        }
        return this.buttonFrameTitle;
    }

    public void setButtonFrameTitle(String title) {
        this.buttonFrameTitle = title;
    }

    public String getContentFrameTitle() {
        if (this.contentFrameTitle == null) {
            this.contentFrameTitle = this.getTheme().getMessage("help.contentFrameTitle");
        }
        return this.contentFrameTitle;
    }

    public void setContentFrameTitle(String title) {
        this.contentFrameTitle = title;
    }

    public String getNoFrames() {
        if (this.noFrames == null) {
            this.noFrames = this.getTheme().getMessage("help.noframes");
        }
        return this.noFrames;
    }

    public void setNoFrames(String newNoFrames) {
        this.noFrames = newNoFrames;
    }

    public String getButtonNavHeadTitle() {
        if (this.buttonNavHeadTitle == null) {
            this.buttonNavHeadTitle = this.getTheme().getMessage("help.buttonNavHeadTitle");
        }
        return this.buttonNavHeadTitle;
    }

    public void setButtonNavHeadTitle(String title) {
        this.buttonNavHeadTitle = title;
    }

    public String getNavigatorHeadTitle() {
        if (this.navigatorHeadTitle == null) {
            this.navigatorHeadTitle = this.getTheme().getMessage("help.navigatorHeadTitle");
        }
        return this.navigatorHeadTitle;
    }

    public void setNavigatorHeadTitle(String title) {
        this.navigatorHeadTitle = title;
    }

    public String getTipsHeadTitle() {
        if (this.tipsHeadTitle == null) {
            this.tipsHeadTitle = this.getTheme().getMessage("help.tips");
        }
        return this.tipsHeadTitle;
    }

    public void setTipsHeadTitle(String title) {
        this.tipsHeadTitle = title;
    }

    private int checkParam(String paramName) {
        block3: {
            FacesContext context = FacesContext.getCurrentInstance();
            Map parms = context.getExternalContext().getRequestParameterMap();
            String paramValue = (String)parms.get(paramName);
            try {
                if (paramValue != null && Integer.parseInt(paramValue) != -1) {
                    return Integer.parseInt(paramValue);
                }
            }
            catch (NumberFormatException nfe) {
                if (!LogUtil.infoEnabled()) break block3;
                LogUtil.info(HelpBackingBean.class, "WEBUI0007", new String[]{paramName});
            }
        }
        return -1;
    }

    public String getBodyClassName() {
        return this.bodyClassName;
    }

    public String getButtonClassName() {
        this.buttonClassName = this.getTheme().getStyleClass("HELP_BUTTON_DIV");
        return this.buttonClassName;
    }

    public String getinlineHelpClassName() {
        this.inlineHelpClassName = this.getTheme().getStyleClass("HELP_FIELD_TEXT");
        return this.inlineHelpClassName;
    }

    public String getSearchClassName() {
        this.searchClassName = this.getTheme().getStyleClass("HELP_SEARCH_DIV");
        return this.searchClassName;
    }

    public String getStepTabClassName() {
        this.stepTabClassName = this.getTheme().getStyleClass("HELP_STEP_TAB");
        return this.stepTabClassName;
    }

    public String getTitleClassName() {
        this.titleClassName = this.getTheme().getStyleClass("TITLE_LINE");
        return this.titleClassName;
    }

    public String getbuttonBodyClassName() {
        this.bodyClassName = this.getTheme().getStyleClass("HELP_BODY");
        return this.buttonBodyClassName;
    }
}

