/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.node.LocalizedNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.glassfish.deployment.common.Descriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IconNode
extends LocalizedNode {
    private String smallIcon = null;
    private String largeIcon = null;

    @Override
    public Object getDescriptor() {
        return null;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if (element.getQName().equals("small-icon")) {
            this.smallIcon = value;
        } else if (element.getQName().equals("large-icon")) {
            this.largeIcon = value;
        }
    }

    @Override
    public void postParsing() {
        Object o = this.getParentNode().getDescriptor();
        if (o != null && o instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)o;
            if (this.largeIcon != null) {
                descriptor.setLocalizedLargeIconUri(this.lang, this.largeIcon);
            }
            if (this.smallIcon != null) {
                descriptor.setLocalizedSmallIconUri(this.lang, this.smallIcon);
            }
        }
    }

    public void writeLocalizedInfo(Node parentNode, Descriptor descriptor) {
        String lang;
        Set entrySet;
        Map largeIcons = descriptor.getLocalizedLargeIconUris();
        Map smallIcons = descriptor.getLocalizedSmallIconUris();
        if (largeIcons == null && smallIcons == null) {
            return;
        }
        if (smallIcons != null) {
            entrySet = smallIcons.entrySet();
            for (Map.Entry entry : entrySet) {
                lang = (String)entry.getKey();
                String smallIconUri = (String)entry.getValue();
                String largeIconUri = null;
                if (largeIcons != null) {
                    largeIconUri = (String)largeIcons.get(lang);
                }
                this.addIconInfo(parentNode, lang, smallIconUri, largeIconUri);
            }
        }
        if (largeIcons != null) {
            entrySet = largeIcons.entrySet();
            for (Map.Entry entry : entrySet) {
                lang = (String)entry.getKey();
                String largeIconUri = (String)entry.getValue();
                if (smallIcons != null && smallIcons.get(lang) != null) continue;
                this.addIconInfo(parentNode, lang, null, largeIconUri);
            }
        }
    }

    private void addIconInfo(Node node, String lang, String smallIconUri, String largeIconUri) {
        Element iconNode = IconNode.appendChild(node, "icon");
        if (Locale.ENGLISH.getLanguage().equals(lang)) {
            iconNode.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", lang);
        }
        IconNode.appendTextChild((Node)iconNode, "small-icon", smallIconUri);
        IconNode.appendTextChild((Node)iconNode, "large-icon", largeIconUri);
    }
}

