/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSMember;
import com.sun.enterprise.ee.cms.core.RejoinSubevent;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.impl.base.CustomTagNames;
import com.sun.enterprise.ee.cms.impl.base.GMSThreadFactory;
import com.sun.enterprise.ee.cms.impl.base.PeerID;
import com.sun.enterprise.ee.cms.impl.base.SystemAdvertisement;
import com.sun.enterprise.ee.cms.impl.base.Utility;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import com.sun.enterprise.mgmt.ClusterManager;
import com.sun.enterprise.mgmt.ClusterView;
import com.sun.enterprise.mgmt.ClusterViewEvent;
import com.sun.enterprise.mgmt.ClusterViewEvents;
import com.sun.enterprise.mgmt.ClusterViewManager;
import com.sun.enterprise.mgmt.HealthMessage;
import com.sun.enterprise.mgmt.ReliableMulticast;
import com.sun.enterprise.mgmt.transport.Message;
import com.sun.enterprise.mgmt.transport.MessageEvent;
import com.sun.enterprise.mgmt.transport.MessageIOException;
import com.sun.enterprise.mgmt.transport.MessageImpl;
import com.sun.enterprise.mgmt.transport.MessageListener;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

class MasterNode
implements MessageListener,
Runnable {
    private static final Logger LOG = GMSLogDomain.getLogger("ShoalLogger");
    private static final Logger mcastLogger = GMSLogDomain.getMcastLogger();
    private static final Logger masterLogger = GMSLogDomain.getMasterNodeLogger();
    private static final Logger monitorLogger = GMSLogDomain.getMonitorLogger();
    private static final Logger nomLog = GMSLogDomain.getNoMCastLogger();
    private final ClusterManager manager;
    private String instanceName = "";
    private String groupName = "";
    private boolean masterAssigned = false;
    private volatile boolean discoveryInProgress = true;
    private PeerID localNodeID;
    private final SystemAdvertisement sysAdv;
    private volatile boolean started = false;
    private volatile boolean stop = false;
    private Thread thread = null;
    private ClusterViewManager clusterViewManager;
    private ClusterView discoveryView;
    private final AtomicLong masterViewID = new AtomicLong();
    final Object MASTERLOCK = new Object();
    private static final String CCNTL = "CCNTL";
    private static final String MASTERNODE = "MN";
    private static final String MASTERQUERY = "MQ";
    private static final String NODEQUERY = "NQ";
    private static final String MASTERNODERESPONSE = "MR";
    private static final String NODERESPONSE = "NR";
    private static final String NAMESPACE = "MASTER";
    private static final String NODEADV = "NAD";
    private static final String AMASTERVIEW = "AMV";
    private static final String AMASTERVIEWSTATES = "AMVS";
    static final String MASTERVIEWSEQ = "SEQ";
    private static final String GROUPSTARTING = "GS";
    private static final String GROUPMEMBERS = "GN";
    private static final String GROUPSTARTUPCOMPLETE = "GSC";
    private static final String RESENDREQUEST = "RR";
    private static final String LATESTMASTERVIEWID = "LMWID";
    private static final boolean NOTIFY_LISTENERS = true;
    private static final boolean DONOT_NOTIFY_LISTENERS = false;
    private int interval = 6;
    private long timeout = 10000L;
    static final String VIEW_CHANGE_EVENT = "VCE";
    private static final String REJOIN_SUBEVENT = "RJSE";
    private boolean groupStarting = false;
    private List<String> groupStartingMembers = null;
    private final Timer timer;
    private DelayedSetGroupStartingCompleteTask groupStartingTask = null;
    private static final long MAX_GROUPSTARTING_TIME_MS = 600000L;
    private static final long GROUPSTARTING_COMPLETE_DELAY = 3000L;
    private boolean clusterStopping = false;
    final Object discoveryLock = new Object();
    private GMSContext ctx = null;
    private final SortedSet<MasterNodeMessageEvent> outstandingMasterNodeMessages;
    private Thread processOutstandingMessagesThread = null;
    private ConcurrentHashMap<String, Object> pendingGroupStartupMembers = new ConcurrentHashMap();
    private SortedSet<String> groupMembers = new TreeSet<String>();
    private ReliableMulticast reliableMulticast;
    private final ExecutorService checkForMissedMasterMsgSingletonExecutor;
    final TreeSet<ProcessedMasterViewId> processedChangeEvents = new TreeSet();
    final boolean NON_MULTICAST;
    private PeerID lastCheckedMaster = null;
    private long lastCheckedMasterViewID = -1L;
    static final Level DEBUG_TRACE = Level.FINE;

    MasterNode(ClusterManager manager, long timeout, int interval, Map props) {
        boolean NON_MULTICAST_VALUE;
        this.localNodeID = manager.getPeerID();
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.interval = interval;
        this.manager = manager;
        this.instanceName = manager.getInstanceName();
        this.groupName = manager.getGroupName();
        this.sysAdv = manager.getSystemAdvertisement();
        this.discoveryView = new ClusterView(this.sysAdv);
        this.timer = new Timer(true);
        this.outstandingMasterNodeMessages = new TreeSet<MasterNodeMessageEvent>();
        this.checkForMissedMasterMsgSingletonExecutor = Executors.newSingleThreadExecutor(new GMSThreadFactory("GMS-validateMasterChangeEvents-Group-" + manager.getGroupName() + "-thread"));
        String value = (String)props.get(ServiceProviderConfigurationKeys.DISCOVERY_URI_LIST.toString());
        boolean bl = NON_MULTICAST_VALUE = value != null;
        if (!NON_MULTICAST_VALUE) {
            value = (String)props.get(ServiceProviderConfigurationKeys.VIRTUAL_MULTICAST_URI_LIST.toString());
            NON_MULTICAST_VALUE = value != null;
        }
        this.NON_MULTICAST = NON_MULTICAST_VALUE;
    }

    long getTimeout() {
        return this.timeout * (long)this.interval;
    }

    public long getMasterViewID() {
        return this.masterViewID.get();
    }

    public static long getStartTime(SystemAdvertisement adv) {
        long result = 0L;
        try {
            result = Long.parseLong(adv.getCustomTagValue(CustomTagNames.START_TIME.toString()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isSeniorMember(SystemAdvertisement currentAdv, SystemAdvertisement newAdv) {
        return MasterNode.getStartTime(currentAdv) < MasterNode.getStartTime(newAdv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkMaster(SystemAdvertisement systemAdv) {
        if (this.masterAssigned && this.isMaster()) {
            LOG.log(Level.FINE, "checkMaster : clusterStopping() = " + this.clusterStopping);
            if (this.clusterStopping) {
                masterLogger.log(Level.FINE, "Resigning Master Node role in anticipation of a master node announcement");
                masterLogger.log(Level.FINE, "Accepting DAS as new master in the event of cluster stopping...");
                this.setMaster(systemAdv, true);
                return false;
            }
            LOG.log(Level.INFO, "mgmt.masternode.collision", new Object[]{systemAdv.getName()});
            this.send(systemAdv.getID(), systemAdv.getName(), this.createMasterCollisionMessage());
            if (MasterNode.isSeniorMember(this.manager.getSystemAdvertisement(), systemAdv)) {
                masterLogger.log(Level.FINE, "Affirming Master Node role");
            } else {
                masterLogger.log(Level.FINE, "Resigning Master Node role in anticipation of a master node announcement");
                this.setMaster(systemAdv, false);
            }
            return false;
        }
        this.setMaster(systemAdv, true);
        Object object = this.MASTERLOCK;
        synchronized (object) {
            this.MASTERLOCK.notifyAll();
        }
        if (masterLogger.isLoggable(Level.FINE)) {
            masterLogger.log(Level.FINE, "Discovered a Master node :" + systemAdv.getName());
        }
        return true;
    }

    public Message createResendRequest(PeerID master, List<Long> missed) {
        Message msg = this.createSelfNodeAdvertisement();
        msg.addMessageElement(RESENDREQUEST, (Serializable)((Object)missed));
        return msg;
    }

    private Message createMasterCollisionMessage() {
        Message msg = this.createSelfNodeAdvertisement();
        msg.addMessageElement(CCNTL, this.localNodeID);
        LOG.log(Level.FINER, "Created a Master Collision Message");
        return msg;
    }

    private Message createSelfNodeAdvertisement() {
        MessageImpl msg = new MessageImpl(3);
        msg.addMessageElement(NODEADV, this.sysAdv);
        return msg;
    }

    private void sendSelfNodeAdvertisement(PeerID id, String name) {
        Message msg = this.createSelfNodeAdvertisement();
        LOG.log(Level.FINER, "Sending a Node Response Message ");
        msg.addMessageElement(NODERESPONSE, (Serializable)((Object)"noderesponse"));
        this.send(id, name, msg);
    }

    private void sendGroupStartupComplete() {
        Message msg = this.createSelfNodeAdvertisement();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Sending GroupStartupComplete Message for group:" + this.manager.getGroupName());
        }
        msg.addMessageElement(GROUPSTARTUPCOMPLETE, (Serializable)((Object)"true"));
        this.send(null, null, msg);
    }

    private Message createMasterQuery() {
        Message msg = this.createSelfNodeAdvertisement();
        msg.addMessageElement(MASTERQUERY, (Serializable)((Object)"query"));
        LOG.log(Level.FINER, "Created a Master Node Query Message ");
        return msg;
    }

    private Message createNodeQuery() {
        Message msg = this.createSelfNodeAdvertisement();
        msg.addMessageElement(NODEQUERY, (Serializable)((Object)"nodequery"));
        LOG.log(Level.FINER, "Created a Node Query Message ");
        return msg;
    }

    private Message createMasterResponse(boolean announcement, PeerID masterID) {
        Message msg = this.createSelfNodeAdvertisement();
        String type = MASTERNODE;
        if (!announcement) {
            type = MASTERNODERESPONSE;
        }
        msg.addMessageElement(type, masterID);
        if (this.groupStarting) {
            msg.addMessageElement(GROUPSTARTING, Boolean.valueOf(this.groupStarting));
            msg.addMessageElement(GROUPMEMBERS, (Serializable)((Object)this.groupMembers));
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Created a Master Response Message with masterId = " + masterID.toString() + " groupStarting=" + Boolean.toString(this.groupStarting));
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean discoverMaster() {
        this.masterViewID.set(this.clusterViewManager.getMasterViewID());
        long timeToWait = this.timeout;
        LOG.log(Level.FINER, "Attempting to discover a master node");
        Message query = this.createMasterQuery();
        this.send(null, null, query);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, " waiting for " + this.timeout + " ms");
        }
        try {
            Object object = this.MASTERLOCK;
            synchronized (object) {
                this.MASTERLOCK.wait(timeToWait);
            }
        }
        catch (InterruptedException intr) {
            Thread.interrupted();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "masterAssigned=" + this.masterAssigned);
        }
        return this.masterAssigned;
    }

    boolean isMaster() {
        if (masterLogger.isLoggable(Level.FINEST)) {
            masterLogger.log(Level.FINEST, "isMaster :" + this.clusterViewManager.isMaster() + " MasterAssigned :" + this.masterAssigned + " View Size :" + this.clusterViewManager.getViewSize());
        } else if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "isMaster :" + this.clusterViewManager.isMaster() + " MasterAssigned :" + this.masterAssigned + " View Size :" + this.clusterViewManager.getViewSize());
        }
        return this.clusterViewManager.isMaster();
    }

    boolean isMasterAssigned() {
        return this.masterAssigned;
    }

    PeerID getMasterNodeID() {
        return this.clusterViewManager.getMaster().getID();
    }

    synchronized boolean isStarted() {
        return this.started;
    }

    void resetMaster() {
        LOG.log(Level.FINER, "Resetting Master view");
        this.masterAssigned = false;
    }

    SystemAdvertisement processNodeAdvertisement(Message msg) throws IOException {
        SystemAdvertisement adv;
        Object msgElement = msg.getMessageElement(NODEADV);
        if (msgElement == null) {
            LOG.log(Level.WARNING, "mgmt.masternode.missingna", new Object[]{msg.toString()});
            return null;
        }
        if (msgElement instanceof SystemAdvertisement) {
            adv = (SystemAdvertisement)msgElement;
            if (!adv.getID().equals(this.localNodeID)) {
                LOG.log(Level.FINER, "Received a System advertisment Name :" + adv.getName());
            }
        } else {
            LOG.log(Level.WARNING, "mgmt.unknownMessage");
            adv = null;
        }
        return adv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeAnnouncement(Message msg, SystemAdvertisement source) throws IOException {
        Object msgElement = msg.getMessageElement(MASTERNODE);
        if (msgElement == null) {
            return false;
        }
        GMSMember member = Utility.getGMSMember(source);
        long seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ);
        if (masterLogger.isLoggable(Level.FINE)) {
            masterLogger.fine("Received a Master Node Announcement from  member:" + member.getMemberToken() + " of group:" + member.getGroupName() + " masterViewSeqId:" + seqID + " masterAssigned:" + this.masterAssigned + " isMaster:" + this.isMaster());
        }
        if (this.checkMaster(source)) {
            msgElement = msg.getMessageElement(AMASTERVIEW);
            if (msgElement != null && msgElement instanceof List) {
                List newLocalView = (List)msgElement;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, MessageFormat.format("Received an authoritative view from {0}, of size {1} resetting local view containing {2}", source.getName(), newLocalView.size(), this.clusterViewManager.getLocalView().getSize()));
                }
                if ((msgElement = msg.getMessageElement(VIEW_CHANGE_EVENT)) != null && msgElement instanceof ClusterViewEvent) {
                    LOG.log(Level.FINE, "MasterNode:PMNA: Received Master View with Seq Id=" + seqID + "Current sequence is " + this.clusterViewManager.getMasterViewID());
                    if (!this.isDiscoveryInProgress() && seqID <= this.clusterViewManager.getMasterViewID()) {
                        LOG.log(Level.WARNING, MessageFormat.format("Received an older clusterView sequence {0}. Current sequence :{1} discarding out of sequence view", seqID, this.clusterViewManager.getMasterViewID()));
                        return true;
                    }
                    ClusterViewEvent cvEvent = (ClusterViewEvent)msgElement;
                    if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
                        LOG.log(Level.FINE, "New ClusterViewManager does not contain self. Publishing Self");
                        this.sendSelfNodeAdvertisement(source.getID(), null);
                        return true;
                    }
                    this.clusterViewManager.setMasterViewID(seqID);
                    this.masterViewID.set(seqID);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "MN: New MasterViewID = " + this.clusterViewManager.getMasterViewID());
                    }
                    this.clusterViewManager.addToView(newLocalView, true, cvEvent);
                }
            } else {
                LOG.log(Level.WARNING, "mgmt.masternode.noview");
            }
        }
        Object object = this.MASTERLOCK;
        synchronized (object) {
            this.MASTERLOCK.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeResponse(Message msg, SystemAdvertisement source) throws IOException {
        boolean masterChanged;
        Object msgElement = msg.getMessageElement(MASTERNODERESPONSE);
        if (msgElement == null) {
            return false;
        }
        long seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Received a MasterNode Response from Member:" + source.getName() + " PMNR masterViewSeqId:" + seqID + " current MasterViewSeqId:" + this.masterViewID.get() + " masterAssigned=" + this.masterAssigned + " isMaster=" + this.isMaster() + " discoveryInProgress:" + this.isDiscoveryInProgress());
        }
        if ((msgElement = msg.getMessageElement(GROUPSTARTING)) != null && !this.groupStarting) {
            Set groupmembers = null;
            msgElement = msg.getMessageElement(GROUPMEMBERS);
            if (msgElement != null && msgElement instanceof Set) {
                groupmembers = (Set)msgElement;
                this.getGMSContext().setGroupStartupJoinMembers(groupmembers);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "MNR indicates GroupStart for group: " + this.manager.getGroupName() + " members:" + groupmembers);
            }
            this.setGroupStarting(true);
            this.delayedSetGroupStarting(false, 600000L);
        }
        if ((msgElement = msg.getMessageElement(AMASTERVIEW)) == null || !(msgElement instanceof List)) {
            this.setMaster(source, true);
            return true;
        }
        List newLocalView = (List)msgElement;
        msgElement = msg.getMessageElement(VIEW_CHANGE_EVENT);
        if (msgElement == null || !(msgElement instanceof ClusterViewEvent)) {
            this.setMaster(source, true);
            return true;
        }
        if (!this.isDiscoveryInProgress() && seqID <= this.clusterViewManager.getMasterViewID()) {
            this.setMaster(source, true);
            LOG.log(Level.WARNING, "mgmt.masternode.staleview", new Object[]{seqID, newLocalView.size(), this.clusterViewManager.getMasterViewID()});
            return true;
        }
        ClusterViewEvent cvEvent = (ClusterViewEvent)msgElement;
        Object object = this;
        synchronized (object) {
            this.clusterViewManager.setMasterViewID(seqID);
            this.masterViewID.set(seqID);
            masterChanged = this.clusterViewManager.setMaster(newLocalView, source);
            this.masterAssigned = true;
        }
        if (masterChanged) {
            this.clusterViewManager.notifyListeners(cvEvent);
            this.clearChangeEventsNotFromCurrentMaster(source.getID());
        } else {
            this.clusterViewManager.addToView(newLocalView, true, cvEvent);
        }
        object = this.MASTERLOCK;
        synchronized (object) {
            this.MASTERLOCK.notifyAll();
        }
        return true;
    }

    boolean processGroupStartupComplete(Message msg, SystemAdvertisement source) throws IOException {
        Object msgElement = msg.getMessageElement(GROUPSTARTUPCOMPLETE);
        if (msgElement == null) {
            return false;
        }
        LOG.fine("received GROUPSTARTUPCOMPLETE from Master");
        this.delayedSetGroupStarting(false, 3000L);
        return true;
    }

    boolean processChangeEvent(Message msg, SystemAdvertisement source) throws IOException {
        MemberStates[] memberStates = null;
        Object msgElement = msg.getMessageElement(VIEW_CHANGE_EVENT);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Inside processChangeEvent for group: " + this.manager.getGroupName());
        }
        if (msgElement != null && msgElement instanceof ClusterViewEvent) {
            ClusterViewEvent cvEvent = (ClusterViewEvent)msgElement;
            RejoinSubevent rjse = null;
            switch (cvEvent.getEvent()) {
                case ADD_EVENT: {
                    rjse = (RejoinSubevent)msg.getMessageElement(REJOIN_SUBEVENT);
                    if (rjse == null) break;
                    this.getGMSContext().getInstanceRejoins().put(cvEvent.getAdvertisement().getName(), rjse);
                    break;
                }
                case JOINED_AND_READY_EVENT: {
                    rjse = (RejoinSubevent)msg.getMessageElement(REJOIN_SUBEVENT);
                    if (rjse != null) {
                        this.getGMSContext().getInstanceRejoins().put(cvEvent.getAdvertisement().getName(), rjse);
                    }
                    if ((msgElement = msg.getMessageElement(AMASTERVIEWSTATES)) == null) break;
                    memberStates = (MemberStates[])msgElement;
                    break;
                }
            }
            msgElement = msg.getMessageElement(AMASTERVIEW);
            if (msgElement != null && msgElement instanceof List) {
                long seqID;
                List newLocalView = (List)msgElement;
                if (cvEvent.getEvent() == ClusterViewEvents.JOINED_AND_READY_EVENT) {
                    if (cvEvent.getAdvertisement().getID().equals(this.localNodeID)) {
                        this.manager.getHealthMonitor().setJoinedAndReadyReceived();
                    }
                    if (memberStates != null) {
                        int i = 0;
                        TreeSet<String> readyMembers = new TreeSet<String>();
                        for (SystemAdvertisement adv : newLocalView) {
                            switch (memberStates[i]) {
                                case READY: 
                                case ALIVEANDREADY: {
                                    readyMembers.add(adv.getName());
                                }
                            }
                            ++i;
                        }
                        this.getGMSContext().getAliveAndReadyViewWindow().put(cvEvent.getAdvertisement().getName(), readyMembers);
                    }
                }
                if ((seqID = MasterNode.getLongFromMessage(msg, NAMESPACE, MASTERVIEWSEQ)) <= this.clusterViewManager.getMasterViewID()) {
                    LOG.log(Level.WARNING, "mgmt.masternode.staleviewnotify", new Object[]{seqID, this.clusterViewManager.getMasterViewID(), cvEvent.getEvent().toString(), cvEvent.getAdvertisement().getName(), this.manager.getGroupName()});
                    this.clusterViewManager.notifyListeners(cvEvent);
                    return true;
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, MessageFormat.format("Received a new view of size :{0}, event :{1}", newLocalView.size(), cvEvent.getEvent().toString()));
                }
                if (!newLocalView.contains(this.manager.getSystemAdvertisement())) {
                    LOG.log(Level.FINER, "Received ClusterViewManager does not contain self. Publishing Self");
                    this.sendSelfNodeAdvertisement(source.getID(), null);
                    this.clusterViewManager.notifyListeners(cvEvent);
                    return true;
                }
                this.clusterViewManager.setMasterViewID(seqID);
                this.masterViewID.set(seqID);
                this.clusterViewManager.addToView(newLocalView, true, cvEvent);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processResendRequest(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        Object element;
        if (this.isMaster() && this.masterAssigned && (element = msg.getMessageElement(RESENDREQUEST)) != null && element instanceof List) {
            List missedList = (List)element;
            for (Long missed : missedList) {
                this.reliableMulticast.resend(adv.getID(), missed);
            }
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message masterResponseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(masterResponseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Rejoin initiated due to resend request: Master " + this.manager.getInstanceName() + " broadcasting ADD_EVENT  of member: " + adv.getName() + " to GMS group: " + this.manager.getGroupName());
                }
                this.sendNewView(null, cvEvent, masterResponseMsg, false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeQuery(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        Object msgElement = msg.getMessageElement(MASTERQUERY);
        if (msgElement == null || adv == null) {
            return false;
        }
        if (this.isMaster() && this.masterAssigned) {
            LOG.log(Level.FINE, MessageFormat.format("Received a MasterNode Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message masterResponseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(masterResponseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Master " + this.manager.getInstanceName() + " broadcasting ADD_EVENT  of member: " + adv.getName() + " to GMS group: " + this.manager.getGroupName());
                }
                this.sendNewView(null, cvEvent, masterResponseMsg, false);
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Node " + adv.getName() + " is already in the view. Hence not sending ADD_EVENT.");
            }
        } else if (this.masterAssigned && this.NON_MULTICAST) {
            this.send(this.getMasterNodeID(), "", msg);
        }
        SystemAdvertisement madv = this.clusterViewManager.getMaster();
        SystemAdvertisement oldSysAdv = this.clusterViewManager.get(adv.getID());
        if (madv != null && madv.getID().equals(adv.getID())) {
            if (this.confirmInstanceHasRestarted(oldSysAdv, adv)) {
                LOG.log(Level.WARNING, "mgmt.masternode.unreportedmasterfailure", new Object[]{madv.getName()});
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("MasterNode.processMasterNodeQuery() : clusterViewManager.getMaster().getID() = " + this.clusterViewManager.getMaster().getID());
                    LOG.finer("MasterNode.processMasterNodeQuery() : adv.getID() = " + adv.getID());
                    LOG.finer("MasterNode.processMasterNodeQuery() : clusterViewManager.getMaster().getname() = " + this.clusterViewManager.getMaster().getName());
                    LOG.finer("MasterNode.processMasterNodeQuery() : adv.getID() = " + adv.getName());
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("MasterNode.processMasterNodeQuery() : re-electing the master...");
                }
                this.manager.getClusterViewManager().remove(oldSysAdv);
                this.manager.getClusterViewManager().add(adv);
                this.resetMaster();
                this.appointMasterNode();
            } else {
                LOG.fine("MasterNode.processMasterNodeQuery() : master node did not restart as suspected");
            }
        } else {
            boolean restarted = this.confirmInstanceHasRestarted(oldSysAdv, adv, false);
            if (restarted) {
                this.manager.getClusterViewManager().add(adv);
            }
        }
        return true;
    }

    boolean confirmInstanceHasRestarted(SystemAdvertisement oldSysAdv, SystemAdvertisement newSysAdv) {
        return this.confirmInstanceHasRestarted(oldSysAdv, newSysAdv, true);
    }

    boolean confirmInstanceHasRestarted(SystemAdvertisement oldSysAdv, SystemAdvertisement newSysAdv, boolean reportWarning) {
        if (oldSysAdv != null && newSysAdv != null) {
            long currentAdvStartTime;
            long cachedAdvStartTime;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("MasterNode.confirmInstanceHasRestarted() : oldSysAdv.getName() = " + oldSysAdv.getName());
            }
            if ((cachedAdvStartTime = Utility.getStartTime(oldSysAdv)) == -1L) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("MasterNode.confirmInstanceHasRestarted : Could not find the START_TIME field in the cached system advertisement");
                }
                return false;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("MasterNode.confirmInstanceHasRestarted() : cachedAdvStartTime = " + cachedAdvStartTime);
            }
            if ((currentAdvStartTime = Utility.getStartTime(newSysAdv)) == -1L) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("MasterNode.confirmInstanceHasRestarted : Could not find the START_TIME field in the current system advertisement");
                }
                return false;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("MasterNode.confirmInstanceHasRestarted() : currentAdvStartTime = " + currentAdvStartTime);
            }
            if (currentAdvStartTime != cachedAdvStartTime) {
                this.manager.getHealthMonitor().cleanAllCaches(oldSysAdv.getName());
                LOG.log(Level.WARNING, "mgmt.masternode.restarted", new Object[]{newSysAdv.getName(), new Date(currentAdvStartTime)});
                LOG.log(Level.WARNING, "mgmt.masternode.nofailurereported", new Object[]{new Date(cachedAdvStartTime)});
                return true;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("MasterNode.confirmInstanceHasRestarted : currentAdvStartTime and cachedAdvStartTime have the same value = " + new Date(cachedAdvStartTime) + " .Instance " + newSysAdv.getName() + "was not restarted.");
            }
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("MasterNode.confirmInstanceHasRestarted : oldSysAdv or newSysAdv is null");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processNodeQuery(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        Object msgElement = msg.getMessageElement(NODEQUERY);
        if (msgElement == null || adv == null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "WARNING: returning without processing in processNodeResponse msgElement=" + msgElement + " adv=" + adv);
            }
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINER, MessageFormat.format("Received a Node Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
        }
        if (this.isMaster() && this.masterAssigned) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, MessageFormat.format("Received a Node Query from Name :{0} ID :{1}", adv.getName(), adv.getID()));
            }
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message responseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(responseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                this.sendNewView(null, cvEvent, responseMsg, false);
            } else if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Node " + adv.getName() + " is already in the view. Hence not sending ADD_EVENT.");
            }
        } else {
            Message response = this.createSelfNodeAdvertisement();
            response.addMessageElement(NODERESPONSE, (Serializable)((Object)"noderesponse"));
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Sending Node response to  :" + adv.getName());
            }
            this.send(null, null, response);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processNodeResponse(Message msg, SystemAdvertisement adv, boolean isAdvAddedToView) throws IOException {
        Object msgElement = msg.getMessageElement(NODERESPONSE);
        if (msgElement == null || adv == null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "WARNING: returning without processing in processNodeResponse msgElement=" + msgElement + " adv=" + adv);
            }
            return false;
        }
        if (this.isMaster() && this.masterAssigned) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, MessageFormat.format("Received a Node Response from Name :{0} ID :{1} isAdvAddedToView :{2}", adv.getName(), adv.getID(), isAdvAddedToView));
            }
            if (isAdvAddedToView) {
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.ADD_EVENT, adv);
                Message responseMsg = this.createMasterResponse(false, this.localNodeID);
                AtomicLong atomicLong = this.masterViewID;
                synchronized (atomicLong) {
                    this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                    this.addAuthoritativeView(responseMsg);
                }
                this.clusterViewManager.notifyListeners(cvEvent);
                this.sendNewView(null, cvEvent, responseMsg, false);
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Node " + adv.getName() + " is already in the view. Hence not sending ADD_EVENT.");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Received a node response from " + adv.getName() + " id:" + adv.getID());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processMasterNodeCollision(Message msg, SystemAdvertisement adv) throws IOException {
        Object msgElement = msg.getMessageElement(CCNTL);
        if (msgElement == null) {
            return false;
        }
        SystemAdvertisement madv = this.manager.getSystemAdvertisement();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, MessageFormat.format("Candidate Master: " + madv.getName() + "received a MasterNode Collision from Name :{0} ID :{1}", adv.getName(), adv.getID()));
        }
        if (madv.getID().compareTo(adv.getID()) >= 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Member " + madv.getName() + " affirming Master Node role over member:" + adv.getName());
            }
            Object object = this.MASTERLOCK;
            synchronized (object) {
                this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                this.announceMaster(this.manager.getSystemAdvertisement());
                this.MASTERLOCK.notifyAll();
            }
        } else {
            LOG.log(Level.FINE, "Resigning Master Node role");
            this.clusterViewManager.setMaster(adv, true);
        }
        return true;
    }

    void probeNode(HealthMessage.Entry entry) throws IOException {
        if (this.isMaster() && this.masterAssigned) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "Probing ID = " + entry.id + ", name = " + entry.adv.getName());
            }
            this.send(entry.id, null, this.createNodeQuery());
        }
    }

    private boolean injectSimulatedFailure(MasterNodeMessageEvent mnme) {
        boolean result = false;
        if ((this.manager.getInstanceName().equals("instance02") || this.manager.getInstanceName().equals("instance04") || this.manager.getInstanceName().equals("instance06")) && mnme.seqId % 5L == 0L) {
            Object element = mnme.msg.getMessageElement("RESEND");
            if (element != null && element instanceof Boolean) {
                result = false;
            } else {
                if (mcastLogger.isLoggable(Level.FINE)) {
                    mcastLogger.fine("simulated drop of receiving UDP broadcast for member:" + this.manager.getInstanceName() + " masterViewSequenceId:" + mnme.seqId);
                }
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessageEvent(MessageEvent event) throws MessageIOException {
        Message msg = event.getMessage();
        if (msg == null) {
            return;
        }
        MasterNodeMessageEvent mnme = new MasterNodeMessageEvent(event);
        if (monitorLogger.isLoggable(Level.FINE)) {
            monitorLogger.fine("MasterNode.receiveMessageEvent:" + mnme.toString());
        }
        if (mcastLogger.isLoggable(Level.FINE)) {
            mcastLogger.fine("receiveMessageEvent: process master node message masterViewSeqId:" + mnme.seqId + " from member:" + event.getSourcePeerID());
        }
        if (mnme.seqId == -1L) {
            this.processNextMessageEvent(mnme);
        } else {
            boolean added;
            if (this.masterAssigned && !this.isMaster() && !this.isDiscoveryInProgress()) {
                boolean result;
                ProcessedMasterViewId processed = new ProcessedMasterViewId((PeerID)msg.getMessageElement("sourcePeerId"), mnme.seqId);
                TreeSet<ProcessedMasterViewId> treeSet = this.processedChangeEvents;
                synchronized (treeSet) {
                    result = this.processedChangeEvents.add(processed);
                }
                if (!result) {
                    if (mcastLogger.isLoggable(Level.FINE)) {
                        mcastLogger.log(Level.FINE, "dropping master node message with masterViewID=" + mnme.seqId + " it was already processed.");
                    }
                    return;
                }
            }
            SortedSet<MasterNodeMessageEvent> sortedSet = this.outstandingMasterNodeMessages;
            synchronized (sortedSet) {
                added = this.outstandingMasterNodeMessages.add(mnme);
                this.outstandingMasterNodeMessages.notify();
            }
            if (added) {
                if (monitorLogger.isLoggable(Level.FINE)) {
                    monitorLogger.fine("receiveMessageEvent: added master node message masterViewSeqId:" + mnme.seqId + " from member:" + event.getSourcePeerID());
                }
            } else {
                LOG.log(Level.WARNING, "mgmt.masternode.dupmasternodemsg", new Object[]{mnme.seqId, event.getSourcePeerID(), mnme.toString()});
            }
        }
    }

    public void processNextMessageEvent(MasterNodeMessageEvent masterNodeMessage) throws MessageIOException {
        boolean result = false;
        if (this.manager.isStopping()) {
            if (mcastLogger.isLoggable(Level.FINE)) {
                mcastLogger.log(Level.FINE, "Since this Peer is Stopping, returning without processing incoming master node message. ");
            }
            return;
        }
        if (this.isStarted()) {
            Message msg = masterNodeMessage.msg;
            long seqId = masterNodeMessage.seqId;
            if (msg == null) {
                LOG.log(Level.WARNING, "mgmt.masternode.nullmessage");
                return;
            }
            try {
                SystemAdvertisement adv = this.processNodeAdvertisement(msg);
                if (adv != null && adv.getID().equals(this.localNodeID)) {
                    LOG.log(Level.FINEST, "Discarding loopback message");
                    return;
                }
                if (adv != null) {
                    if (this.isMaster() && this.masterAssigned) {
                        result = this.clusterViewManager.add(adv);
                    } else if (this.discoveryInProgress) {
                        result = false;
                        this.discoveryView.add(adv);
                    }
                }
                if (this.processResendRequest(msg, adv, result)) {
                    return;
                }
                if (this.processMasterNodeQuery(msg, adv, result)) {
                    return;
                }
                if (this.processNodeQuery(msg, adv, result)) {
                    return;
                }
                if (this.processNodeResponse(msg, adv, result)) {
                    return;
                }
                if (this.processGroupStartupComplete(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeResponse(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeAnnouncement(msg, adv)) {
                    return;
                }
                if (this.processMasterNodeCollision(msg, adv)) {
                    return;
                }
                if (this.processChangeEvent(msg, adv)) {
                    return;
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, MessageFormat.format("ClusterViewManager contains {0} entries", this.clusterViewManager.getViewSize()));
            }
        } else if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Started : " + this.isStarted());
        }
    }

    @Override
    public int getType() {
        return 3;
    }

    private void announceMaster(SystemAdvertisement adv) {
        if (this.reliableMulticast != null) {
            this.reliableMulticast.stop();
            this.reliableMulticast = null;
        }
        this.reliableMulticast = new ReliableMulticast(this.manager);
        Message msg = this.createMasterResponse(true, adv.getID());
        ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, adv);
        if (this.masterAssigned && this.isMaster()) {
            LOG.log(Level.INFO, "mgmt.masternode.announcemasternode", new Object[]{this.clusterViewManager.getViewSize(), this.manager.getInstanceName(), this.manager.getGroupName()});
            this.sendNewView(null, cvEvent, msg, true);
        }
    }

    @Override
    public void run() {
        this.startMasterNodeDiscovery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMasterNodeDiscovery() {
        int count = 0;
        Object object = this;
        synchronized (object) {
            if (!this.masterAssigned) {
                this.clusterViewManager.start();
            }
        }
        if (this.masterAssigned) {
            this.discoverMaster();
            this.discoveryInProgress = false;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "startMasterNodeDiscovery: discovery completed. masterSequenceId:" + this.masterViewID.get() + " clusterViewManager.masterViewID:" + this.clusterViewManager.getMasterViewID());
            }
            object = this.discoveryLock;
            synchronized (object) {
                this.discoveryLock.notifyAll();
            }
            return;
        }
        while (!this.stop && count < this.interval && !this.discoverMaster()) {
            ++count;
        }
        if (!this.masterAssigned) {
            LOG.log(Level.FINER, "MN Discovery timeout, appointing master");
            this.appointMasterNode();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "startMasterNodeDiscovery: after discoverMaster polling, discovery completed. masterSequenceId:" + this.masterViewID.get() + " clusterViewManager.masterViewID:" + this.clusterViewManager.getMasterViewID());
        }
        this.discoveryInProgress = false;
        object = this.discoveryLock;
        synchronized (object) {
            this.discoveryLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appointMasterNode() {
        SystemAdvertisement madv;
        if (this.masterAssigned) {
            return;
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "MasterNode: discoveryInProgress=" + this.discoveryInProgress);
        }
        if (this.discoveryInProgress) {
            this.discoveryView.add(this.sysAdv);
            madv = this.discoveryView.getMasterCandidate();
        } else {
            this.clusterViewManager.add(this.sysAdv);
            madv = this.clusterViewManager.getMasterCandidate();
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "MasterNode: Master Candidate=" + madv.getName());
        }
        this.setMaster(madv, false);
        if (madv.getID().equals(this.localNodeID)) {
            LOG.log(Level.FINER, "MasterNode: Setting myself as MasterNode ");
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "MasterNode: masterViewId =" + this.masterViewID);
            }
            if (this.discoveryInProgress) {
                List<SystemAdvertisement> list = this.discoveryView.getView();
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
                this.clusterViewManager.addToView(list, true, cvEvent);
            } else {
                LOG.log(Level.FINER, "MasterNode: Notifying Local Listeners of  Master Change");
                ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
                this.clusterViewManager.notifyListeners(cvEvent);
            }
        }
        this.discoveryView.clear();
        this.discoveryView.add(this.sysAdv);
        Object object = this.MASTERLOCK;
        synchronized (object) {
            if (madv.getID().equals(this.localNodeID)) {
                LOG.log(Level.INFO, "mgmt.masternode.assumingmasternode", new Object[]{madv.getName(), this.manager.getGroupName()});
                LOG.log(Level.FINER, "MasterNode: announcing MasterNode assumption ");
                this.announceMaster(this.manager.getSystemAdvertisement());
                this.MASTERLOCK.notifyAll();
            }
        }
    }

    private void send(PeerID peerid, String name, Message msg) {
        try {
            if (peerid != null) {
                boolean sent;
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Unicasting Message to :" + name + "ID=" + peerid);
                }
                if (!(sent = this.manager.getNetworkManager().send(peerid, msg))) {
                    LOG.log(Level.WARNING, "mgmt.masternode.sendmsgfailed", new Object[]{msg, name});
                }
            } else {
                LOG.log(Level.FINER, "Broadcasting Message");
                boolean sent = this.manager.getNetworkManager().broadcast(msg);
                if (!sent) {
                    LOG.log(Level.WARNING, "mgmt.masternode.broadcastmsgfailed", new Object[]{msg, this.manager.getGroupName()});
                }
            }
        }
        catch (IOException io) {
            LOG.log(Level.FINEST, "Failed to send message", io);
        }
    }

    void sendNewView(PeerID toID, ClusterViewEvent event, Message msg, boolean includeView) {
        String memberName = event.getAdvertisement().getName();
        RejoinSubevent rjse = null;
        if (includeView) {
            this.addAuthoritativeView(msg);
        }
        msg.addMessageElement(VIEW_CHANGE_EVENT, event);
        switch (event.getEvent()) {
            case ADD_EVENT: 
            case JOINED_AND_READY_EVENT: {
                GMSContext gmsCtx = this.getGMSContext();
                if (gmsCtx == null) break;
                rjse = gmsCtx.getInstanceRejoins().get(memberName);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("sendNewView: clusterViewEvent:" + event.getEvent().toString() + " rejoinSubevent=" + rjse + " member: " + memberName);
                }
                if (rjse == null) break;
                msg.addMessageElement(REJOIN_SUBEVENT, (Serializable)rjse);
                break;
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Sending new authoritative cluster view to group, event :" + event.getEvent().toString() + " viewSeqId: " + this.clusterViewManager.getMasterViewID());
        }
        if (toID != null) {
            this.send(toID, null, msg);
        } else {
            this.reliableBroadcastSend(msg);
        }
        if (rjse != null && event.getEvent() == ClusterViewEvents.JOINED_AND_READY_EVENT) {
            this.ctx.getInstanceRejoins().remove(memberName);
        }
    }

    void addAuthoritativeView(Message msg) {
        ClusterView cv = this.clusterViewManager.getLocalView();
        List<SystemAdvertisement> view = cv.getView();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "MasterNode: Adding Authoritative View of size " + view.size() + "  to view message masterSeqId=" + cv.masterViewId);
        }
        msg.addMessageElement(AMASTERVIEW, (Serializable)((Object)view));
        MasterNode.addLongToMessage(msg, NAMESPACE, MASTERVIEWSEQ, cv.masterViewId);
    }

    void addReadyAuthoritativeView(Message msg) {
        ClusterView cv = this.clusterViewManager.getLocalView();
        List<SystemAdvertisement> view = cv.getView();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "MasterNode: Adding Authoritative View of size " + view.size() + "  to view message masterSeqId=" + cv.masterViewId);
        }
        msg.addMessageElement(AMASTERVIEW, (Serializable)((Object)view));
        MemberStates[] memberStates = new MemberStates[view.size()];
        int i = 0;
        for (SystemAdvertisement adv : view) {
            MemberStates value = MemberStates.UNKNOWN;
            try {
                value = MemberStates.valueOf((String)this.manager.getHealthMonitor().getMemberStateFromHeartBeat(adv.getID(), 10000L).toUpperCase());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            memberStates[i] = value;
            ++i;
        }
        msg.addMessageElement(AMASTERVIEWSTATES, (Serializable)memberStates);
        MasterNode.addLongToMessage(msg, NAMESPACE, MASTERVIEWSEQ, cv.masterViewId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stop() {
        LOG.log(Level.FINER, "Stopping MasterNode");
        this.discoveryView.clear();
        this.thread = null;
        this.masterAssigned = false;
        this.started = false;
        this.stop = true;
        this.discoveryInProgress = false;
        Object object = this.discoveryLock;
        synchronized (object) {
            this.discoveryLock.notifyAll();
        }
        this.manager.getNetworkManager().removeMessageListener(this);
        this.processOutstandingMessagesThread.interrupt();
        if (this.reliableMulticast != null) {
            this.reliableMulticast.stop();
        }
        this.checkForMissedMasterMsgSingletonExecutor.shutdownNow();
    }

    synchronized void start() {
        LOG.log(Level.FINER, "Starting MasterNode");
        this.clusterViewManager = this.manager.getClusterViewManager();
        this.started = true;
        this.manager.getNetworkManager().addMessageListener(this);
        LOG.log(Level.INFO, "mgmt.masternode.registeredlistener", new Object[]{this.manager.getInstanceName(), this.manager.getGroupName()});
        this.processOutstandingMessagesThread = new Thread((Runnable)new ProcessOutstandingMessagesTask(), "GMS MasterNode processOutstandingChangeEvents Group-" + this.manager.getGroupName());
        this.processOutstandingMessagesThread.setDaemon(true);
        this.processOutstandingMessagesThread.start();
        this.thread = new Thread((Runnable)this, "GMS MasterNode Group-" + this.manager.getGroupName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void viewChanged(ClusterViewEvent event) {
        if (this.isMaster() && this.masterAssigned) {
            this.clusterViewManager.notifyListeners(event);
            Message msg = this.createSelfNodeAdvertisement();
            AtomicLong atomicLong = this.masterViewID;
            synchronized (atomicLong) {
                this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
                this.addAuthoritativeView(msg);
            }
            this.sendNewView(null, event, msg, false);
        }
    }

    private static void addLongToMessage(Message message, String nameSpace, String elemName, long data) {
        message.addMessageElement(elemName, Long.valueOf(data));
    }

    private static long getLongFromMessage(Message message, String nameSpace, String elemName) throws NumberFormatException {
        Object value = message.getMessageElement(elemName);
        if (value != null) {
            return Long.parseLong(value.toString());
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void takeOverMasterRole() {
        Object object = this.MASTERLOCK;
        synchronized (object) {
            SystemAdvertisement madv = this.clusterViewManager.get(this.localNodeID);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "MasterNode: Forcefully becoming the Master..." + madv.getName());
            }
            this.setMaster(madv, false);
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "MasterNode: becomeMaster () : masterViewId =" + this.masterViewID);
                LOG.log(Level.FINER, "MasterNode: becomeMaster () : Notifying Local Listeners of  Master Change");
            }
            ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, madv);
            this.clusterViewManager.notifyListeners(cvEvent);
            this.discoveryView.clear();
            this.discoveryView.add(this.sysAdv);
            LOG.log(Level.FINER, "MasterNode: becomeMaster () : announcing MasterNode assumption ");
            this.announceMaster(this.manager.getSystemAdvertisement());
            this.MASTERLOCK.notifyAll();
            this.manager.notifyNewMaster();
        }
    }

    void setClusterStopping() {
        this.clusterStopping = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterViewEvent sendReadyEventView(SystemAdvertisement adv) {
        boolean isGroup = this.pendingGroupStartupMembers.containsKey(adv.getName());
        ClusterViewEvent cvEvent = new ClusterViewEvent(ClusterViewEvents.JOINED_AND_READY_EVENT, adv);
        LOG.log(Level.FINEST, MessageFormat.format("Sending to Group, Joined and Ready Event View for peer :{0}", adv.getName()));
        Message msg = this.createSelfNodeAdvertisement();
        AtomicLong atomicLong = this.masterViewID;
        synchronized (atomicLong) {
            this.clusterViewManager.setMasterViewID(this.masterViewID.incrementAndGet());
            this.addReadyAuthoritativeView(msg);
        }
        this.sendNewView(null, cvEvent, msg, false);
        if (isGroup) {
            this.pendingGroupStartupMembers.remove(adv.getName());
            LOG.fine("sendReadyEventView: pendingGroupStartupMembers: member=" + adv.getName() + " size=" + this.pendingGroupStartupMembers.size() + " pending members remaining:" + this.pendingGroupStartupMembers.keySet());
            if (this.pendingGroupStartupMembers.size() == 0) {
                LOG.fine("sendReadyEventView:  start-cluster groupStartup completed");
                this.setGroupStarting(false);
            }
        }
        return cvEvent;
    }

    boolean isDiscoveryInProgress() {
        return this.discoveryInProgress;
    }

    void setGroupStarting(boolean value) {
        boolean sendMessage = false;
        if (this.groupStarting && !value && this.isMaster() && this.isMasterAssigned()) {
            sendMessage = true;
        }
        this.groupStarting = value;
        this.getGMSContext().setGroupStartup(value);
        if (sendMessage) {
            this.sendGroupStartupComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayedSetGroupStarting(boolean value, long delaySet) {
        Timer timer = this.timer;
        synchronized (timer) {
            if (this.groupStartingTask != null) {
                this.groupStartingTask.cancel();
            }
            this.groupStartingTask = new DelayedSetGroupStartingCompleteTask(delaySet);
            this.timer.schedule((TimerTask)this.groupStartingTask, delaySet);
        }
    }

    public boolean isGroupStartup() {
        return this.groupStarting;
    }

    void groupStartup(GMSConstants.groupStartupState startupState, List<String> memberTokens) {
        StringBuilder sb = new StringBuilder();
        this.groupStartingMembers = memberTokens;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("MasterNode:groupStartup: memebrTokens:" + memberTokens + " startupState:" + startupState);
        }
        switch (startupState) {
            case INITIATED: {
                this.setGroupStarting(true);
                this.groupMembers = new TreeSet<String>(memberTokens);
                this.getGMSContext().setGroupStartupJoinMembers(new TreeSet<String>(memberTokens));
                sb.append(" Starting Members: ");
                this.pendingGroupStartupMembers = new ConcurrentHashMap();
                for (String member : memberTokens) {
                    this.pendingGroupStartupMembers.put(member, member);
                }
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.fine("groupStartup: pendingGroupStartupMembers:" + this.pendingGroupStartupMembers.size() + " members:" + this.pendingGroupStartupMembers.keySet() + " members passed in:" + memberTokens);
                break;
            }
            case COMPLETED_FAILED: {
                this.setGroupStarting(false);
                sb.append(" Failed Members: ");
                if (!this.isMaster() || !this.isMasterAssigned()) break;
                this.sendGroupStartupComplete();
                break;
            }
            case COMPLETED_SUCCESS: {
                if (this.pendingGroupStartupMembers.size() == 0) {
                    this.setGroupStarting(false);
                }
                sb.append(" Started Members: ");
            }
        }
        for (String member : memberTokens) {
            sb.append(member).append(",");
        }
        LOG.log(Level.INFO, "mgmt.masternode.groupstartcomplete", new Object[]{this.getGMSContext().getGroupName(), startupState.toString(), sb.toString()});
    }

    private GMSContext getGMSContext() {
        if (this.ctx == null) {
            this.ctx = GMSContextFactory.getGMSContext(this.manager.getGroupName());
        }
        return this.ctx;
    }

    private void reliableBroadcastSend(Message msg) {
        if (this.reliableMulticast != null) {
            try {
                this.reliableMulticast.broadcast(msg);
            }
            catch (IOException ioe) {
                if (mcastLogger.isLoggable(Level.FINE)) {
                    mcastLogger.log(Level.FINE, "unexpected exception in reliablceBroadcastSend", ioe);
                }
            }
        } else {
            this.send(null, null, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChangeEventsExpirations() {
        TreeSet<ProcessedMasterViewId> treeSet = this.processedChangeEvents;
        synchronized (treeSet) {
            Iterator<ProcessedMasterViewId> iter = this.processedChangeEvents.descendingIterator();
            if (iter.hasNext()) {
                iter.next();
            }
            while (iter.hasNext()) {
                ProcessedMasterViewId current = iter.next();
                if (!current.isExpired()) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearChangeEventsNotFromCurrentMaster(PeerID currentMaster) {
        TreeSet<ProcessedMasterViewId> treeSet = this.processedChangeEvents;
        synchronized (treeSet) {
            Iterator<ProcessedMasterViewId> iter = this.processedChangeEvents.iterator();
            while (iter.hasNext()) {
                ProcessedMasterViewId current = iter.next();
                if (current.master.equals(currentMaster)) continue;
                if (mcastLogger.isLoggable(Level.FINE)) {
                    mcastLogger.log(Level.FINE, "expire due to new master: drop history of processing past master change event " + current + " due to new master:" + currentMaster);
                }
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> checkForMissedMasterChangeEvents(PeerID master, long latestMasterViewID) {
        LinkedList<Long> missed = new LinkedList<Long>();
        PeerID masterId = this.getMasterNodeID();
        ProcessedMasterViewId current2 = null;
        if (this.isMasterAssigned() && masterId != null && masterId.equals(master)) {
            boolean entered = false;
            if (this.lastCheckedMaster == null || this.lastCheckedMasterViewID != latestMasterViewID) {
                entered = true;
                if (mcastLogger.isLoggable(DEBUG_TRACE)) {
                    mcastLogger.log(DEBUG_TRACE, "enter checkForMissedMasterChangeEvents master:" + master.getInstanceName() + " latestMasterViewSeqID=" + latestMasterViewID);
                }
            }
            long validateIdx = -1L;
            TreeSet<ProcessedMasterViewId> treeSet = this.processedChangeEvents;
            synchronized (treeSet) {
                NavigableSet<ProcessedMasterViewId> tailToProcess;
                if (this.lastCheckedMasterViewID == -1L) {
                    tailToProcess = this.processedChangeEvents;
                    try {
                        validateIdx = this.processedChangeEvents.first().masterViewIdSeq;
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else {
                    boolean INCLUSIVE_FALSE = false;
                    ProcessedMasterViewId lastProcessed = new ProcessedMasterViewId(master, this.lastCheckedMasterViewID);
                    tailToProcess = this.processedChangeEvents.tailSet(lastProcessed, false);
                    validateIdx = this.lastCheckedMasterViewID + 1L;
                }
                for (ProcessedMasterViewId current2 : tailToProcess) {
                    if (current2.masterViewIdSeq > latestMasterViewID) break;
                    if (mcastLogger.isLoggable(DEBUG_TRACE)) {
                        mcastLogger.log(DEBUG_TRACE, "processedMasterViewID=" + current2 + " validateIdx=" + validateIdx);
                    }
                    if (validateIdx == current2.masterViewIdSeq) {
                        ++validateIdx;
                        continue;
                    }
                    if (validateIdx > current2.masterViewIdSeq) {
                        if (!mcastLogger.isLoggable(Level.FINER)) continue;
                        mcastLogger.log(Level.FINER, "skipping:  validateIdx=" + validateIdx + " greater than current.masterViewIdSeq:" + current2.masterViewIdSeq + " lastCheckedMasterViewID:" + this.lastCheckedMasterViewID);
                        continue;
                    }
                    while (validateIdx < current2.masterViewIdSeq) {
                        if (mcastLogger.isLoggable(DEBUG_TRACE)) {
                            mcastLogger.fine("first add validateIdx=" + validateIdx + " current.masterViewIdSeq=" + current2.masterViewIdSeq);
                        }
                        missed.add(validateIdx);
                        ++validateIdx;
                    }
                    ++validateIdx;
                }
            }
            if (validateIdx != -1L) {
                while (validateIdx <= latestMasterViewID) {
                    missed.add(validateIdx);
                    if (mcastLogger.isLoggable(DEBUG_TRACE)) {
                        mcastLogger.fine("after add validateIdx=" + validateIdx + " latestMasterViewID=" + latestMasterViewID + " last processed=" + current2);
                    }
                    ++validateIdx;
                }
            }
            this.lastCheckedMaster = master;
            if (validateIdx != -1L) {
                this.lastCheckedMasterViewID = latestMasterViewID;
            }
            if (entered) {
                if (missed.size() > 0) {
                    if (mcastLogger.isLoggable(Level.FINE)) {
                        mcastLogger.log(Level.FINE, "mgmt.masternode.missed.change.events", new Object[]{master.getInstanceName(), latestMasterViewID, missed, this.lastCheckedMasterViewID});
                    }
                } else if (mcastLogger.isLoggable(DEBUG_TRACE)) {
                    mcastLogger.log(DEBUG_TRACE, "exit checkForMissedMasterChangeEvents master:" + master.getInstanceName() + " latestMasterViewSeqID=" + latestMasterViewID + " lastCheckedMasterViewID:" + this.lastCheckedMasterViewID);
                }
            }
        }
        return missed;
    }

    public void sendResendRequest(PeerID master, List<Long> missed) {
        Message msg = this.createResendRequest(master, missed);
        this.send(master, null, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaster(SystemAdvertisement adv, boolean notify) {
        boolean newMaster = false;
        MasterNode masterNode = this;
        synchronized (masterNode) {
            newMaster = this.clusterViewManager.setMaster(adv, notify);
            this.masterAssigned = true;
        }
        if (masterLogger.isLoggable(Level.FINE)) {
            masterLogger.log(Level.FINE, "setMaster isNewMaster=" + newMaster + " master=" + adv.getName() + " newMaster=" + newMaster);
        }
        if (newMaster) {
            this.lastCheckedMasterViewID = -1L;
            this.lastCheckedMaster = null;
            this.clearChangeEventsNotFromCurrentMaster(adv.getID());
        }
    }

    void addMasterViewSeqId(Message msg) {
        if (this.isMaster() && this.isMasterAssigned() && !this.isDiscoveryInProgress()) {
            msg.addMessageElement(LATESTMASTERVIEWID, Long.valueOf(this.getMasterViewID()));
        }
    }

    void processForLatestMasterViewId(Message msg, PeerID source) {
        if (!this.isMaster() && this.masterAssigned && !this.isDiscoveryInProgress()) {
            Object element = msg.getMessageElement(LATESTMASTERVIEWID);
            if (element != null && element instanceof Long) {
                this.checkForMissedMasterMsgSingletonExecutor.submit(new CheckForMissedMasterMessages(this, source, (Long)element));
            }
        }
    }

    static long getMasterViewSequenceID(Message msg) {
        long result = -1L;
        Object value = msg.getMessageElement(MASTERVIEWSEQ);
        if (value instanceof Long) {
            result = (Long)value;
        }
        return result;
    }

    private static class CheckForMissedMasterMessages
    implements Runnable {
        private final PeerID master;
        private final long masterViewSeqId;
        private final MasterNode masterNode;
        private static final long EXPIRE_REAPER_FREQUENCY_MS = 20000L;
        private long nextExpireReaperTime;

        CheckForMissedMasterMessages(MasterNode masterNode, PeerID master, long masterViewSeqId) {
            this.masterNode = masterNode;
            this.master = master;
            this.masterViewSeqId = masterViewSeqId;
            this.nextExpireReaperTime = System.currentTimeMillis() + 20000L;
        }

        @Override
        public void run() {
            long currentTime;
            List<Long> missed;
            if (!this.masterNode.isMaster() && this.masterNode.isMasterAssigned() && (missed = this.masterNode.checkForMissedMasterChangeEvents(this.master, this.masterViewSeqId)).size() > 0) {
                this.masterNode.sendResendRequest(this.master, missed);
            }
            if ((currentTime = System.currentTimeMillis()) > this.nextExpireReaperTime) {
                this.masterNode.processChangeEventsExpirations();
                this.nextExpireReaperTime = currentTime + 20000L;
            }
        }
    }

    public static class ProcessedMasterViewId
    implements Comparable {
        public final PeerID master;
        public final long masterViewIdSeq;
        public final long receivedTime;
        public final long expirationTime;
        public static final long EXPIRATION_DURATION_MS = 30000L;

        public String toString() {
            return "ProcessedMasterViewId master:" + this.master.getInstanceName() + " masterViewSequenceID=" + this.masterViewIdSeq + " receivedTime=" + new Date(this.receivedTime);
        }

        public ProcessedMasterViewId(PeerID master, long seqId) {
            this(master, seqId, 30000L);
        }

        public ProcessedMasterViewId(PeerID master, long seqId, long expire_duration_ms) {
            this.master = master;
            this.masterViewIdSeq = seqId;
            this.receivedTime = System.currentTimeMillis();
            this.expirationTime = this.receivedTime + expire_duration_ms;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expirationTime;
        }

        public int compareTo(Object o) {
            if (o instanceof ProcessedMasterViewId) {
                ProcessedMasterViewId e = (ProcessedMasterViewId)o;
                int result = this.master.compareTo(e.master);
                if (result == 0) {
                    result = (int)(this.masterViewIdSeq - e.masterViewIdSeq);
                }
                return result;
            }
            throw new IllegalArgumentException();
        }

        public int hashCode() {
            int result = this.master != null ? this.master.hashCode() : 0;
            result = 31 * result + (int)(this.masterViewIdSeq ^ this.masterViewIdSeq >>> 32);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessedMasterViewId that = (ProcessedMasterViewId)o;
            if (this.masterViewIdSeq != that.masterViewIdSeq) {
                return false;
            }
            return !(this.master != null ? !this.master.equals(that.master) : that.master != null);
        }
    }

    public class ProcessOutstandingMessagesTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (MasterNode.this.manager != null && !MasterNode.this.manager.isStopping()) {
                MasterNodeMessageEvent msg = null;
                try {
                    SortedSet sortedSet = MasterNode.this.outstandingMasterNodeMessages;
                    synchronized (sortedSet) {
                        if (MasterNode.this.outstandingMasterNodeMessages.size() > 0) {
                            msg = (MasterNodeMessageEvent)MasterNode.this.outstandingMasterNodeMessages.first();
                            if (msg != null) {
                                MasterNode.this.outstandingMasterNodeMessages.remove(msg);
                            }
                        } else {
                            MasterNode.this.outstandingMasterNodeMessages.wait();
                        }
                    }
                    if (msg == null) continue;
                    MasterNode.this.processNextMessageEvent(msg);
                    if (!MasterNode.this.isDiscoveryInProgress() && MasterNode.this.isMaster()) continue;
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "mgmt.masternode.processmsgexception", new Object[]{t.getLocalizedMessage()});
                    LOG.log(Level.WARNING, "stack trace", t);
                }
            }
            LOG.log(Level.CONFIG, "mgmt.masternode.processmsgcompleted", new Object[]{MasterNode.this.instanceName, MasterNode.this.groupName, MasterNode.this.outstandingMasterNodeMessages.size()});
        }
    }

    public static class MasterNodeMessageEvent
    implements Comparable {
        public final long seqId;
        public final Message msg;
        public final MessageEvent event;

        public MasterNodeMessageEvent(MessageEvent event) {
            this.event = event;
            this.msg = event.getMessage();
            this.seqId = MasterNode.getLongFromMessage(this.msg, MasterNode.NAMESPACE, MasterNode.MASTERVIEWSEQ);
        }

        public int compareTo(Object o) {
            if (o instanceof MasterNodeMessageEvent) {
                MasterNodeMessageEvent e = (MasterNodeMessageEvent)o;
                int peerCompareToResult = this.event.getSourcePeerID().compareTo(e.event.getSourcePeerID());
                if (peerCompareToResult != 0) {
                    return peerCompareToResult;
                }
                return (int)(this.seqId - ((MasterNodeMessageEvent)o).seqId);
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            StringBuilder result = new StringBuilder(100);
            try {
                if (this.seqId != -1L) {
                    result.append("masterViewSeqId:").append(this.seqId);
                }
                Object msgElement = this.msg.getMessageElement(MasterNode.NODEADV);
                String fromInstance = "";
                if (msgElement != null && msgElement instanceof SystemAdvertisement) {
                    fromInstance = ((SystemAdvertisement)msgElement).getName();
                }
                for (Map.Entry<String, Serializable> entry : this.msg.getMessageElements()) {
                    String key = entry.getKey();
                    if (key.equals(MasterNode.VIEW_CHANGE_EVENT)) {
                        if (entry.getValue() == null || !(entry.getValue() instanceof ClusterViewEvent)) continue;
                        ClusterViewEvent cvEvent = (ClusterViewEvent)entry.getValue();
                        result.append(" ViewChangeEvent: ").append(cvEvent.getEvent().toString());
                        continue;
                    }
                    if (key.equals(MasterNode.MASTERQUERY)) {
                        result.append("masterquery").append(" from ").append(fromInstance);
                        continue;
                    }
                    if (key.equals(MasterNode.NODEQUERY)) {
                        result.append("nodequery").append(" from ").append(fromInstance);
                        continue;
                    }
                    if (key.equals(MasterNode.MASTERNODERESPONSE)) {
                        result.append("masternoderesponse").append(" from ").append(fromInstance);
                        continue;
                    }
                    if (!key.equals(MasterNode.NODERESPONSE)) continue;
                    result.append("noderesponse").append(" from ").append(fromInstance);
                }
                msgElement = this.msg.getMessageElement(MasterNode.AMASTERVIEW);
                if (msgElement != null && msgElement instanceof List) {
                    result.append(" masterview: size:");
                    List newLocalView = (List)msgElement;
                    result.append(newLocalView.size());
                    for (SystemAdvertisement adv : newLocalView) {
                        result.append(" ").append(adv.getName());
                    }
                } else {
                    result.append(0);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return result.toString();
        }
    }

    class DelayedSetGroupStartingCompleteTask
    extends TimerTask {
        private final long delay;

        public DelayedSetGroupStartingCompleteTask(long delay) {
            this.delay = delay;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("GroupStartupCompleteTask scheduled in " + delay + " ms");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.delay == 600000L) {
                LOG.log(Level.WARNING, "mgmt.masternode.missgroupstartupcomplete", new Object[]{600L});
            }
            Timer timer = MasterNode.this.timer;
            synchronized (timer) {
                MasterNode.this.setGroupStarting(false);
                MasterNode.this.groupStartingTask = null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Received GroupStartupComplete for group:" + MasterNode.this.manager.getGroupName() + " delay(ms)=" + this.delay);
            }
        }
    }
}

