/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.criteria.Selection;
import java.lang.reflect.Constructor;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.queries.ConstructorReportItem;

public class ConstructorSelectionImpl
extends CompoundSelectionImpl {
    protected transient Constructor constructor;
    protected Class[] constructorArgTypes;

    public ConstructorSelectionImpl(Class javaType, Selection[] subSelections) {
        super(javaType, subSelections, true);
    }

    public ConstructorReportItem translate() {
        ConstructorReportItem item = new ConstructorReportItem(this.getAlias());
        item.setResultType(this.getJavaType());
        item.setConstructor(this.constructor);
        for (Selection<?> selection : this.getCompoundSelectionItems()) {
            if (((SelectionImpl)selection).isCompoundSelection()) {
                item.addItem((ReportItem)((ConstructorSelectionImpl)selection).translate());
                continue;
            }
            ReportItem reportItem = new ReportItem(item.getName() + item.getReportItems().size(), ((SelectionImpl)selection).getCurrentNode());
            reportItem.setResultType(selection.getJavaType());
            item.addItem(reportItem);
        }
        return item;
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public void setConstructorArgTypes(Class[] constructorArgTypes) {
        this.constructorArgTypes = constructorArgTypes;
    }
}

