/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Enumeration;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="list-file-groups")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.file.group")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=SecurityService.class, opType=RestEndpoint.OpType.GET, path="list-file-groups", description="list-file-groups")})
public class ListFileGroup
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListFileGroup.class);
    @Param(name="authrealmname", optional=true)
    private String authRealmName;
    @Param(name="name", optional=true)
    private String fileUserName;
    @Param(name="target", primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    private Domain domain;
    @Inject
    private RealmsManager realmsManager;
    @AccessRequired.To(value={"read"})
    private AuthRealm fileAuthRealm;
    private SecurityService securityService;

    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.domain, this.target, context.getActionReport());
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        this.fileAuthRealm = CLIUtil.findRealm(this.securityService, this.authRealmName);
        if (this.fileAuthRealm == null) {
            ActionReport report = context.getActionReport();
            report.setMessage(localStrings.getLocalString("list.file.group.filerealmnotfound", "File realm {0} does not exist", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        this.authRealmName = this.fileAuthRealm.getName();
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            FileRealm fr = this.getFileRealm(this.securityService, this.fileAuthRealm, report);
            if (fr == null) {
                return;
            }
            Enumeration groups = null;
            if (this.fileUserName != null) {
                fr.getUser(this.fileUserName);
                groups = fr.getGroupNames(this.fileUserName);
            } else {
                groups = fr.getGroupNames();
            }
            report.getTopMessagePart().setMessage(localStrings.getLocalString("list.file.group.success", "list-file-groups successful"));
            report.getTopMessagePart().setChildrenType("file-group");
            while (groups.hasMoreElements()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage((String)groups.nextElement());
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (BadRealmException e) {
            report.setMessage(localStrings.getLocalString("list.file.group.realmcorrupted", "Configured file realm {0} is corrupted.", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        catch (NoSuchUserException e) {
            report.setMessage(localStrings.getLocalString("list.file.group.usernotfound", "Specified file user {0} not found.", new Object[]{this.fileUserName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private FileRealm getFileRealm(SecurityService securityService, AuthRealm fileAuthRealm, ActionReport report) {
        String fileRealmClassName = fileAuthRealm.getClassname();
        if (fileRealmClassName != null && !fileRealmClassName.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            report.setMessage(localStrings.getLocalString("list.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{fileRealmClassName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        String keyFile = null;
        for (Property fileProp : fileAuthRealm.getProperty()) {
            if (!fileProp.getName().equals("file")) continue;
            keyFile = fileProp.getValue();
        }
        if (keyFile == null) {
            report.setMessage(localStrings.getLocalString("list.file.user.keyfilenotfound", "There is no physical file associated with this file realm {0} ", new Object[]{this.authRealmName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return null;
        }
        FileRealm fr = null;
        try {
            this.realmsManager.createRealms(this.config);
            fr = (FileRealm)this.realmsManager.getFromLoadedRealms(this.config.getName(), this.authRealmName);
            if (fr == null) {
                throw new NoSuchRealmException(this.authRealmName);
            }
        }
        catch (NoSuchRealmException e) {
            report.setMessage(localStrings.getLocalString("list.file.user.realmnotsupported", "Configured file realm {0} is not supported.", new Object[]{this.authRealmName}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
        return fr;
    }
}

