/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbcruntime;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeExtension;
import com.sun.enterprise.connectors.DeferredResourceConfig;
import com.sun.enterprise.connectors.util.ClassLoadingUtility;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.jdbc.deployer.DataSourceDefinitionDeployer;
import org.glassfish.jdbcruntime.service.JdbcDataSource;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;

@Service
public class JdbcRuntimeExtension
implements ConnectorRuntimeExtension {
    @Inject
    private Provider<Domain> domainProvider;
    @Inject
    private Provider<DataSourceDefinitionDeployer> dataSourceDefinitionDeployerProvider;
    protected static final Logger logger = LogDomains.getLogger(JdbcRuntimeExtension.class, (String)"javax.enterprise.resource.resourceadapter");
    protected ConnectorRuntime runtime = ConnectorRuntime.getRuntime();

    @Override
    public Collection<Resource> getAllSystemRAResourcesAndPools() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Domain domain = (Domain)this.domainProvider.get();
        if (domain != null) {
            Resources allResources = domain.getResources();
            for (Resource resource : allResources.getResources()) {
                if (resource instanceof JdbcConnectionPool) {
                    resources.add(resource);
                    continue;
                }
                if (!(resource instanceof JdbcResource)) continue;
                resources.add(resource);
            }
        }
        System.out.println("JdbcRuntimeExtension,  getAllSystemRAResourcesAndPools = " + resources);
        return resources;
    }

    @Override
    public void registerDataSourceDefinitions(Application application) {
        ((DataSourceDefinitionDeployer)this.dataSourceDefinitionDeployerProvider.get()).registerDataSourceDefinitions(application);
    }

    @Override
    public void unRegisterDataSourceDefinitions(Application application) {
        ((DataSourceDefinitionDeployer)this.dataSourceDefinitionDeployerProvider.get()).unRegisterDataSourceDefinitions(application);
    }

    @Override
    public Object lookupDataSourceInDAS(ResourceInfo resourceInfo) throws ConnectorRuntimeException {
        JdbcDataSource myDS = new JdbcDataSource();
        myDS.setResourceInfo(resourceInfo);
        return myDS;
    }

    @Override
    public PoolInfo getPoolNameFromResourceJndiName(ResourceInfo resourceInfo) {
        String suffix;
        PoolInfo poolInfo = null;
        JdbcResource jdbcResource = null;
        String jndiName = resourceInfo.getName();
        ResourceInfo actualResourceInfo = new ResourceInfo(jndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
        jdbcResource = (JdbcResource)ConnectorsUtil.getResourceByName((Resources)runtime.getResources(actualResourceInfo), JdbcResource.class, (String)actualResourceInfo.getName());
        if (jdbcResource == null && (suffix = ConnectorsUtil.getValidSuffix((String)jndiName)) != null) {
            jndiName = jndiName.substring(0, jndiName.lastIndexOf(suffix));
            actualResourceInfo = new ResourceInfo(jndiName, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
        }
        if ((jdbcResource = (JdbcResource)ConnectorsUtil.getResourceByName((Resources)runtime.getResources(actualResourceInfo), JdbcResource.class, (String)actualResourceInfo.getName())) != null && logger.isLoggable(Level.FINE)) {
            logger.fine("jdbcRes is ---: " + jdbcResource.getJndiName());
            logger.fine("poolName is ---: " + jdbcResource.getPoolName());
        }
        if (jdbcResource != null) {
            poolInfo = new PoolInfo(jdbcResource.getPoolName(), actualResourceInfo.getApplicationName(), actualResourceInfo.getModuleName());
        }
        return poolInfo;
    }

    @Override
    public boolean isConnectionPoolReferredInServerInstance(PoolInfo poolInfo) {
        Collection jdbcResources = ConnectorRuntime.getRuntime().getResources(poolInfo).getResources(JdbcResource.class);
        for (JdbcResource resource : jdbcResources) {
            ResourceInfo resourceInfo = ConnectorsUtil.getResourceInfo((BindableResource)resource);
            if (!resource.getPoolName().equalsIgnoreCase(poolInfo.getName()) || !ResourcesUtil.createInstance().isReferenced(resourceInfo) || !ResourcesUtil.createInstance().isEnabled((BindableResource)resource)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("pool " + poolInfo + "resource " + resourceInfo + " referred is referenced by this server");
                logger.fine("JDBC resource " + resource.getJndiName() + "refers " + poolInfo + "in this server instance and is enabled");
            }
            return true;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("No JDBC resource refers [ " + poolInfo + " ] in this server instance");
        }
        return false;
    }

    @Override
    public String getResourceType(ConfigBeanProxy cb) {
        if (cb instanceof JdbcConnectionPool) {
            return "jcp";
        }
        if (cb instanceof JdbcResource) {
            return "jdbc";
        }
        return null;
    }

    @Override
    public DeferredResourceConfig getDeferredResourceConfig(Object resource, Object pool, String resType, String raName) throws ConnectorRuntimeException {
        DeferredResourceConfig resConfig = null;
        if (!(resource instanceof JdbcResource) && !(pool instanceof JdbcConnectionPool)) {
            throw new ConnectorRuntimeException("unsupported resource type : " + resource);
        }
        JdbcConnectionPool jdbcPool = (JdbcConnectionPool)pool;
        JdbcResource jdbcResource = (JdbcResource)resource;
        String resourceAdapterName = this.getRANameofJdbcConnectionPool((JdbcConnectionPool)pool);
        resConfig = new DeferredResourceConfig(resourceAdapterName, null, (ResourcePool)jdbcPool, (BindableResource)jdbcResource, null);
        Resource[] resourcesToload = new Resource[]{jdbcPool, jdbcResource};
        resConfig.setResourcesToLoad(resourcesToload);
        return resConfig;
    }

    private String getRANameofJdbcConnectionPool(JdbcConnectionPool pool) {
        String dsRAName = "__ds_jdbc_ra";
        Class clz = null;
        if (pool.getDatasourceClassname() != null && !pool.getDatasourceClassname().isEmpty()) {
            try {
                clz = ClassLoadingUtility.loadClass(pool.getDatasourceClassname());
            }
            catch (ClassNotFoundException cnfe) {
                Object[] params = new Object[]{dsRAName, pool.getName()};
                logger.log(Level.WARNING, "using.default.ds", params);
                return dsRAName;
            }
        }
        if (pool.getDriverClassname() != null && !pool.getDriverClassname().isEmpty()) {
            try {
                clz = ClassLoadingUtility.loadClass(pool.getDriverClassname());
            }
            catch (ClassNotFoundException cnfe) {
                Object[] params = new Object[]{dsRAName, pool.getName()};
                logger.log(Level.WARNING, "using.default.ds", params);
                return dsRAName;
            }
        }
        if (clz != null) {
            if ("javax.sql.XADataSource".equals(pool.getResType()) && XADataSource.class.isAssignableFrom(clz)) {
                return "__xa_jdbc_ra";
            }
            if ("javax.sql.ConnectionPoolDataSource".equals(pool.getResType()) && ConnectionPoolDataSource.class.isAssignableFrom(clz)) {
                return "__cp_jdbc_ra";
            }
            if ("java.sql.Driver".equals(pool.getResType()) && Driver.class.isAssignableFrom(clz)) {
                return "__dm_jdbc_ra";
            }
            if ("javax.sql.DataSource".equals(pool.getResType()) && DataSource.class.isAssignableFrom(clz)) {
                return dsRAName;
            }
        }
        Object[] params = new Object[]{dsRAName, pool.getName()};
        logger.log(Level.WARNING, "using.default.ds", params);
        return dsRAName;
    }
}

