/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.mgbean;

import com.sun.faces.RIConstants;
import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.el.ELUtils;
import com.sun.faces.mgbean.ManagedBeanCreationException;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.mgbean.ManagedBeanPreProcessingException;
import com.sun.faces.mgbean.SharedUtils;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BeanBuilder {
    private static Logger LOGGER = FacesLogger.MANAGEDBEAN.getLogger();
    private List<String> messages;
    private List<String> references;
    private boolean isInjectible;
    private boolean baked;
    private Class<?> beanClass;
    protected final ManagedBeanInfo beanInfo;

    public BeanBuilder(ManagedBeanInfo beanInfo) {
        this.beanInfo = beanInfo;
    }

    public Object build(InjectionProvider injectionProvider, FacesContext context) {
        Object bean = this.newBeanInstance();
        this.injectResources(bean, injectionProvider);
        this.buildBean(bean, context);
        this.invokePostConstruct(bean, injectionProvider);
        return bean;
    }

    public void destroy(InjectionProvider injectionProvider, Object bean) {
        block3: {
            if (this.isInjectible) {
                try {
                    injectionProvider.invokePreDestroy(bean);
                }
                catch (InjectionProviderException ipe) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, ipe.getMessage(), ipe);
                }
            }
        }
    }

    public boolean hasMessages() {
        return this.messages != null && !this.messages.isEmpty();
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public String getScope() {
        return this.beanInfo.getScope();
    }

    public boolean isBaked() {
        return this.baked;
    }

    public Map<String, String> getDescriptions() {
        return this.beanInfo.getDescriptions();
    }

    public Class<?> getBeanClass() {
        return this.loadBeanClass();
    }

    public ManagedBeanInfo getManagedBeanInfo() {
        return this.beanInfo;
    }

    protected abstract void buildBean(Object var1, FacesContext var2);

    protected void baked() {
        this.baked = true;
    }

    protected Object newBeanInstance() {
        try {
            return this.loadBeanClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", this.beanInfo.getClassName());
            throw new ManagedBeanCreationException(message, e);
        }
    }

    protected void injectResources(Object bean, InjectionProvider injectionProvider) {
        if (this.isInjectible) {
            try {
                injectionProvider.inject(bean);
            }
            catch (InjectionProviderException ipe) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_INJECTION_ERROR", this.beanInfo.getName());
                throw new ManagedBeanCreationException(message, ipe);
            }
        }
    }

    protected void invokePostConstruct(Object bean, InjectionProvider injectionProvider) {
        if (this.isInjectible) {
            try {
                injectionProvider.invokePostConstruct(bean);
            }
            catch (InjectionProviderException ipe) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_INJECTION_ERROR", this.beanInfo.getName());
                throw new ManagedBeanCreationException(message, ipe);
            }
        }
    }

    protected Class loadClass(String className) {
        Class valueType = String.class;
        if (null != className && 0 < className.length()) {
            if (className.equals(Boolean.TYPE.getName())) {
                valueType = Boolean.TYPE;
            } else if (className.equals(Byte.TYPE.getName())) {
                valueType = Byte.TYPE;
            } else if (className.equals(Double.TYPE.getName())) {
                valueType = Double.TYPE;
            } else if (className.equals(Float.TYPE.getName())) {
                valueType = Float.TYPE;
            } else if (className.equals(Integer.TYPE.getName())) {
                valueType = Integer.TYPE;
            } else if (className.equals(Character.TYPE.getName())) {
                valueType = Character.TYPE;
            } else if (className.equals(Short.TYPE.getName())) {
                valueType = Short.TYPE;
            } else if (className.equals(Long.TYPE.getName())) {
                valueType = Long.TYPE;
            } else {
                try {
                    valueType = Util.loadClass(className, this);
                }
                catch (ClassNotFoundException cnfe) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_NOT_FOUND_ERROR", className, this.beanInfo.getName());
                    throw new ManagedBeanPreProcessingException(message);
                }
                catch (NoClassDefFoundError ncdfe) {
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_DEPENDENCY_NOT_FOUND_ERROR", className, this.beanInfo.getName(), ncdfe.getMessage());
                    throw new ManagedBeanPreProcessingException(message);
                }
            }
        }
        return valueType;
    }

    protected Map<Expression, Expression> getBakedMap(String keyClass, String valueClass, Map<String, String> mapEntries) {
        if (mapEntries == null || mapEntries.isEmpty()) {
            return new LinkedHashMap<Expression, Expression>(4, 1.0f);
        }
        Class keyClazz = this.loadClass(keyClass);
        Class valueClazz = this.loadClass(valueClass);
        LinkedHashMap<Expression, Expression> target = new LinkedHashMap<Expression, Expression>(mapEntries.size(), 1.0f);
        for (Map.Entry<String, String> m : mapEntries.entrySet()) {
            String sk = m.getKey();
            String sv = m.getValue();
            target.put(new Expression(sk, keyClazz), !sv.equals("null_value") ? new Expression(sv, valueClazz) : null);
        }
        return target;
    }

    protected List<Expression> getBakedList(String valueClass, List<String> entries) {
        Class valueClazz = this.loadClass(valueClass);
        ArrayList<Expression> target = new ArrayList<Expression>(entries.size());
        for (String item : entries) {
            target.add(!"null_value".equals(item) ? new Expression(item, valueClazz) : null);
        }
        return target;
    }

    protected void initMap(Map<Expression, Expression> source, Map target, FacesContext context) {
        for (Map.Entry<Expression, Expression> entry : source.entrySet()) {
            Expression k = entry.getKey();
            Expression v = entry.getValue();
            target.put(k.evaluate(context.getELContext()), v != null ? v.evaluate(context.getELContext()) : null);
        }
    }

    protected void initList(List<Expression> source, List target, FacesContext context) {
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            Expression value = source.get(i);
            target.add(value != null ? value.evaluate(context.getELContext()) : null);
        }
    }

    void queueMessage(String message) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>(4);
        }
        this.messages.add(message);
    }

    void queueMessages(List<String> messages) {
        if (this.messages == null) {
            this.messages = messages;
        } else {
            this.messages.addAll(messages);
        }
    }

    void bake() {
        this.loadBeanClass();
        this.validateScope();
    }

    List<String> getReferences() {
        return this.references;
    }

    private Class<?> loadBeanClass() {
        if (this.beanClass == null) {
            String message;
            int classModifiers;
            String className = this.beanInfo.getClassName();
            Class clazz = this.loadClass(className);
            ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
            if (!associate.isDevModeEnabled()) {
                this.beanClass = clazz;
            }
            if (!Modifier.isPublic(classModifiers = clazz.getModifiers())) {
                message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_IS_NOT_PUBLIC_ERROR", className, this.beanInfo.getName());
                this.queueMessage(message);
            }
            if (Modifier.isInterface(classModifiers) || Modifier.isAbstract(classModifiers)) {
                message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_IS_ABSTRACT_ERROR", className, this.beanInfo.getName());
                this.queueMessage(message);
            }
            try {
                Constructor ctor = clazz.getConstructor(RIConstants.EMPTY_CLASS_ARGS);
                if (!Modifier.isPublic(ctor.getModifiers())) {
                    String message2 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_NO_PUBLIC_NOARG_CTOR_ERROR", className, this.beanInfo.getName());
                    this.queueMessage(message2);
                }
            }
            catch (NoSuchMethodException nsme) {
                String message3 = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_CLASS_NO_PUBLIC_NOARG_CTOR_ERROR", className, this.beanInfo.getName());
                this.queueMessage(message3);
            }
            if (!this.hasMessages()) {
                this.isInjectible = Util.classHasAnnotations(clazz);
            }
            return clazz;
        }
        return this.beanClass;
    }

    private void validateScope() {
        String scope = this.beanInfo.getScope();
        if (!ELUtils.isScopeValid(scope) && !SharedUtils.isExpression(scope)) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.MANAGED_BEAN_INVALID_SCOPE", this.beanInfo.getName());
            throw new ManagedBeanPreProcessingException(message);
        }
    }

    protected class Expression {
        private String expressionString;
        private Class<?> expectedType;
        private ValueExpression ve;
        private boolean validateLifespanRuntime = false;
        private String[] segment = new String[1];

        public Expression(String expressionString, Class<?> expectedType) {
            this.expressionString = expressionString;
            this.expectedType = expectedType;
            if (SharedUtils.isExpression(this.expressionString)) {
                List<String> expressions = ELUtils.getExpressionsFromString(this.expressionString);
                if (!expressions.isEmpty()) {
                    for (String expression : expressions) {
                        ELUtils.getScope(expression, this.segment);
                        if (this.segment[0] != null) {
                            if (BeanBuilder.this.references == null) {
                                BeanBuilder.this.references = new ArrayList(4);
                            }
                            if (!BeanBuilder.this.references.contains(this.segment[0])) {
                                BeanBuilder.this.references.add(this.segment[0]);
                            }
                        }
                        this.segment[0] = null;
                    }
                }
                if (!SharedUtils.isExpression(BeanBuilder.this.beanInfo.getScope())) {
                    ELUtils.Scope expressionScope = ELUtils.getNarrowestScopeFromExpression(this.expressionString);
                    if (expressionScope != null) {
                        this.validateLifespan(expressionScope, this.validateLifespanRuntime);
                    } else {
                        this.validateLifespanRuntime = true;
                    }
                }
            } else if (this.expressionString != null) {
                this.expressionString = "#{\"" + this.expressionString.replaceAll("[\\\\\"]", "\\\\$0") + "\"}";
            }
        }

        public Object evaluate(ELContext context) {
            if (this.expressionString == null) {
                return null;
            }
            if (this.validateLifespanRuntime) {
                ELUtils.Scope expScope = ELUtils.getScope(this.expressionString, this.segment);
                this.validateLifespan(expScope, true);
            }
            if (this.ve == null) {
                ValueExpression valueExpression = this.ve = this.expectedType.isPrimitive() ? ELUtils.createValueExpression(this.expressionString, this.expectedType) : ELUtils.createValueExpression(this.expressionString, Object.class);
            }
            if (this.expectedType.isPrimitive()) {
                return this.ve.getValue(context);
            }
            Object tmpval = this.ve.getValue(context);
            return tmpval != null ? ELUtils.coerce(tmpval, this.expectedType) : null;
        }

        private void validateLifespan(ELUtils.Scope expressionScope, boolean runtime) {
            if (ELUtils.isScopeValid(BeanBuilder.this.beanInfo.getScope()) && !ELUtils.hasValidLifespan(expressionScope, ELUtils.getScope(BeanBuilder.this.beanInfo.getScope()))) {
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.INVALID_SCOPE_LIFESPAN", new Object[]{this.expressionString, expressionScope, BeanBuilder.this.beanInfo.getName(), BeanBuilder.this.beanInfo.getScope()});
                if (runtime) {
                    throw new ManagedBeanCreationException(message);
                }
                BeanBuilder.this.queueMessage(message);
            }
        }
    }
}

