/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.common;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceSpec;
import com.sun.gjc.util.MethodExecutor;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;

public class DataSourceObjectBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = LogDomains.getLogger(MethodExecutor.class, (String)"javax.enterprise.resource.resourceadapter");
    private static final StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);
    private DataSourceSpec spec;
    private MethodExecutor executor;

    public DataSourceObjectBuilder(DataSourceSpec spec) {
        this.spec = spec;
        this.executor = new MethodExecutor();
    }

    public Object constructDataSourceObject() throws ResourceException {
        Map<String, List<String>> driverProperties = this.parseDriverProperties(this.spec, true);
        Object dataSourceObject = this.getDataSourceObject();
        for (Method method : dataSourceObject.getClass().getMethods()) {
            String methodName = method.getName();
            if (driverProperties.containsKey(methodName.toUpperCase(Locale.getDefault()))) {
                this.executor.runMethod(method, dataSourceObject, driverProperties.get(methodName.toUpperCase(Locale.getDefault())));
                continue;
            }
            if (methodName.equalsIgnoreCase("setUser")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(1), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setPassword")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(2), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setLoginTimeOut")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(4), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setLogWriter")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(5), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setDatabaseName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(6), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setDataSourceName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(7), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setDescription")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(8), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setNetworkProtocol")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(9), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setPortNumber")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(10), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setRoleName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(11), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setServerName")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(12), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMaxStatements")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(13), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setInitialPoolSize")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(14), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMinPoolSize")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(15), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMaxPoolSize")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(16), method, dataSourceObject);
                continue;
            }
            if (methodName.equalsIgnoreCase("setMaxIdleTime")) {
                this.executor.runJavaBeanMethod(this.spec.getDetail(17), method, dataSourceObject);
                continue;
            }
            if (!methodName.equalsIgnoreCase("setPropertyCycle")) continue;
            this.executor.runJavaBeanMethod(this.spec.getDetail(18), method, dataSourceObject);
        }
        return dataSourceObject;
    }

    public Map<String, List<String>> parseDriverProperties(DataSourceSpec spec, boolean returnUpperCase) throws ResourceException {
        String delim = spec.getDetail(21);
        String escape = spec.getDetail(33);
        String prop = spec.getDetail(19);
        if (prop == null || prop.trim().equals("")) {
            return new HashMap<String, List<String>>();
        }
        if (delim == null || delim.equals("")) {
            throw new ResourceException(sm.getString("dsob.delim_not_specified"));
        }
        if (escape == null || escape.equals("")) {
            throw new ResourceException(sm.getString("dsob.escape_char_not_specified"));
        }
        return this.parseDriverProperties(prop, escape, delim, returnUpperCase);
    }

    public Map<String, List<String>> parseDriverProperties(String values, String escape, String delimiter, boolean returnUpperCase) {
        HashMap<String, List<String>> parsedDriverProperties = new HashMap<String, List<String>>();
        Object parsedValue = "";
        Object name = "";
        char escapeChar = escape.charAt(0);
        char delimiterChar = delimiter.charAt(0);
        while (values.length() > 0) {
            if (values.charAt(0) == delimiterChar) {
                if (values.length() > 1 && values.charAt(1) == delimiterChar) {
                    if (values.length() > 2 && values.charAt(2) == delimiterChar) {
                        name = returnUpperCase ? ((String)parsedValue).toUpperCase(Locale.getDefault()) : parsedValue;
                        parsedValue = "";
                    }
                    parsedDriverProperties.put((String)name, Arrays.asList(parsedValue));
                    parsedValue = "";
                    values = values.substring(2);
                    continue;
                }
                name = returnUpperCase ? ((String)parsedValue).toUpperCase(Locale.getDefault()) : parsedValue;
                parsedValue = "";
                values = values.substring(1);
                continue;
            }
            if (values.charAt(0) == escapeChar) {
                if (values.charAt(1) == escapeChar) {
                    parsedValue = (String)parsedValue + values.charAt(1);
                } else if (values.charAt(1) == delimiterChar) {
                    parsedValue = (String)parsedValue + values.charAt(1);
                }
                values = values.substring(2);
                continue;
            }
            if (values.charAt(0) == escapeChar) continue;
            parsedValue = (String)parsedValue + values.charAt(0);
            values = values.substring(1);
        }
        return parsedDriverProperties;
    }

    private Object getDataSourceObject() throws ResourceException {
        String className = this.spec.getDetail(20);
        try {
            Class<?> dataSourceClass;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                dataSourceClass = Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                classLoader = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getCommonClassLoader();
                dataSourceClass = Class.forName(className, true, classLoader);
            }
            return dataSourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_cnfe_ds", cnfe);
            throw new ResourceException(sm.getString("dsob.class_not_found", (Object)className), (Throwable)cnfe);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException ce) {
            _logger.log(Level.SEVERE, "jdbc.exc_inst", className);
            throw new ResourceException(sm.getString("dsob.error_instantiating", (Object)className), (Throwable)ce);
        }
        catch (IllegalAccessException ce) {
            _logger.log(Level.SEVERE, "jdbc.exc_acc_inst", className);
            throw new ResourceException(sm.getString("dsob.access_error", (Object)className), (Throwable)ce);
        }
    }
}

