/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.AppSpecificConnectorClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorClassFinder;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassLoaderService;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
public class ConnectorClassLoaderServiceImpl
implements ConnectorClassLoaderService {
    private volatile DelegatingClassLoader globalConnectorCL;
    @Inject
    private AppSpecificConnectorClassLoaderUtil appsSpecificCCLUtil;
    @Inject
    private Provider<ClassLoaderHierarchy> classLoaderHierarchyProvider;
    private Logger logger = LogDomains.getLogger(ConnectorClassLoaderServiceImpl.class, (String)"javax.enterprise.resource.resourceadapter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DelegatingClassLoader getConnectorClassLoader(String appName) {
        DelegatingClassLoader loader = null;
        if (this.globalConnectorCL == null) {
            Class<ConnectorClassLoaderServiceImpl> clazz = ConnectorClassLoaderServiceImpl.class;
            // MONITORENTER : com.sun.appserv.connectors.internal.api.ConnectorClassLoaderServiceImpl.class
            if (this.globalConnectorCL == null) {
                final ClassLoader parent = this.getCommonClassLoader();
                DelegatingClassLoader gcc = AccessController.doPrivileged(new PrivilegedAction<DelegatingClassLoader>(){

                    @Override
                    public DelegatingClassLoader run() {
                        DelegatingClassLoader dcl = new DelegatingClassLoader(parent);
                        for (DelegatingClassLoader.ClassFinder classFinder : ConnectorClassLoaderServiceImpl.this.appsSpecificCCLUtil.getSystemRARClassLoaders()) {
                            dcl.addDelegate(classFinder);
                        }
                        return dcl;
                    }
                });
                for (DelegatingClassLoader.ClassFinder classFinder : this.appsSpecificCCLUtil.getSystemRARClassLoaders()) {
                    gcc.addDelegate(classFinder);
                }
                this.globalConnectorCL = gcc;
            }
            // MONITOREXIT : clazz
        }
        if (!this.hasGlobalAccessForRARs(appName)) {
            this.appsSpecificCCLUtil.detectReferredRARs(appName);
            return this.createConnectorClassLoaderForApplication(appName);
        }
        if ($assertionsDisabled) return this.globalConnectorCL;
        if (this.globalConnectorCL != null) return this.globalConnectorCL;
        throw new AssertionError();
    }

    private boolean hasGlobalAccessForRARs(String appName) {
        return appName == null || this.appsSpecificCCLUtil.useGlobalConnectorClassLoader() || this.appsSpecificCCLUtil.getRequiredResourceAdapters(appName).contains("*");
    }

    private ClassLoader getCommonClassLoader() {
        return this.classLoaderHierarchyProvider.get().getCommonClassLoader();
    }

    private DelegatingClassLoader createConnectorClassLoaderForApplication(String appName) {
        DelegatingClassLoader appSpecificConnectorClassLoader = new DelegatingClassLoader(this.getCommonClassLoader());
        for (DelegatingClassLoader.ClassFinder classFinder : this.appsSpecificCCLUtil.getSystemRARClassLoaders()) {
            appSpecificConnectorClassLoader.addDelegate(classFinder);
        }
        for (String string : this.appsSpecificCCLUtil.getRARsReferredByApplication(appName)) {
            this.addRarClassLoader(appName, appSpecificConnectorClassLoader, string);
        }
        for (String string : this.appsSpecificCCLUtil.getRequiredResourceAdapters(appName)) {
            this.addRarClassLoader(appName, appSpecificConnectorClassLoader, string);
        }
        return appSpecificConnectorClassLoader;
    }

    private void addRarClassLoader(String appName, DelegatingClassLoader appSpecificConnectorClassLoader, String raName) {
        DelegatingClassLoader.ClassFinder cf;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("raName for app [ " + appName + " ] : " + raName);
        }
        if ((cf = this.getClassFinder(raName)) != null) {
            appSpecificConnectorClassLoader.addDelegate(cf);
        }
    }

    private DelegatingClassLoader.ClassFinder getClassFinder(String raName) {
        List delegates = this.globalConnectorCL.getDelegates();
        DelegatingClassLoader.ClassFinder classFinder = null;
        for (DelegatingClassLoader.ClassFinder cf : delegates) {
            if (!raName.equals(((ConnectorClassFinder)cf).getResourceAdapterName())) continue;
            classFinder = cf;
            break;
        }
        return classFinder;
    }
}

