/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.BasicJAnnotatable;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JComment;
import org.jboss.jdeparser.JMod;
import org.jboss.jdeparser.JParamDeclaration;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

class ImplJParamDeclaration
extends BasicJAnnotatable
implements JParamDeclaration {
    private final JType type;
    private final String name;
    private final int mods;

    ImplJParamDeclaration(int mods, JType type, String name) {
        this.mods = mods;
        this.type = type;
        this.name = name;
    }

    @Override
    public JType type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int mods() {
        return this.mods & 0xFFF;
    }

    @Override
    public boolean varargs() {
        return JMod.allAreSet(this.mods, Integer.MIN_VALUE);
    }

    @Override
    public JComment doc() {
        return null;
    }

    void write(SourceFileWriter writer) throws IOException {
        this.writeComments(writer);
        this.writeAnnotations(writer, FormatPreferences.Space.AFTER_PARAM_ANNOTATION);
        JMod.write(writer, this.mods());
        writer.write(this.type);
        if (this.varargs()) {
            writer.write(Tokens$.PUNCT.DOT);
            writer.write(Tokens$.PUNCT.DOT);
            writer.write(Tokens$.PUNCT.DOT);
        }
        writer.sp();
        writer.writeEscapedWord(this.name);
    }
}

