/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.crypto.dsig.keyinfo.KeyInfo;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.message.GSHeaderElement;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.IssuedTokenKeyBinding;
import com.sun.xml.wss.impl.policy.mls.KeyBindingBase;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import jakarta.xml.bind.JAXBElement;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Element;

public class IssuedTokenBuilder
extends TokenBuilder {
    private IssuedTokenKeyBinding ikb = null;

    public IssuedTokenBuilder(JAXBFilterProcessingContext context, IssuedTokenKeyBinding kb) {
        super(context);
        this.ikb = kb;
    }

    @Override
    public BuilderResult process() throws XWSSecurityException {
        String itType;
        BuilderResult itkbResult = new BuilderResult();
        byte[] proofKey = this.context.getTrustContext().getProofKey();
        Key dataProtectionKey = null;
        SecurityTokenReferenceType str = null;
        Key cacheKey = null;
        if (proofKey == null) {
            KeyPair keyPair = this.context.getTrustContext().getProofKeyPair();
            if (keyPair == null) {
                X509Certificate cert = this.context.getTrustContext().getRequestorCertificate();
                if (cert == null) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1823_KEY_PAIR_PROOF_KEY_NULL_ISSUEDTOKEN());
                    throw new XWSSecurityException("Proof Key and RSA KeyPair for Supporting token (KeyValueToken or RsaToken) are both null for Issued Token");
                }
                dataProtectionKey = this.context.getSecurityEnvironment().getPrivateKey(this.context.getExtraneousProperties(), cert);
                cacheKey = cert.getPublicKey();
            } else {
                dataProtectionKey = keyPair.getPrivate();
                cacheKey = keyPair.getPublic();
            }
        } else {
            String secretKeyAlg = "AES";
            if (this.context.getAlgorithmSuite() != null) {
                secretKeyAlg = SecurityUtil.getSecretKeyAlgorithm(this.context.getAlgorithmSuite().getEncryptionAlgorithm());
            }
            dataProtectionKey = new SecretKeySpec(proofKey, secretKeyAlg);
            cacheKey = dataProtectionKey;
        }
        SecurityHeaderElement issuedTokenElement = null;
        GenericToken issuedToken = (GenericToken)this.context.getTrustContext().getSecurityToken();
        if (issuedToken != null) {
            String tokId;
            issuedTokenElement = issuedToken.getElement();
            if (issuedTokenElement == null) {
                Element element = (Element)issuedToken.getTokenValue();
                issuedTokenElement = new GSHeaderElement(element);
                issuedTokenElement.setId(issuedToken.getId());
                itkbResult.setDPTokenId(issuedToken.getId());
            }
            if ("".equals(tokId = issuedTokenElement.getId()) && "EncryptedData".equals(issuedTokenElement.getLocalPart())) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1808_ID_NOTSET_ENCRYPTED_ISSUEDTOKEN());
                throw new XWSSecurityException("ID attribute not set");
            }
            this.context.getTokenCache().put(this.ikb.getUUID(), issuedTokenElement);
            HashMap<String, PrivateKey> sentSamlKeys = (HashMap<String, PrivateKey>)this.context.getExtraneousProperty("stored_saml_keys");
            if (sentSamlKeys == null) {
                sentSamlKeys = new HashMap<String, PrivateKey>();
            }
            sentSamlKeys.put(tokId, (PrivateKey)dataProtectionKey);
            this.context.setExtraneousProperty("stored_saml_keys", sentSamlKeys);
        }
        boolean includeToken = KeyBindingBase.INCLUDE_ALWAYS.equals(itType = this.ikb.getIncludeToken()) || KeyBindingBase.INCLUDE_ALWAYS_TO_RECIPIENT.equals(itType) || KeyBindingBase.INCLUDE_ALWAYS_VER2.equals(itType) || KeyBindingBase.INCLUDE_ALWAYS_TO_RECIPIENT_VER2.equals(itType);
        str = includeToken ? (SecurityTokenReferenceType)((Object)this.context.getTrustContext().getAttachedSecurityTokenReference()) : (SecurityTokenReferenceType)((Object)this.context.getTrustContext().getUnAttachedSecurityTokenReference());
        if (issuedToken != null && includeToken && this.context.getSecurityHeader().getChildElement(issuedTokenElement.getId()) == null) {
            this.context.getSecurityHeader().add(issuedTokenElement);
        }
        ((NamespaceContextEx)this.context.getNamespaceContext()).addWSS11NS();
        this.keyInfo = new KeyInfo();
        JAXBElement<SecurityTokenReferenceType> je = new ObjectFactory().createSecurityTokenReference(str);
        List<JAXBElement<SecurityTokenReferenceType>> strList = Collections.singletonList(je);
        this.keyInfo.setContent(strList);
        if (str != null) {
            SecurityUtil.updateSamlVsKeyCache(str, (FilterProcessingContext)this.context, cacheKey);
        }
        itkbResult.setDataProtectionKey(dataProtectionKey);
        itkbResult.setKeyInfo(this.keyInfo);
        return itkbResult;
    }
}

