/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.uri;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.mvc.MvcContext;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.UriBuilder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.krazo.servlet.KrazoContainerInitializer;
import org.eclipse.krazo.uri.ApplicationUris;
import org.eclipse.krazo.uri.UriTemplate;
import org.eclipse.krazo.util.AnnotationUtils;
import org.eclipse.krazo.util.BeanUtils;
import org.eclipse.krazo.util.ControllerUtils;

@ApplicationScoped
public class UriTemplateParser {
    @Inject
    MvcContext mvcContext;
    @Inject
    private ServletContext servletContext;
    @Produces
    @ApplicationScoped
    private ApplicationUris applicationUris;

    @PostConstruct
    public void init() {
        Set<Class<?>> controllerClasses = (Set<Class<?>>)this.servletContext.getAttribute(KrazoContainerInitializer.CONTROLLER_CLASSES);
        this.applicationUris = this.init(controllerClasses != null ? controllerClasses : Collections.emptySet());
    }

    ApplicationUris init(Set<Class<?>> controllers) {
        ApplicationUris uris = new ApplicationUris();
        controllers.forEach(controller -> Stream.of(controller.getMethods()).filter(ControllerUtils::isControllerMethod).forEach(method -> {
            UriTemplate uriTemplate = this.parseMethod((Method)method, this.mvcContext.getBasePath());
            uris.register(uriTemplate, (Method)method);
        }));
        return uris;
    }

    UriTemplate parseMethod(Method method, String basePath) {
        Path methodPath;
        UriBuilder uriBuilder = UriBuilder.fromPath((String)basePath);
        Path controllerPath = AnnotationUtils.getAnnotation(method.getDeclaringClass(), Path.class);
        if (controllerPath != null) {
            uriBuilder.path(controllerPath.value());
        }
        if ((methodPath = AnnotationUtils.getAnnotation(method, Path.class)) != null) {
            uriBuilder.path(methodPath.value());
        }
        UriTemplate.Builder uriTemplateBuilder = UriTemplate.fromTemplate(uriBuilder.toTemplate());
        List<AnnotatedElement> annotatedElements = BeanUtils.getFieldsAndAccessors(method.getDeclaringClass());
        Arrays.asList(method.getParameters()).forEach(param -> {
            if (param.isAnnotationPresent(BeanParam.class)) {
                annotatedElements.addAll(BeanUtils.getFieldsAndAccessors(param.getType()));
            } else {
                annotatedElements.add((AnnotatedElement)param);
            }
        });
        annotatedElements.forEach(accessibleObject -> {
            if (accessibleObject.isAnnotationPresent(QueryParam.class)) {
                uriTemplateBuilder.queryParam(accessibleObject.getAnnotation(QueryParam.class).value());
            }
            if (accessibleObject.isAnnotationPresent(MatrixParam.class)) {
                uriTemplateBuilder.matrixParam(accessibleObject.getAnnotation(MatrixParam.class).value());
            }
        });
        return uriTemplateBuilder.build();
    }
}

