/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.ssl.InputBufferWrapper;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLConnectionContext;

public final class SSLUtils {
    private static final boolean ANDROID_WORKAROUND_NEEDED;
    private static final int LOLLIPOP_VER = 21;
    private static final String SSL_CONNECTION_CTX_ATTR_NAME;
    static final Attribute<SSLConnectionContext> SSL_CTX_ATTR;
    private static final SSLConnectionContext.Allocator HS_UNWRAP_ALLOCATOR;
    private static final SSLConnectionContext.Allocator HS_WRAP_ALLOCATOR;
    private static final byte CHANGE_CIPHER_SPECT_CONTENT_TYPE = 20;
    private static final byte APPLICATION_DATA_CONTENT_TYPE = 23;
    private static final int SSLV3_RECORD_HEADER_SIZE = 5;
    private static final int SSL20_HELLO_VERSION = 2;
    private static final int MIN_VERSION = 768;
    private static final int MAX_MAJOR_VERSION = 3;
    private static final ThreadCache.CachedTypeIndex<Buffer> SSL_OUTPUT_BUFFER_IDX;

    public static SSLConnectionContext getSslConnectionContext(Connection connection) {
        return SSL_CTX_ATTR.get(connection);
    }

    public static SSLEngine getSSLEngine(Connection connection) {
        SSLConnectionContext sslCtx = SSLUtils.getSslConnectionContext(connection);
        return sslCtx == null ? null : sslCtx.getSslEngine();
    }

    public static void setSSLEngine(Connection connection, SSLEngine sslEngine) {
        SSLConnectionContext ctx = SSLUtils.getSslConnectionContext(connection);
        if (ctx == null) {
            ctx = new SSLConnectionContext(connection);
            SSL_CTX_ATTR.set(connection, ctx);
        }
        ctx.configure(sslEngine);
    }

    public static int getSSLPacketSize(Buffer buf) throws SSLException {
        int len;
        byte byte4;
        byte byte3;
        byte byte2;
        byte byte1;
        byte byte0;
        if (buf.remaining() < 5) {
            return -1;
        }
        if (buf.hasArray()) {
            byte[] array = buf.array();
            int pos = buf.arrayOffset() + buf.position();
            byte0 = array[pos++];
            byte1 = array[pos++];
            byte2 = array[pos++];
            byte3 = array[pos++];
            byte4 = array[pos];
        } else {
            int pos = buf.position();
            byte0 = buf.get(pos++);
            byte1 = buf.get(pos++);
            byte2 = buf.get(pos++);
            byte3 = buf.get(pos++);
            byte4 = buf.get(pos);
        }
        if (byte0 >= 20 && byte0 <= 23) {
            byte major = byte1;
            byte minor = byte2;
            int v = major << 8 | minor & 0xFF;
            if (v < 768 || major > 3) {
                throw new SSLException("Unsupported record version major=" + major + " minor=" + minor);
            }
            len = ((byte3 & 0xFF) << 8) + (byte4 & 0xFF) + 5;
        } else {
            boolean isShort;
            boolean bl = isShort = (byte0 & 0x80) != 0;
            if (isShort && (byte2 == 1 || byte2 == 4)) {
                byte major = byte3;
                byte minor = byte4;
                int v = major << 8 | minor & 0xFF;
                if ((v < 768 || major > 3) && v != 2) {
                    throw new SSLException("Unsupported record version major=" + major + " minor=" + minor);
                }
                int mask = 127;
                len = ((byte0 & mask) << 8) + (byte1 & 0xFF) + 2;
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return len;
    }

    public static void executeDelegatedTask(SSLEngine sslEngine) {
        Runnable runnable;
        while ((runnable = sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    public static boolean isHandshaking(SSLEngine sslEngine) {
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        return handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    public static SSLEngineResult handshakeUnwrap(int length, SSLConnectionContext sslCtx, Buffer inputBuffer, Buffer tmpOutputBuffer) throws SSLException {
        SSLConnectionContext.SslResult result = sslCtx.unwrap(length, inputBuffer, tmpOutputBuffer, HS_UNWRAP_ALLOCATOR);
        Buffer output = result.getOutput();
        assert (!output.isComposite());
        if (output != tmpOutputBuffer) {
            output.dispose();
        }
        if (result.isError()) {
            throw result.getError();
        }
        return result.getSslEngineResult();
    }

    public static Buffer handshakeWrap(Connection connection, SSLConnectionContext sslCtx, Buffer netBuffer) throws SSLException {
        Buffer buffer;
        int packetBufferSize = sslCtx.getNetBufferSize();
        if (netBuffer != null && !netBuffer.isComposite() && netBuffer.capacity() - netBuffer.limit() >= packetBufferSize) {
            netBuffer.position(netBuffer.limit());
            netBuffer.limit(netBuffer.capacity());
            buffer = netBuffer;
        } else {
            buffer = SSLUtils.allocateOutputBuffer(packetBufferSize * 2);
        }
        SSLConnectionContext.SslResult result = sslCtx.wrap(Buffers.EMPTY_BUFFER, buffer, HS_WRAP_ALLOCATOR);
        Buffer output = result.getOutput();
        output.flip();
        if (buffer != output && netBuffer != null && buffer == netBuffer) {
            netBuffer.flip();
        }
        if (result.isError()) {
            if (output != netBuffer) {
                output.dispose();
            }
            throw result.getError();
        }
        if (output != netBuffer) {
            output = SSLUtils.allowDispose(Buffers.appendBuffers(connection.getMemoryManager(), netBuffer, output));
        }
        return output;
    }

    static Buffer allocateOutputBuffer(int size) {
        boolean hasBuffer;
        Buffer buffer = ThreadCache.takeFromCache(SSL_OUTPUT_BUFFER_IDX);
        boolean bl = hasBuffer = buffer != null;
        if (!hasBuffer || buffer.remaining() < size) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(size);
            buffer = new ByteBufferWrapper(byteBuffer){

                @Override
                public void dispose() {
                    this.clear();
                    ThreadCache.putToCache(SSL_OUTPUT_BUFFER_IDX, this);
                }
            };
        }
        return buffer;
    }

    public static Buffer allocateInputBuffer(SSLConnectionContext sslCtx) {
        SSLEngine sslEngine = sslCtx.getSslEngine();
        if (sslEngine == null) {
            return null;
        }
        return SSLUtils.allocateOutputBuffer(sslCtx.getNetBufferSize() * 2);
    }

    static Buffer makeInputRemainder(SSLConnectionContext sslCtx, FilterChainContext context, Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (!buffer.hasRemaining()) {
            buffer.tryDispose();
            return null;
        }
        InputBufferWrapper inputBuffer = sslCtx.resetLastInputBuffer();
        if (inputBuffer == null) {
            Buffer remainder = buffer.split(buffer.position());
            buffer.tryDispose();
            return remainder;
        }
        return SSLUtils.move(context.getMemoryManager(), buffer);
    }

    static Buffer copy(MemoryManager memoryManager, Buffer buffer) {
        Object tmpBuf = memoryManager.allocate(buffer.remaining());
        tmpBuf.put(buffer);
        return tmpBuf.flip();
    }

    static Buffer move(MemoryManager memoryManager, Buffer buffer) {
        Buffer tmpBuf = SSLUtils.copy(memoryManager, buffer);
        buffer.tryDispose();
        return tmpBuf;
    }

    public static Buffer allowDispose(Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.allowBufferDispose(true);
        if (buffer.isComposite()) {
            ((CompositeBuffer)buffer).allowInternalBuffersDispose(true);
        }
        return buffer;
    }

    static SSLEngineResult sslEngineWrap(SSLEngine engine, ByteBuffer in, ByteBuffer out) throws SSLException {
        return engine.wrap(in, out);
    }

    static SSLEngineResult sslEngineWrap(SSLEngine engine, ByteBuffer[] in, int inOffs, int inLen, ByteBuffer out) throws SSLException {
        return ANDROID_WORKAROUND_NEEDED ? AndroidWorkAround.wrapArray(engine, in, inOffs, inLen, out) : engine.wrap(in, inOffs, inLen, out);
    }

    static SSLEngineResult sslEngineUnwrap(SSLEngine engine, ByteBuffer in, ByteBuffer out) throws SSLException {
        return engine.unwrap(in, out);
    }

    static SSLEngineResult sslEngineUnwrap(SSLEngine engine, ByteBuffer in, ByteBuffer[] out, int outOffs, int outLen) throws SSLException {
        return ANDROID_WORKAROUND_NEEDED ? AndroidWorkAround.unwrapArray(engine, in, out, outOffs, outLen) : engine.unwrap(in, out, outOffs, outLen);
    }

    static {
        boolean isNeedWorkAround = false;
        if ("android runtime".equalsIgnoreCase(System.getProperty("java.runtime.name"))) {
            try {
                int version = Class.forName("android.os.Build$VERSION").getField("SDK_INT").getInt(null);
                isNeedWorkAround = version >= 21;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ANDROID_WORKAROUND_NEEDED = isNeedWorkAround;
        SSL_CONNECTION_CTX_ATTR_NAME = SSLUtils.class + ".ssl-connection-context";
        SSL_CTX_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(SSL_CONNECTION_CTX_ATTR_NAME);
        HS_UNWRAP_ALLOCATOR = new SSLConnectionContext.Allocator(){

            @Override
            public Buffer grow(SSLConnectionContext sslCtx, Buffer oldBuffer, int newSize) {
                return SSLUtils.allocateOutputBuffer(newSize);
            }
        };
        HS_WRAP_ALLOCATOR = new SSLConnectionContext.Allocator(){

            @Override
            public Buffer grow(SSLConnectionContext sslCtx, Buffer oldBuffer, int newSize) {
                return SSLUtils.allocateOutputBuffer(newSize);
            }
        };
        SSL_OUTPUT_BUFFER_IDX = ThreadCache.obtainIndex(SSLBaseFilter.class.getName() + ".output-buffer-cache", Buffer.class, 4);
    }

    private static class AndroidWorkAround {
        private AndroidWorkAround() {
        }

        public static SSLEngineResult wrapArray(SSLEngine engine, ByteBuffer[] in, int inOffs, int inLen, ByteBuffer out) throws SSLException {
            if (inOffs == 0 && inLen == in.length) {
                return engine.wrap(in, out);
            }
            ByteBuffer[] tmp = new ByteBuffer[inLen];
            System.arraycopy(in, inOffs, tmp, 0, inLen);
            return engine.wrap(tmp, out);
        }

        public static SSLEngineResult unwrapArray(SSLEngine engine, ByteBuffer in, ByteBuffer[] out, int outOffs, int outLen) throws SSLException {
            if (outOffs == 0 && outLen == out.length) {
                return engine.unwrap(in, out);
            }
            ByteBuffer[] tmp = new ByteBuffer[outLen];
            System.arraycopy(out, outOffs, tmp, 0, outLen);
            return engine.unwrap(in, tmp);
        }
    }
}

